/* do actions according to game-level */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames4.h>
#include "main.h"

VG_BOOL gamelevel_before(struct s_game *);
VG_BOOL gamelevel_start(struct s_game *, struct g_level *);
VG_BOOL gamelevel_done(int);
void gamelevel_stop(struct s_game *);
void gamelevel_after(struct s_game *);


/* do anything before level-loop; return VG_TRUE=OK or VG_FALSE=error */
VG_BOOL
gamelevel_before(struct s_game *sgame)
{
  if (sgame == NULL) { return VG_FALSE; }

  /* create isnake */
  if (objnew_ISNAKE(sgame) == 0) { return VG_FALSE; }

  return VG_TRUE;
}


/* do anything before level; return VG_TRUE=OK or VG_FALSE=error */
VG_BOOL
gamelevel_start(struct s_game *sgame, struct g_level *glevel)
{
  if (sgame == NULL || glevel == NULL) { return VG_FALSE; }

  /* create ground and walls */
  if (objnew_GROUND(sgame, glevel) == 0) { return VG_FALSE; }

  /* reset isnake */
  { struct data_exchange dtex;
    memset(&dtex, 0, sizeof(dtex));
    dtex.type = DTEX_RESET;
    vg4->object->call_data(sgame, sgame->isnake_instanceid, &dtex);
  }

  /* create the management of esnakes */
  if (!objmgmt_ESNAKE(sgame, glevel->esnake_aktiv, glevel->esnake_max, glevel->loop_newsnake, glevel->kind)) { return VG_FALSE; }

  /* create camouflage hat */
  if (objnew_CAMHAT(sgame, glevel->camhat_no, glevel->camhat_yes) == 0) { return VG_FALSE; }

  /* create poison bottle */
  if (objnew_BOTTLE(sgame, glevel->bottle_no, glevel->bottle_yes) == 0) { return VG_FALSE; }

  return VG_TRUE;
}


/* check if level is through; return VG_TRUE=exit-level or VG_FALSE=goon */
VG_BOOL
gamelevel_done(int esnake_remain)
{
  if (esnake_remain == 0) { return VG_TRUE; }

  return VG_FALSE;
}


/* do anything after level */
void
gamelevel_stop(struct s_game *sgame)
{
  if (sgame == NULL) { return; }

  /* destroy all objects except isnake */
  vg4->object->destroy_objid(sgame, OBJID_BOTTLE, 0);
  vg4->object->destroy_objid(sgame, OBJID_CAMHAT, 0);
  vg4->object->destroy_objid(sgame, OBJID_ESNAKE, 0);
  vg4->object->destroy_objid(sgame, OBJID_SHOT, 0);
  vg4->object->destroy_objid(sgame, OBJID_GROUND, 0);
  vg4->object->mgmt_destroy(OBJID_ESNAKE);
}


/* do anything after level-loop */
void
gamelevel_after(struct s_game *sgame)
{
  if (sgame == NULL) { return; }

  /* destroy isnake */
  vg4->object->destroy_objid(sgame, OBJID_ISNAKE, 0);
}
