/* create level-data */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include <vgagames4.h>
#include "leveldata.h"

#define ZUFALL(P1, P2)  vg4->random->get("LEVELDATA", (P1), (P2))

VG_BOOL leveldata(int, struct g_level *, int);

#if 0
int
main(int argc, char **argv)
{
  int level, i1, difficulty;
  struct g_level levdata;

  VG_init("leveldata");
  difficulty = 0;
  for (level = 1;; level++) {
    if (!leveldata(level, &levdata, difficulty)) { break; }
    printf("Level %d:", level);
    for (i1 = 0; i1 < levdata.esnake_max; i1++) { printf(" %d", levdata.kind[i1]); }
    printf("\n");
  }
  VG_dest();

  exit(0);
}
#endif


/* fill levdata with data of level, return VG_TRUE=OK or VG_FALSE=end-of-levels */
VG_BOOL
leveldata(int level, struct g_level *levdata, int difficulty)
{
  int i1, i2;

  if (levdata == NULL) { return VG_FALSE; }
  memset(levdata, 0, sizeof(*levdata));

  if (level == 1) {
    levdata->bgno = 1;
    levdata->bgbright = 60;
    levdata->bgcolor = 0x6d8000;
    levdata->esnake_aktiv = 4;
    levdata->esnake_max = 15;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      levdata->kind[i1] = 0;
      if (i1 > levdata->esnake_max / 2) {
        i2 = ZUFALL(0, 9);
        if (i2 < 4) { levdata->kind[i1]++; }
      }
    }
    levdata->loop_newsnake = 900 + ZUFALL(50, 100);
    levdata->bottle_no = 2100 - (!!difficulty * 200);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3200;
    levdata->camhat_yes = 800;

  } else if (level == 2) {
    levdata->bgno = 1;
    levdata->bgbright = 60;
    levdata->bgcolor = 0x498037;
    levdata->esnake_aktiv = 5;
    levdata->esnake_max = 25;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      i2 = ZUFALL(0, 1);
      levdata->kind[i1] = 0 + i2;
    }
    levdata->loop_newsnake = 1000 + ZUFALL(50, 100);
    levdata->bottle_no = 2100 - (!!difficulty * 200);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3200;
    levdata->camhat_yes = 800;

  } else if (level == 3) {
    levdata->bgno = 1;
    levdata->bgbright = 60;
    levdata->bgcolor = 0x807848;
    levdata->esnake_aktiv = 5;
    levdata->esnake_max = 20;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      levdata->kind[i1] = 2;
      if (i1 < levdata->esnake_max / 6) {
        i2 = ZUFALL(0, 9);
        if (i2 >= 4) { levdata->kind[i1]--; }
      } else if (i1 > levdata->esnake_max / 3) {
        i2 = ZUFALL(0, 9);
        if (i2 < 4) { levdata->kind[i1]++; }
      }
      i2 = ZUFALL(0, 8); if (i2 == 0) { levdata->kind[i1] = 0; }
    }
    levdata->loop_newsnake = 900 + ZUFALL(90, 180);
    levdata->bottle_no = 1900 - (!!difficulty * 200);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3000;
    levdata->camhat_yes = 800;

  } else if (level == 4) {
    levdata->bgno = 1;
    levdata->bgbright = 60;
    levdata->bgcolor = 0x805b49;
    levdata->esnake_aktiv = 6;
    levdata->esnake_max = 30;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      i2 = ZUFALL(0, 1);
      levdata->kind[i1] = 2 + i2;
      i2 = ZUFALL(0, 8); if (i2 == 0) { levdata->kind[i1] = 0; }
    }
    levdata->loop_newsnake = 1000 + ZUFALL(50, 100);
    levdata->bottle_no = 2100 - (!!difficulty * 200);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3200;
    levdata->camhat_yes = 800;

  } else if (level == 5) {
    levdata->bgno = 1;
    levdata->bgbright = 60;
    levdata->bgcolor = 0x804949;
    levdata->esnake_aktiv = 5;
    levdata->esnake_max = 25;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      levdata->kind[i1] = 4;
      if (i1 < levdata->esnake_max / 6) {
        i2 = ZUFALL(0, 9);
        if (i2 >= 4) { levdata->kind[i1]--; }
      } else if (i1 > levdata->esnake_max / 3) {
        i2 = ZUFALL(0, 9);
        if (i2 < 4) { levdata->kind[i1]++; }
      }
      i2 = ZUFALL(0, 10); if (i2 == 0) { levdata->kind[i1] = 0; }
    }
    levdata->loop_newsnake = 900 + ZUFALL(75, 150);
    levdata->bottle_no = 1900 - (!!difficulty * 200);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 2800;
    levdata->camhat_yes = 800;

  } else if (level == 6) {
    levdata->bgno = 1;
    levdata->bgbright = 60;
    levdata->bgcolor = 0x804900;
    levdata->esnake_aktiv = 6;
    levdata->esnake_max = 30;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      i2 = ZUFALL(0, 1);
      levdata->kind[i1] = 4 + i2;
      i2 = ZUFALL(0, 10); if (i2 == 0) { levdata->kind[i1] = 0; }
    }
    levdata->loop_newsnake = 1000 + ZUFALL(75, 150);
    levdata->bottle_no = 2100 - (!!difficulty * 200);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 2800;
    levdata->camhat_yes = 800;

  } else if (level == 7) {
    levdata->bgno = 2;
    levdata->bgbright = 70;
    levdata->bgcolor = 0x804080;
    levdata->esnake_aktiv = 4;
    levdata->esnake_max = 25;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      levdata->kind[i1] = 6;
      if (i1 < levdata->esnake_max / 6) {
        i2 = ZUFALL(0, 9);
        if (i2 >= 4) { levdata->kind[i1]--; }
      } else if (i1 > levdata->esnake_max / 3) {
        i2 = ZUFALL(0, 9);
        if (i2 < 4) { levdata->kind[i1]++; }
      }
      i2 = ZUFALL(0, 12); if (i2 == 0) { levdata->kind[i1] = 0; }
    }
    levdata->loop_newsnake = 900 + ZUFALL(80, 160);
    levdata->bottle_no = 1700 - (!!difficulty * 300);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3500;
    levdata->camhat_yes = 800;

  } else if (level == 8) {
    levdata->bgno = 2;
    levdata->bgbright = 70;
    levdata->bgcolor = 0x5b2580;
    levdata->esnake_aktiv = 5;
    levdata->esnake_max = 30;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      i2 = ZUFALL(0, 1);
      levdata->kind[i1] = 6 + i2;
      i2 = ZUFALL(0, 12); if (i2 == 0) { levdata->kind[i1] = 0; }
    }
    levdata->loop_newsnake = 1000 + ZUFALL(80, 160);
    levdata->bottle_no = 1500 - (!!difficulty * 300);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3400;
    levdata->camhat_yes = 800;

  } else if (level == 9) {
    levdata->bgno = 2;
    levdata->bgbright = 70;
    levdata->bgcolor = 0x134980;
    levdata->esnake_aktiv = 5;
    levdata->esnake_max = 25;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      levdata->kind[i1] = 8;
      if (i1 < levdata->esnake_max / 6) {
        i2 = ZUFALL(0, 9);
        if (i2 >= 4) { levdata->kind[i1]--; }
      } else if (i1 == levdata->esnake_max - 1) {
        levdata->kind[i1]++;
      }
    }
    levdata->loop_newsnake = 900 + ZUFALL(65, 130);
    levdata->bottle_no = 1700 - (!!difficulty * 300);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 3800;
    levdata->camhat_yes = 800;

  } else if (level == 10) {
    levdata->bgno = 2;
    levdata->bgbright = 70;
    levdata->bgcolor = 0x250080;
    levdata->esnake_aktiv = 2;
    levdata->esnake_max = 5;
    if (difficulty > 0) {
      levdata->esnake_aktiv += levdata->esnake_aktiv / 2;
      levdata->esnake_max += levdata->esnake_max / 2;
    }
    if (levdata->esnake_max > LEVEL_ESNAKE_MAX) { levdata->esnake_max = LEVEL_ESNAKE_MAX; }
    for (i1 = 0; i1 < levdata->esnake_max; i1++) {
      levdata->kind[i1] = 9;
    }
    levdata->loop_newsnake = 1500 + ZUFALL(50, 200);
    levdata->bottle_no = 1300 - (!!difficulty * 300);
    levdata->bottle_yes = 800;
    levdata->camhat_no = 9999;
    levdata->camhat_yes = 0;
  } else {
    return VG_FALSE;
  }

  return VG_TRUE;
}
