#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames4.h>
#include "leveldata.h"

/* include object-IDs */
#include "objid.h"

/* include exported object-functions */
#include "objfn.h"

/* data exchange struct used with object's f_data() */
struct data_exchange {
  enum { DTEX_RESET = 1, DTEX_LIMBS } type;
  union {
    int limb_anz;  /* for type = DTEX_LIBMS */
  } u;
};

/* individual data settings */
struct iset_data {
  int isnake_health;       /* health of player's snake in percent */
  int idx_level;           /* actual level-index (beginning with 0) */
  int difficulty;          /* 0 = easy, 1 = hard */
};

/* private structure of the game */
struct s_game {
  int winw, winh;             /* window's width and height */
  struct VG_Rect grect;       /* rectangle of ground */
  struct iset_data iset_old;  /* old individual data settings */
  struct iset_data iset_new;  /* new individual data settings */
  unsigned int coll_tag;      /* collision-tag */
  unsigned int isnake_instanceid;  /* instance-ID of OBJID_ISNAKE */

  struct {                    /* keys */
    int k_quit_lalt;            /* part of quit: Left-ALT */
    int k_quit_q;               /* part of quit: Q */
    int k_sysmenu;              /* system-menu */
    int k_help;                 /* help */
    int k_pause;                /* pause */
    int k_up;                   /* move up */
    int k_down;                 /* move down */
    int k_left;                 /* move left */
    int k_right;                /* move right */
    int k_shoot;                /* shoot */
  } kref;
};

#endif /* MAIN_H_ */
