/* object OBJID_CAMHAT */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-camhat.h"

unsigned int objnew_CAMHAT(void *, int, int);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of OBJID_CAMHAT
 * @param vgame       private structure of the game
 * @param camhat_no   number of loops camouflage hat is inactive
 * @param camhat_yes  number of loops camouflage hat is active
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_CAMHAT(void *vgame, int camhat_no, int camhat_yes)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_camhat *objvars;

  if (sgame == NULL || camhat_no <= 0 || camhat_yes < 0) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  objvars->camhat_no = camhat_no;
  objvars->camhat_yes = camhat_yes;
  objvars->camhat_loop = -camhat_no;

  /* load sprite */
  objvars->sprt = vg4->sprite->load("files/sprites/tarnkp.sprite");
  if (objvars->sprt == NULL) { f_free(vgame, objvars); return 0; }
  vg4->sprite->imagesize(objvars->sprt, "avg", &objvars->rect.w, &objvars->rect.h);

  /* load sound */
  objvars->snd_camhat = vg4->audio->load("files/audio/tarnkappe.wav", 100, VG_AUDIO_VOLUME_SOUND);

  /* create object-instance */
  objp = vg4->object->create(OBJID_CAMHAT, 0, 0, 2, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_camhat *objvars = (struct sobj_camhat *)opriv;

  (void)vgame;

  /* free private struct */
  if (objvars->sprt != NULL) { vg4->sprite->destroy(objvars->sprt); }
  if (objvars->snd_camhat > 0) { vg4->audio->unload(objvars->snd_camhat); }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_camhat *objvars = (struct sobj_camhat *)objp->opriv;

  if (sgame == NULL) { return VG_TRUE; }
  if (objvars->camhat_yes < 1) { return VG_TRUE; }

  objvars->camhat_loop++;

  if (objvars->camhat_loop == 0) {  /* activate camouflage hat */
    /* insert camouflage hat with actual position into collision-tag */
    vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rect, 100);
    /* find an position without collisions */
    for (;;) {
      /* get random position */
      objvars->rect.x = vg4->random->get(OBJID_CAMHAT, sgame->grect.x, sgame->grect.x + sgame->grect.w - objvars->rect.w);
      objvars->rect.y = vg4->random->get(OBJID_CAMHAT, sgame->grect.y, sgame->grect.y + sgame->grect.h - objvars->rect.h);
      /* check for collisions: if none, use position */
      if (vg4->collision->setpos(sgame->coll_tag, objp->instanceid, &objvars->rect, NULL) == 0) { break; }
    }
    vg4->sprite->rewind(objvars->sprt);

  } else if (objvars->camhat_loop == objvars->camhat_yes) {  /* deactivate camouflage hat */
    /* remove camouflage hat from collision-tag */
    vg4->collision->remove(sgame->coll_tag, objp->instanceid);
    /* set number of loops to reactivate */
    objvars->camhat_loop = -objvars->camhat_no;
  }

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_camhat *objvars = (struct sobj_camhat *)objp->opriv;
  struct VG_Image *imgp;
  struct VG_ImagecopyAttr iattr;

  (void)vgame;

  if (objvars->camhat_loop < 0) { return; }

  if (vg4->sprite->next(objvars->sprt, &imgp, &iattr) && imgp != NULL) {
    struct VG_Position posi;
    vg4->window->copy(imgp, vg4->misc->rect2position(&posi, &objvars->rect), &iattr);
  }
}
