#ifndef OBJ_ESNAKE_H_
#define OBJ_ESNAKE_H_

#include "main.h"

typedef enum {
  ES_MOVING_DIR_UP = 0,
  ES_MOVING_DIR_RIGHT,
  ES_MOVING_DIR_DOWN,
  ES_MOVING_DIR_LEFT,
} ES_MOVING_DIRS;

struct es_limb {
  int x, y, movdir;
};

struct es_kind {
  int limb_max;
  int poison_max;
  int poison_strength;
  int moving_factor;
};

#define ESNAKE_LIMB_MAX 15

/* private structure for object OBJID_ESNAKE */
struct sobj_esnake {
  struct es_kind kind;               /* kind of esnake */
  struct VG_RectCent rectc;          /* position of esnake */
  int keep_moving;                   /* how many loops keep moving-direction */
  int rand_poison;                   /* number for calculating random poison-shots */
  int limb_anz;                      /* actual number of esnake-limbs */
  int movdir;                        /* moving direction: ES_MOVING_DIRS */
  int poison_shots;                  /* how many poison-shots are running */
  int camhat;                        /* camouflage hat: how many loops valid */
  int dying;                         /* been eaten: how many loops */
  int snd_hit;                       /* sound, when hit */
  int snd_dead;                      /* sound, when dead */
  int snd_come;                      /* sound, when coming out */
  int limbidx[ESNAKE_LIMB_MAX];      /* index in limbstream for limbs */
  int limbstream_size;               /* size of limbstream in struct es_limb */
  struct es_limb *limbstream;        /* position of each pixel of esnake limbs */
  struct VG_Image *img_head_short;   /* image of esnake-head if shorter or equal to isnake */
  struct VG_Image *img_head_long;    /* image of esnake-head if longer than isnake */
  struct VG_Image *img_eye;          /* image of esnake-eye */
  struct VG_Image *img_limb;         /* image of esnake-limb */
  struct VG_Image *img_tg[4];        /* images of esnake-tongue */
};

#endif /* OBJ_ESNAKE_H_ */
