#ifndef OBJ_ISNAKE_H_
#define OBJ_ISNAKE_H_

#include "main.h"

typedef enum {
  IS_MOVING_DIR_UP = 0,
  IS_MOVING_DIR_RIGHT,
  IS_MOVING_DIR_DOWN,
  IS_MOVING_DIR_LEFT,
} IS_MOVING_DIRS;

struct is_limb {
  int x, y, movdir;
};

#define ISNAKE_LIMB_MAX 8

/* private structure for object OBJID_ISNAKE */
struct sobj_isnake {
  struct VG_RectCent rectc;      /* position of isnake */
  int limb_anz;                  /* actual number of isnake-limbs */
  int movdir;                    /* moving direction: IS_MOVING_DIRS */
  VG_BOOL poison_shot;           /* whether poison-shot is running */
  int camhat;                    /* camouflage hat: how many loops valid */
  int eating;                    /* eating an enemy snake: how many loops */
  int snd_hit;                   /* sound, when hit */
  int snd_spit;                  /* sound, when spitting poison */
  int limbidx[ISNAKE_LIMB_MAX];  /* index in limbstream for limbs */
  int limbstream_size;           /* size of limbstream in struct is_limb */
  struct is_limb *limbstream;    /* position of each pixel of isnake limbs */
  struct VG_Image *img_head;     /* image of isnake-head */
  struct VG_Image *img_dead;     /* image of dead-head */
  struct VG_Image *img_eye;      /* image of isnake-eye */
  struct VG_Image *img_limb;     /* image of isnake-limb */
  struct VG_Image *img_tg[4];    /* images of isnake-tongue */
};

#endif /* OBJ_ISNAKE_H_ */
