/* object OBJID_WALL */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-wall.h"

unsigned int objnew_WALL(void *, struct VG_Rect *);

static void f_free(void *, void *);


/* export-function to create a new object-instance of OBJID_WALL
 * @param vgame     private structure of the game
 * @param rect      rectangle of wall
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_WALL(void *vgame, struct VG_Rect *rect)
{
  const int coll_percent = 100;
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_wall *objvars;

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* set rectangle */
  objvars->rect = *rect;

  /* create object-instance */
  objp = vg4->object->create(OBJID_WALL, 0, 0, 1, objvars);
  objp->f_free = f_free;

  /* insert object-instance into collision-tag */
  vg4->collision->insert(sgame->coll_tag, objp->instanceid, &objvars->rect, coll_percent);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_wall *objvars = (struct sobj_wall *)opriv;

  (void)vgame;

  /* free private struct */
  free(objvars);
}
