/* object-collision OBJID_ISNAKE (moving) against OBJID_BOTTLE (not moving) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-bottle.h"
#include "obj-isnake.h"

int objcoll_BOTTLE_ISNAKE(void *, unsigned int, struct VG_Coll *);


int
objcoll_BOTTLE_ISNAKE(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp_bottle, *objp_isnake;
  struct sobj_bottle *objvars_bottle;
  struct sobj_isnake *objvars_isnake;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  /* moving: isnake */
  objp_isnake = vg4->object->instance_getobj(instanceid);
  objvars_isnake = (struct sobj_isnake *)objp_isnake->opriv;

  /* colliding with: bottle */
  objp_bottle = vg4->object->instance_getobj(collb->instanceid);
  objvars_bottle = (struct sobj_bottle *)objp_bottle->opriv;

  if (objvars_isnake->limb_anz < ISNAKE_LIMB_MAX) {
    /* isnake gets another limb */
    objvars_isnake->limb_anz++;
    sgame->iset_new.isnake_health = objvars_isnake->limb_anz * 100 / ISNAKE_LIMB_MAX;
    /* play drinking audio */
    vg4->audio->play(objvars_bottle->snd_bottle, VG_FALSE, VG_FALSE);
    /* remove bottle from collision-tag */
    vg4->collision->remove(sgame->coll_tag, objp_bottle->instanceid);
    /* set number of loops to reactivate */
    objvars_bottle->bottle_loop = -objvars_bottle->bottle_no;
  }

  return retw;
}
