/* object-collision OBJID_ESNAKE (moving) against OBJID_CAMHAT (not moving) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-camhat.h"
#include "obj-esnake.h"

int objcoll_CAMHAT_ESNAKE(void *, unsigned int, struct VG_Coll *);


int
objcoll_CAMHAT_ESNAKE(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp_camhat, *objp_esnake;
  struct sobj_camhat *objvars_camhat;
  struct sobj_esnake *objvars_esnake;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  /* moving: esnake */
  objp_esnake = vg4->object->instance_getobj(instanceid);
  objvars_esnake = (struct sobj_esnake *)objp_esnake->opriv;

  /* colliding with: camhat */
  objp_camhat = vg4->object->instance_getobj(collb->instanceid);
  objvars_camhat = (struct sobj_camhat *)objp_camhat->opriv;

  if (objvars_esnake->limb_anz > 0 && objvars_esnake->camhat == 0) {
    /* esnake puts camouflage hat on */
    objvars_esnake->camhat = 500;
    /* play putting-on audio */
    vg4->audio->play(objvars_camhat->snd_camhat, VG_FALSE, VG_FALSE);
    /* remove camhat from collision-tag */
    vg4->collision->remove(sgame->coll_tag, objp_camhat->instanceid);
    /* set number of loops to reactivate */
    objvars_camhat->camhat_loop = -objvars_camhat->camhat_no;
  }

  return retw;
}
