/* object-collision OBJID_ISNAKE (moving) against OBJID_CAMHAT (not moving) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-camhat.h"
#include "obj-isnake.h"

int objcoll_CAMHAT_ISNAKE(void *, unsigned int, struct VG_Coll *);


int
objcoll_CAMHAT_ISNAKE(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp_camhat, *objp_isnake;
  struct sobj_camhat *objvars_camhat;
  struct sobj_isnake *objvars_isnake;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  /* moving: isnake */
  objp_isnake = vg4->object->instance_getobj(instanceid);
  objvars_isnake = (struct sobj_isnake *)objp_isnake->opriv;

  /* colliding with: camhat */
  objp_camhat = vg4->object->instance_getobj(collb->instanceid);
  objvars_camhat = (struct sobj_camhat *)objp_camhat->opriv;

  if (objvars_isnake->limb_anz > 0 && objvars_isnake->camhat == 0) {
    /* isnake puts camouflage hat on */
    objvars_isnake->camhat = 500;
    /* play putting-on audio */
    vg4->audio->play(objvars_camhat->snd_camhat, VG_FALSE, VG_FALSE);
    /* remove camhat from collision-tag */
    vg4->collision->remove(sgame->coll_tag, objp_camhat->instanceid);
    /* set number of loops to reactivate */
    objvars_camhat->camhat_loop = -objvars_camhat->camhat_no;
  }

  return retw;
}
