/* object-collision OBJID_ISNAKE (moving) against OBJID_ESNAKE (moving) and reverse */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-isnake.h"
#include "obj-esnake.h"

int objcoll_ISNAKE_ESNAKE(void *, unsigned int, struct VG_Coll *);


int
objcoll_ISNAKE_ESNAKE(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp, *objp_isnake, *objp_esnake;
  struct sobj_isnake *objvars_isnake;
  struct sobj_esnake *objvars_esnake;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  objp = vg4->object->instance_getobj(instanceid);
  if (strcmp(objp->objid, OBJID_ISNAKE) == 0) {  /* isnake moving */
    objp_isnake = vg4->object->instance_getobj(instanceid);
    objvars_isnake = (struct sobj_isnake *)objp_isnake->opriv;
    objp_esnake = vg4->object->instance_getobj(collb->instanceid);
    objvars_esnake = (struct sobj_esnake *)objp_esnake->opriv;
  } else {  /* esnake moving */
    objp_esnake = vg4->object->instance_getobj(instanceid);
    objvars_esnake = (struct sobj_esnake *)objp_esnake->opriv;
    objp_isnake = vg4->object->instance_getobj(collb->instanceid);
    objvars_isnake = (struct sobj_isnake *)objp_isnake->opriv;
  }

  if (objvars_isnake->limb_anz == 0) { return retw; }
  if (objvars_esnake->limb_anz == 0) { return retw; }
  if (objvars_esnake->camhat > 0) { return retw; }
    
  /* esnake greater than isnake? */
  if (objvars_isnake->camhat == 0 && objvars_esnake->limb_anz > objvars_isnake->limb_anz) {
    objvars_isnake->limb_anz -= (objvars_esnake->limb_anz - objvars_isnake->limb_anz);
    sgame->iset_new.isnake_health = objvars_isnake->limb_anz * 100 / ISNAKE_LIMB_MAX;
    if (objvars_isnake->limb_anz <= 0) {  /* last limb destroyed: isnake dead */
      objvars_isnake->limb_anz = 0;
      sgame->iset_new.isnake_health = 0;
    }
    vg4->audio->play(objvars_isnake->snd_hit, VG_FALSE, VG_FALSE);
  }

  if (objvars_isnake->limb_anz > 0) {
    objvars_isnake->eating = objvars_esnake->dying = objvars_esnake->limb_anz * 10;
    vg4->audio->play(objvars_esnake->snd_dead, VG_FALSE, VG_FALSE);
  }

  retw = VG_COLL_RETURN_STOP;

  return retw;
}
