/* object-collision OBJID_SHOT (moving) against OBJID_ESNAKE (moving) and reverse */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-shot.h"
#include "obj-esnake.h"

int objcoll_SHOT_ESNAKE(void *, unsigned int, struct VG_Coll *);


int
objcoll_SHOT_ESNAKE(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp, *objp_shot, *objp_esnake, *objpparent_shot;
  struct sobj_shot *objvars_shot;
  struct sobj_esnake *objvars_esnake;
  VG_BOOL moving_shot;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  objp = vg4->object->instance_getobj(instanceid);
  if (strcmp(objp->objid, OBJID_SHOT) == 0) {  /* shot moving */
    objp_shot = vg4->object->instance_getobj(instanceid);
    objvars_shot = (struct sobj_shot *)objp_shot->opriv;
    objp_esnake = vg4->object->instance_getobj(collb->instanceid);
    objvars_esnake = (struct sobj_esnake *)objp_esnake->opriv;
    moving_shot = VG_TRUE;
  } else {  /* esnake moving */
    objp_esnake = vg4->object->instance_getobj(instanceid);
    objvars_esnake = (struct sobj_esnake *)objp_esnake->opriv;
    objp_shot = vg4->object->instance_getobj(collb->instanceid);
    objvars_shot = (struct sobj_shot *)objp_shot->opriv;
    moving_shot = VG_FALSE;
  }

  if (objvars_esnake->limb_anz == 0) { return retw; }
  if (objvars_esnake->camhat > 0) { return retw; }

  /* if shot's parent is isnake, esnake is being hit */
  objpparent_shot = vg4->object->instance_getobj(objp_shot->parent_instanceid);
  if (objpparent_shot != NULL && strcmp(objpparent_shot->objid, OBJID_ISNAKE) == 0) {
    objvars_esnake->limb_anz -= objvars_shot->poison_strength;
    if (objvars_esnake->limb_anz <= 0) {  /* last limb destroyed: esnake dead */
      objvars_esnake->limb_anz = 0;
      vg4->audio->play(objvars_esnake->snd_dead, VG_FALSE, VG_FALSE);
      if (!moving_shot) { retw = VG_COLL_RETURN_DEAD; }  /* esnake moves */
    } else {
      vg4->audio->play(objvars_esnake->snd_hit, VG_FALSE, VG_FALSE);
    }

    /* change direction of esnake to anti-direction of shot */
    objvars_esnake->keep_moving = vg4->random->get(OBJID_SHOT "-" OBJID_ESNAKE, 50, 200);
    objvars_esnake->rectc.centx = objvars_esnake->rectc.centy = 0;
    if (objvars_shot->angle == 0) {
      objvars_esnake->movdir = ES_MOVING_DIR_DOWN;
    } else if (objvars_shot->angle == 180) {
      objvars_esnake->movdir = ES_MOVING_DIR_UP;
    } else if (objvars_shot->angle == 270) {
      objvars_esnake->movdir = ES_MOVING_DIR_RIGHT;
    } else {
      objvars_esnake->movdir = ES_MOVING_DIR_LEFT;
    }

    /* shot is dead */
    if (moving_shot) {  /* shot moving, return dead */
      retw = VG_COLL_RETURN_DEAD;
    } else {  /* esnake moving, destroy shot */
      vg4->object->destroy(vgame, objp_shot->instanceid);
    }
  }

  return retw;
}
