/* object-collision OBJID_SHOT (moving) against OBJID_ISNAKE (moving) and reverse */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-shot.h"
#include "obj-isnake.h"

int objcoll_SHOT_ISNAKE(void *, unsigned int, struct VG_Coll *);


int
objcoll_SHOT_ISNAKE(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp, *objp_shot, *objp_isnake, *objpparent_shot;
  struct sobj_shot *objvars_shot;
  struct sobj_isnake *objvars_isnake;
  VG_BOOL moving_shot;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  objp = vg4->object->instance_getobj(instanceid);
  if (strcmp(objp->objid, OBJID_SHOT) == 0) {  /* shot moving */
    objp_shot = vg4->object->instance_getobj(instanceid);
    objvars_shot = (struct sobj_shot *)objp_shot->opriv;
    objp_isnake = vg4->object->instance_getobj(collb->instanceid);
    objvars_isnake = (struct sobj_isnake *)objp_isnake->opriv;
    moving_shot = VG_TRUE;
  } else {  /* isnake moving */
    objp_isnake = vg4->object->instance_getobj(instanceid);
    objvars_isnake = (struct sobj_isnake *)objp_isnake->opriv;
    objp_shot = vg4->object->instance_getobj(collb->instanceid);
    objvars_shot = (struct sobj_shot *)objp_shot->opriv;
    moving_shot = VG_FALSE;
  }

  if (objvars_isnake->limb_anz == 0) { return retw; }
  if (objvars_isnake->camhat > 0) { return retw; }

  /* if shot's parent is esnake or dead, isnake is being hit */
  objpparent_shot = vg4->object->instance_getobj(objp_shot->parent_instanceid);
  if (objpparent_shot == NULL || strcmp(objpparent_shot->objid, OBJID_ESNAKE) == 0) {
    objvars_isnake->limb_anz -= objvars_shot->poison_strength;
    sgame->iset_new.isnake_health = objvars_isnake->limb_anz * 100 / ISNAKE_LIMB_MAX;
    if (objvars_isnake->limb_anz <= 0) {  /* last limb destroyed: isnake dead */
      objvars_isnake->limb_anz = 0;
      sgame->iset_new.isnake_health = 0;
      if (!moving_shot) { retw = VG_COLL_RETURN_DEAD; }  /* isnake moves */
    }
    vg4->audio->play(objvars_isnake->snd_hit, VG_FALSE, VG_FALSE);

    /* shot is dead */
    if (moving_shot) {  /* shot moving, return dead */
      retw = VG_COLL_RETURN_DEAD;
    } else {  /* isnake moving, destroy shot */
      vg4->object->destroy(vgame, objp_shot->instanceid);
    }
  }

  return retw;
}
