/* object-collision OBJID_SHOT (moving) against OBJID_SHOT (moving) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-shot.h"

int objcoll_SHOT_SHOT(void *, unsigned int, struct VG_Coll *);


int
objcoll_SHOT_SHOT(void *vgame, unsigned int instanceid, struct VG_Coll *collb)
{
  struct s_game *sgame;
  struct VG_Object *objp_shot1, *objp_shot2, *objpparent_shot1, *objpparent_shot2;
  int retw = VG_COLL_RETURN_CONTINUE;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return retw; }

  if (collb->type != VG_COLL_TYPE_ENTRY) { return retw; }

  objp_shot1 = vg4->object->instance_getobj(instanceid);
  objp_shot2 = vg4->object->instance_getobj(collb->instanceid);

  /* no collision, if parent-object-IDs of both shots are equal */
  objpparent_shot1 = vg4->object->instance_getobj(objp_shot1->parent_instanceid);
  objpparent_shot2 = vg4->object->instance_getobj(objp_shot2->parent_instanceid);
  if (objpparent_shot1 == NULL || objpparent_shot2 == NULL
      || strcmp(objpparent_shot1->objid, objpparent_shot2->objid) == 0) { return retw; }

  /* both shots are dead */
  vg4->object->destroy(vgame, objp_shot2->instanceid);
  retw = VG_COLL_RETURN_DEAD;

  return retw;
}
