#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"

void objcoll(void);

extern int objcoll_BOTTLE_ESNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_BOTTLE_ISNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_CAMHAT_ESNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_CAMHAT_ISNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_ESNAKE_WALL(void *, unsigned int, struct VG_Coll *);
extern int objcoll_ISNAKE_WALL(void *, unsigned int, struct VG_Coll *);
extern int objcoll_ISNAKE_ESNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_SHOT_ESNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_SHOT_ISNAKE(void *, unsigned int, struct VG_Coll *);
extern int objcoll_SHOT_SHOT(void *, unsigned int, struct VG_Coll *);
extern int objcoll_SHOT_WALL(void *, unsigned int, struct VG_Coll *);


/* add object-collision functions */
void objcoll(void)
{
  vg4->object->collision_add(OBJID_BOTTLE, OBJID_ESNAKE, objcoll_BOTTLE_ESNAKE);
  vg4->object->collision_add(OBJID_BOTTLE, OBJID_ISNAKE, objcoll_BOTTLE_ISNAKE);
  vg4->object->collision_add(OBJID_CAMHAT, OBJID_ESNAKE, objcoll_CAMHAT_ESNAKE);
  vg4->object->collision_add(OBJID_CAMHAT, OBJID_ISNAKE, objcoll_CAMHAT_ISNAKE);
  vg4->object->collision_add(OBJID_ESNAKE, OBJID_WALL, objcoll_ESNAKE_WALL);
  vg4->object->collision_add(OBJID_ISNAKE, OBJID_WALL, objcoll_ISNAKE_WALL);
  vg4->object->collision_add(OBJID_ISNAKE, OBJID_ESNAKE, objcoll_ISNAKE_ESNAKE);
  vg4->object->collision_add(OBJID_SHOT, OBJID_ESNAKE, objcoll_SHOT_ESNAKE);
  vg4->object->collision_add(OBJID_SHOT, OBJID_ISNAKE, objcoll_SHOT_ISNAKE);
  vg4->object->collision_add(OBJID_SHOT, OBJID_SHOT, objcoll_SHOT_SHOT);
  vg4->object->collision_add(OBJID_SHOT, OBJID_WALL, objcoll_SHOT_WALL);
}
