#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames4.h>

/* include object-IDs */
#include "objid.h"

/* include exported object-functions */
#include "objfn.h"

#define MAP_SHIFT  4

/* directions */
#define WAND_NORD    1
#define WAND_OST     2
#define WAND_SUED    4
#define WAND_WEST    8
  
/* additional bit-values for map: torch */
#define TORCH_SHIFT  (MAP_SHIFT * 1)
#define TORCH_NORD   (WAND_NORD << TORCH_SHIFT)
#define TORCH_OST    (WAND_OST  << TORCH_SHIFT)
#define TORCH_SUED   (WAND_SUED << TORCH_SHIFT)
#define TORCH_WEST   (WAND_WEST << TORCH_SHIFT)
  
/* additional bit-values for map: secret wall-portal */
#define PORTAL_SHIFT  (MAP_SHIFT * 2)
#define PORTAL_NORD   (WAND_NORD << PORTAL_SHIFT)
#define PORTAL_OST    (WAND_OST  << PORTAL_SHIFT)
#define PORTAL_SUED   (WAND_SUED << PORTAL_SHIFT)
#define PORTAL_WEST   (WAND_WEST << PORTAL_SHIFT)
    
/* additional bit-values for map: items */
#define ITEM_SHIFT     (MAP_SHIFT * 3)
#define ITEM_GARLIC    (1 << ITEM_SHIFT)
#define ITEM_VALERIAN  (2 << ITEM_SHIFT)
#define ITEM_JEWEL     (4 << ITEM_SHIFT)

/* random number from P1 to P2 inclusive */
#define ZUFALL(P1, P2)  vg4->random->get(NULL, (P1), (P2))


/* way to walk in the maze */
#define WALK_MAX  512
struct walking_way {
  int anz, pos;
  struct {
    int x, y;
  } way[WALK_MAX];
};

/* object in maze */
struct obj_pos {
  int x, y, dir, prz;     /* position, direction and percent */
  struct VG_Image *img;   /* actual image */
  struct VG_ImagecopyAttr attr;  /* actual image-attributes */
  int u_pg;               /* 1=player, 2=ghost/minotaur */
  union {
    struct {
      int lamp_ontime;           /* how many loops players lamp is switched on */
      VG_BOOL garlic;            /* whether player smells of garlic */
    } ply;
    struct {
      struct walking_way *wway;  /* walking way of ghost or minotaur */
      VG_BOOL do_follow;         /* whether follows player */
    } gh;
  } u;
};


/* private structure of the game */
struct s_game {
  int winw, winh;             /* window's width and height */
  int clock, clockdelta;      /* clock timer, delta of clock */

  struct {                    /* common data for local player */
    unsigned int instanceid;    /* instanceID of player */
    int x, y, dir;              /* x-position, y-position and direction */
    int go, turn;               /* whether going or turning */
    int fear;                   /* player's fear */
    int dead;                   /* whether player is dead: 0 = done, 1 = minotaur-dead, 2 = ghost-dead */
    int map;                    /* whether map is shown */
    VG_BOOL lamp;               /* whether lamp is switched on */
    int garlic;                 /* amount of player's garlic smell */
    VG_BOOL jewel;              /* whether player has jewel */
    char **mapvisited;          /* visited positions in map */
  } ply;

  struct {                    /* data for maze */
    unsigned short **map;
    int wsize, hsize;
    int exit_x, exit_y, exit_dir;
  } maze;

  struct {                    /* keys */
    int k_quit_lalt;            /* part of quit: Left-ALT */
    int k_quit_q;               /* part of quit: Q */
    int k_sysmenu;              /* system-menu */
    int k_help;                 /* help */
    int k_pause;                /* pause */
    int k_forward;              /* go forward */
    int k_backward;             /* go backward */
    int k_turn_left;            /* turn left */
    int k_turn_right;           /* turn right */
    int k_toggle_map;           /* open/close map */
    int k_toggle_lamp;          /* (un)lighten lamp */
    int k_use_item;             /* take/use item */ 
  } kref;
};

/* collision functions */
extern void objcoll_PLAYER_GHOST(struct s_game *, unsigned int, unsigned int);
extern void objcoll_PLAYER_MINOTAUR(struct s_game *, unsigned int, unsigned int);

/* misc.c */
extern void create_way(struct s_game *, struct walking_way *, int, int, int, int, int);
extern int red_distance(struct s_game *, unsigned int);
extern void draw_mazemap(struct s_game *);

#endif /* MAIN_H_ */
