#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"

void create_way(struct s_game *, struct walking_way *, int, int, int, int, int);
int red_distance(struct s_game *, unsigned int);
void draw_mazemap(struct s_game *);


/* create a walking way from xvon/yvon to xbis/ybis */
void
create_way(struct s_game *sgame, struct walking_way *wway, int walk_max, int xvon, int yvon, int xbis, int ybis)
{ 
  struct {
    int sdir, adir; 
  } wegdir[WALK_MAX];
  int wdir;
  
  if (wway == NULL) { return; }
  wway->pos = -1;
  wway->anz = 0;
  if (sgame == NULL) { return; }
  
  if (walk_max < 1) { walk_max = 1; } else if (walk_max > WALK_MAX) { walk_max = WALK_MAX; }

  wway->pos = 0;
  wway->way[wway->pos].x = xvon;
  wway->way[wway->pos].y = yvon;
  wegdir[wway->pos].adir = wegdir[wway->pos].sdir = WAND_NORD;

  for (;;) {
    xvon = wway->way[wway->pos].x;
    yvon = wway->way[wway->pos].y;
    wdir = wegdir[wway->pos].adir;

    if (!(sgame->maze.map[yvon][xvon] & wdir)) {
      if (++wway->pos == walk_max) { wway->pos--; goto wdreh; }

      if (wdir == WAND_NORD) {
        yvon--;
      } else if (wdir == WAND_OST) {
        xvon++;
      } else if (wdir == WAND_SUED) {
        yvon++;
      } else if (wdir == WAND_WEST) {
        xvon--;
      }
      wway->way[wway->pos].x = xvon;
      wway->way[wway->pos].y = yvon;

      if (wdir == WAND_NORD) {
        wdir = WAND_SUED;
      } else if (wdir == WAND_OST) {
        wdir = WAND_WEST;
      } else if (wdir == WAND_SUED) {
        wdir = WAND_NORD;
      } else if (wdir == WAND_WEST) {
        wdir = WAND_OST;
      }
      wegdir[wway->pos].sdir = wegdir[wway->pos].adir = wdir;

      if (xvon == xbis && yvon == ybis) { break; }
    }

wdreh:
    if (wdir == WAND_NORD) {
      wdir = WAND_OST;
    } else if (wdir == WAND_OST) {
      wdir = WAND_SUED;
    } else if (wdir == WAND_SUED) {
      wdir = WAND_WEST;
    } else if (wdir == WAND_WEST) {
      wdir = WAND_NORD;
    }
    wegdir[wway->pos].adir = wdir;

    if (wegdir[wway->pos].adir == wegdir[wway->pos].sdir) {
      if (--wway->pos < 0) { break; }
      wdir = wegdir[wway->pos].adir;
      goto wdreh;
    }
  }

  wway->anz = wway->pos + 1;
  wway->pos = 0;
}


/* calculate enemy's maximal distance to player to have him follow */
int
red_distance(struct s_game *sgame, unsigned int instanceid)
{
  const int walk_red = 5;
  struct obj_pos opos;

  if (sgame == NULL || instanceid == 0) { return walk_red; }

  opos.dir = 0;
  if (vg4->object->call_data(sgame, instanceid, &opos) == 0) { return walk_red; }

  return walk_red + opos.u.ply.lamp_ontime / 20;
} 


/* draw overview of maze with positions until key pressed */
void
draw_mazemap(struct s_game *sgame)
{
  int wandsize, gangsize;
  struct VG_Image *imgm, *hgbild;
  int wpos, hpos, colw;
  VG_BOOL dodraw, allmaze, showportal, goexit;
  struct VG_Rect rect;
  struct VG_ImagecopyAttr iattr;
  struct obj_pos opos_player;
  int col_gang = vg4->misc->colorbrightness(VG_COLOR_WHITE, 50);
  int col_gang_visited = vg4->misc->colorbrightness(VG_COLOR_YELLOW, 50);
  int col_wand = VG_COLOR_BLACK;
  int col_portal = VG_COLOR_BROWN;
  int col_exit = vg4->misc->colorbrightness(VG_COLOR_GREEN, 50);
  int col_ghost = VG_COLOR_VIOLET;
  int col_ghost_following = VG_COLOR_PINK;
  int col_minotaur = VG_COLOR_RED;
  int col_minotaur_following = VG_COLOR_PINK;
  int col_player_local = VG_COLOR_BLUE;
  int col_item = VG_COLOR_WHITE;

  if (sgame == NULL) { fprintf(stderr, "%s\n", strerror(EINVAL)); return; }
  if (sgame->maze.map == NULL || sgame->maze.wsize <= 0 || sgame->maze.hsize <= 0) {
    fprintf(stderr, "%s\n", strerror(EINVAL));
    return;
  }

  if (sgame->maze.hsize < 25 && sgame->maze.wsize < 25) {
    wandsize = 3;
    gangsize = 12;
  } else {
    wandsize = 2;
    gangsize = 8;
  }

  VG_IMAGECOPY_ATTR_DEFAULT(&iattr);
  iattr.pixel.brightness = 50;
  hgbild = vg4->window->clone(NULL, &iattr);

  allmaze = showportal = goexit = VG_FALSE;
  if (sgame->ply.map == 2) { allmaze = VG_TRUE; }
  if (sgame->ply.map == 3) { allmaze = showportal = VG_TRUE; }
  if (sgame->ply.map == 4) { allmaze = showportal = goexit = VG_TRUE; }

  VG_IMAGECOPY_ATTR_DEFAULT(&iattr);

  imgm = vg4->image->create(sgame->maze.wsize * (wandsize + gangsize + wandsize),
                            sgame->maze.hsize * (wandsize + gangsize + wandsize));

  vg4->image->fill(imgm, col_gang);

  for (hpos = 0; hpos < sgame->maze.hsize; hpos++) {
    for (wpos = 0; wpos < sgame->maze.wsize; wpos++) {
      dodraw = allmaze;
      if (sgame->ply.mapvisited[hpos][wpos]) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize + gangsize + wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize + gangsize + wandsize;
        vg4->image->draw_rect(imgm, &rect, col_gang_visited, VG_TRUE);
        dodraw = VG_TRUE;
      } else if (!allmaze) {
        if (sgame->maze.exit_y != hpos || sgame->maze.exit_x != wpos) { continue; }
      }
      if (sgame->maze.map[hpos][wpos] & WAND_NORD) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize + gangsize + wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize;
        if (sgame->maze.exit_y == hpos && sgame->maze.exit_x == wpos && sgame->maze.exit_dir == WAND_NORD) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || sgame->ply.mapvisited[hpos][wpos] & WAND_NORD)) {
            if (sgame->maze.map[hpos][wpos] & (WAND_NORD << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { vg4->image->draw_rect(imgm, &rect, colw, VG_TRUE); }
      }
      if (sgame->maze.map[hpos][wpos] & WAND_OST) {
        rect.x = wpos * (wandsize + gangsize + wandsize) + wandsize + gangsize;
        rect.w = wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize + gangsize + wandsize;
        if (sgame->maze.exit_y == hpos && sgame->maze.exit_x == wpos && sgame->maze.exit_dir == WAND_OST) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || sgame->ply.mapvisited[hpos][wpos] & WAND_OST)) {
            if (sgame->maze.map[hpos][wpos] & (WAND_OST << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { vg4->image->draw_rect(imgm, &rect, colw, VG_TRUE); }
      }
      if (sgame->maze.map[hpos][wpos] & WAND_SUED) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize + gangsize + wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize) + wandsize + gangsize;
        rect.h = wandsize;
        if (sgame->maze.exit_y == hpos && sgame->maze.exit_x == wpos && sgame->maze.exit_dir == WAND_SUED) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || sgame->ply.mapvisited[hpos][wpos] & WAND_SUED)) {
            if (sgame->maze.map[hpos][wpos] & (WAND_SUED << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { vg4->image->draw_rect(imgm, &rect, colw, VG_TRUE); }
      }
      if (sgame->maze.map[hpos][wpos] & WAND_WEST) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize + gangsize + wandsize;
        if (sgame->maze.exit_y == hpos && sgame->maze.exit_x == wpos && sgame->maze.exit_dir == WAND_WEST) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || sgame->ply.mapvisited[hpos][wpos] & WAND_WEST)) {
            if (sgame->maze.map[hpos][wpos] & (WAND_WEST << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { vg4->image->draw_rect(imgm, &rect, colw, VG_TRUE); }
      }
      if (sgame->maze.map[hpos][wpos] & (((1 << MAP_SHIFT) - 1) << ITEM_SHIFT)) {
        rect.x = wpos * (wandsize + gangsize + wandsize) + (wandsize + gangsize + wandsize) / 2;
        rect.w = 2;
        rect.y = hpos * (wandsize + gangsize + wandsize) + (wandsize + gangsize + wandsize) / 2;
        rect.h = 2;
        vg4->image->draw_rect(imgm, &rect, col_item, VG_TRUE);
      }
    }
  }

  memset(&opos_player, 0, sizeof(opos_player));

  { int numberof, ipos; 
    unsigned int *idlist;
    struct obj_pos opos;

    /* draw ghost-pixels */
    numberof = vg4->object->list(OBJID_GHOST, 0, &idlist);
    for (ipos = 0; ipos < numberof; ipos++) {
      opos.dir = 0;
      if (vg4->object->call_data(sgame, idlist[ipos], &opos) > 0) {
        if (allmaze || sgame->ply.mapvisited[opos.y][opos.x]) {
          rect.x = wandsize + gangsize / 4 + opos.x * (wandsize + gangsize + wandsize);
          rect.w = gangsize / 2;
          rect.y = wandsize + gangsize / 4 + opos.y * (wandsize + gangsize + wandsize);
          rect.h = gangsize / 2;
          vg4->image->draw_rect(imgm, &rect, col_ghost, VG_TRUE);
          if (allmaze && opos.u.gh.do_follow) {
            int wypos;
            for (wypos = 1; wypos < opos.u.gh.wway->anz; wypos++) {
              rect.x = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].x * (wandsize + gangsize + wandsize);
              rect.w = gangsize / 3;
              rect.y = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].y * (wandsize + gangsize + wandsize);
              rect.h = gangsize / 3;
              vg4->image->draw_rect(imgm, &rect, col_ghost_following, VG_TRUE);
            }
          }
        }
      }
    }
    if (idlist != NULL) { free(idlist); }

    /* draw minotaur-pixel */
    numberof = vg4->object->list(OBJID_MINOTAUR, 0, &idlist);
    for (ipos = 0; ipos < numberof; ipos++) {
      opos.dir = 0;
      if (vg4->object->call_data(sgame, idlist[ipos], &opos) > 0) {
        if (allmaze || sgame->ply.mapvisited[opos.y][opos.x]) {
          rect.x = wandsize + gangsize / 4 + opos.x * (wandsize + gangsize + wandsize);
          rect.w = gangsize / 2;
          rect.y = wandsize + gangsize / 4 + opos.y * (wandsize + gangsize + wandsize);
          rect.h = gangsize / 2;
          vg4->image->draw_rect(imgm, &rect, col_minotaur, VG_TRUE);
          if (allmaze && opos.u.gh.do_follow) {
            int wypos;
            for (wypos = 1; wypos < opos.u.gh.wway->anz; wypos++) {
              rect.x = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].x * (wandsize + gangsize + wandsize);
              rect.w = gangsize / 3;
              rect.y = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].y * (wandsize + gangsize + wandsize);
              rect.h = gangsize / 3;
              vg4->image->draw_rect(imgm, &rect, col_minotaur_following, VG_TRUE);
            }
          }
        }
      }
    }
    if (idlist != NULL) { free(idlist); }

    /* draw player-pixel */
    numberof = vg4->object->list(OBJID_PLAYER, 0, &idlist);
    if (numberof == 1) {
      opos.dir = 0;
      if (vg4->object->call_data(sgame, idlist[0], &opos) > 0) { opos_player = opos; }
    }
    if (idlist != NULL) { free(idlist); }

    if (opos_player.dir != 0) {
      if (allmaze || sgame->ply.mapvisited[opos_player.y][opos_player.x]) {
        rect.x = wandsize + gangsize / 4 + opos_player.x * (wandsize + gangsize + wandsize);
        rect.w = gangsize / 2;
        rect.y = wandsize + gangsize / 4 + opos_player.y * (wandsize + gangsize + wandsize);
        rect.h = gangsize / 2;
        vg4->image->draw_rect(imgm, &rect, col_player_local, VG_TRUE);
      }
    }
  }

  if (goexit && opos_player.dir != 0) {
    struct walking_way wway;
    create_way(sgame, &wway, WALK_MAX, opos_player.x, opos_player.y, sgame->maze.exit_x, sgame->maze.exit_y);
    for (wway.pos = 1; wway.pos < wway.anz; wway.pos++) {
      rect.x = wandsize + gangsize * 3 / 8 + wway.way[wway.pos].x * (wandsize + gangsize + wandsize);
      rect.w = gangsize / 4;
      rect.y = wandsize + gangsize * 3 / 8 + wway.way[wway.pos].y * (wandsize + gangsize + wandsize);
      rect.h = gangsize / 4;
      vg4->image->draw_rect(imgm, &rect, col_player_local, VG_TRUE);
    }
  }

  if (opos_player.dir == WAND_OST) {
    iattr.image.rotate = 270;
  } else if (opos_player.dir == WAND_SUED) {
    iattr.image.rotate = 180;
  } else if (opos_player.dir == WAND_WEST) {
    iattr.image.rotate = 90;
  } else {
    iattr.image.rotate = 0;
  }

  vg4->window->clear();
  vg4->window->copy(hgbild, NULL, NULL);
  vg4->window->copy(imgm, NULL, &iattr);

  vg4->image->destroy(imgm);
  vg4->image->destroy(hgbild);
}
