/* object OBJID_MINOTAUR */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-minotaur.h"

unsigned int objnew_MINOTAUR(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static int f_data(void *, struct VG_Object *, void *);

static VG_BOOL follow_player(struct s_game *, struct sobj_minotaur *);

static int max_attac = 4;


/* export-function to create a new object-instance of OBJID_MINOTAUR
 * @param vgame       private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_MINOTAUR(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_minotaur *objvars;
  char buf[256];
  int i1;

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  objvars->pos.x = ZUFALL(0, sgame->maze.wsize - 1);
  objvars->pos.y = ZUFALL(0, sgame->maze.hsize - 1);
  objvars->pos.dir = WAND_NORD;
  objvars->pos.prz = 0;
  objvars->wway.anz = 0;
  objvars->wway.pos = -1;
  objvars->do_follow = VG_FALSE;
  objvars->pause = 150;  /* should be length of appearing sprite */
  objvars->walknr = MINOTAUR_SPRITE_WALK1;
  objvars->attac = 0;

  /* load minotaur-sprites */
  snprintf(buf, sizeof(buf), "files/images/minotaur/minotaur-appear.sprite");
  objvars->sprtapp = vg4->sprite->load(buf);
  if (objvars->sprtapp == NULL) { f_free(vgame, objvars); return 0; }
  for (i1 = 0; i1 < MINOTAUR_SPRITE_MAX; i1++) {
    snprintf(buf, sizeof(buf), "files/images/minotaur/minotaur%d.sprite", i1 + 1);
    objvars->sprt[i1] = vg4->sprite->load(buf);
    if (objvars->sprt[i1] == NULL) { f_free(vgame, objvars); return 0; }
  }
  objvars->sprt_mom = objvars->sprtapp;

  /* load audios */
  objvars->sound.appear = vg4->audio->load("files/audio/minotaur-appear.wav", 100, VG_AUDIO_VOLUME_SOUND);
  objvars->sound.follow = vg4->audio->load("files/audio/minotaur-follow.wav", 100, VG_AUDIO_VOLUME_SOUND);
  objvars->sound.attac = vg4->audio->load("files/audio/minotaur-attac.wav", 100, VG_AUDIO_VOLUME_SOUND);

  /* create object-instance */
  objp = vg4->object->create(OBJID_MINOTAUR, 0, 0, 1, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_data = f_data;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_minotaur *objvars = (struct sobj_minotaur *)opriv;
  int i1;

  if (sgame == NULL) { return; }

  /* free private struct */
  if (objvars->sprtapp != NULL) { vg4->sprite->destroy(objvars->sprtapp); }
  for (i1 = 0; i1 < MINOTAUR_SPRITE_MAX; i1++) {
    if (objvars->sprt[i1] != NULL) { vg4->sprite->destroy(objvars->sprt[i1]); }
  }
  if (objvars->sound.appear > 0) { vg4->audio->unload(objvars->sound.appear); }
  if (objvars->sound.follow > 0) { vg4->audio->unload(objvars->sound.follow); }
  if (objvars->sound.attac > 0) { vg4->audio->unload(objvars->sound.attac); }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_minotaur *objvars = (struct sobj_minotaur *)objp->opriv;

  if (sgame == NULL) { return VG_TRUE; }
  if (sgame->clock < 100) { return VG_TRUE; }  /* deactivated */

  if (objvars->sprt_mom == objvars->sprtapp) {
    if (objvars->pause == 0) {
      objvars->sprt_mom = objvars->sprt[MINOTAUR_SPRITE_REST];
      vg4->sprite->rewind(objvars->sprt_mom);
    } else {
      if (sgame->clock == 100 && sgame->clockdelta == 0) {
        vg4->audio->play(objvars->sound.appear, VG_FALSE, VG_FALSE);
      }
      objvars->pause--;
      return VG_TRUE;
    }
  }

  if (follow_player(sgame, objvars)) {
    objvars->pause = 0;
    objvars->sprt_mom = objvars->sprt[objvars->walknr];
    vg4->sprite->rewind(objvars->sprt_mom);
    if (objvars->do_follow) { vg4->audio->play(objvars->sound.follow, VG_FALSE, VG_FALSE); }
  }

  if (objvars->pause > 0) {
    if (--objvars->pause > 0) { return VG_TRUE; }
    objvars->sprt_mom = objvars->sprt[objvars->walknr];
    vg4->sprite->rewind(objvars->sprt_mom);
  }

  if (objvars->wway.anz == 0) {  /* calculate a new moving-way */
    int xbis, ybis, walk_max, maxdo = 0;
    while (objvars->wway.anz < 2) {
      if (++objvars->attac == max_attac) {
        xbis = ZUFALL(0, sgame->maze.wsize - 1);
        ybis = ZUFALL(0, sgame->maze.hsize - 1);
        walk_max = WALK_MAX / 2;
        objvars->attac = 0;
      } else {
        int zmax = (sgame->maze.wsize + sgame->maze.hsize) / 7;
        xbis = sgame->ply.x + ZUFALL(0, zmax) - zmax / 2;
        ybis = sgame->ply.y + ZUFALL(0, zmax) - zmax / 2;
        walk_max = WALK_MAX;
        vg4->audio->play(objvars->sound.attac, VG_FALSE, VG_FALSE);
      }
      if (xbis < 0) { xbis = 0; } else if (xbis > sgame->maze.wsize - 1) { xbis = sgame->maze.wsize - 1; }
      if (ybis < 0) { ybis = 0; } else if (ybis > sgame->maze.hsize - 1) { ybis = sgame->maze.hsize - 1; }
      create_way(sgame, &objvars->wway, walk_max, objvars->pos.x, objvars->pos.y, xbis, ybis);
      objvars->pos.prz = 0;
      objvars->do_follow = VG_FALSE;
      if (objvars->wway.way[1].x > objvars->wway.way[0].x) {
        objvars->pos.dir = WAND_OST;
      } else if (objvars->wway.way[1].x < objvars->wway.way[0].x) {
        objvars->pos.dir = WAND_WEST;
      } else if (objvars->wway.way[1].y > objvars->wway.way[0].y) {
        objvars->pos.dir = WAND_SUED;
      } else {
        objvars->pos.dir = WAND_NORD;
      }
      if (++maxdo == 7) { return VG_TRUE; }
    }
    objvars->sprt_mom = objvars->sprt[objvars->walknr];
    vg4->sprite->rewind(objvars->sprt_mom);
  }

  objvars->pos.prz += 8; if (objvars->do_follow) { objvars->pos.prz += 2; }
  if (objvars->pos.prz >= 100) {
    objvars->pos.prz = 0;
    if (++objvars->wway.pos >= objvars->wway.anz) { objvars->wway.anz = 0; return VG_TRUE; }
    objvars->pos.x = objvars->wway.way[objvars->wway.pos].x;
    objvars->pos.y = objvars->wway.way[objvars->wway.pos].y;
    if (objvars->wway.pos + 1 < objvars->wway.anz) {
      if (objvars->wway.way[objvars->wway.pos + 1].x > objvars->wway.way[objvars->wway.pos].x) {
        objvars->pos.dir = WAND_OST;
      } else if (objvars->wway.way[objvars->wway.pos + 1].x < objvars->wway.way[objvars->wway.pos].x) {
        objvars->pos.dir = WAND_WEST;
      } else if (objvars->wway.way[objvars->wway.pos + 1].y > objvars->wway.way[objvars->wway.pos].y) {
        objvars->pos.dir = WAND_SUED;
      } else {
        objvars->pos.dir = WAND_NORD;
      }
    }
    if (objvars->wway.pos == objvars->wway.anz - 1) {
      objvars->wway.anz = objvars->wway.pos = 0;
      objvars->do_follow = VG_FALSE;
      objvars->pause = 50 + ZUFALL(0, 50);
      objvars->sprt_mom = objvars->sprt[MINOTAUR_SPRITE_REST];
      vg4->sprite->rewind(objvars->sprt_mom);
      return VG_TRUE;
    }
  }

  return VG_TRUE;
}


/* check whether to follow player, return VG_TRUE = following or VG_FALSE = not following */
static VG_BOOL
follow_player(struct s_game *sgame, struct sobj_minotaur *objvars)
{
  struct walking_way wway1, wway0;

  if (sgame == NULL || objvars == NULL || objvars->do_follow) { return VG_FALSE; }

  wway0.anz = 0;

  { unsigned int *idlist;
    struct obj_pos opos;
    if (vg4->object->list(OBJID_PLAYER, 0, &idlist) == 1) {
      opos.dir = 0;
      if (vg4->object->call_data(sgame, idlist[0], &opos) > 0) {
        int walk_go = red_distance(sgame, idlist[0]);
        create_way(sgame, &wway1, walk_go, objvars->pos.x, objvars->pos.y, opos.x, opos.y);
        if (wway1.anz >= 2 && wway1.anz < walk_go && (wway0.anz == 0 || wway1.anz < wway0.anz)) {
          wway0 = wway1;
        }
      }
    }
    if (idlist != NULL) { free(idlist); }
  }

  if (wway0.anz > 0) {
    objvars->wway = wway0;
    objvars->pos.prz = 0;
    objvars->do_follow = VG_TRUE;
    if (objvars->wway.way[1].x > objvars->wway.way[0].x) {
      objvars->pos.dir = WAND_OST;
    } else if (objvars->wway.way[1].x < objvars->wway.way[0].x) {
      objvars->pos.dir = WAND_WEST;
    } else if (objvars->wway.way[1].y > objvars->wway.way[0].y) {
      objvars->pos.dir = WAND_SUED;
    } else {
      objvars->pos.dir = WAND_NORD;
    }
    return VG_TRUE;
  }

  return VG_FALSE;
}


/* get/set data from/for object-instance, called from vg4->object->call_data() */
static int
f_data(void *vgame, struct VG_Object *objp, void *vptr)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_minotaur *objvars = (struct sobj_minotaur *)objp->opriv;
  struct obj_pos *opos = (struct obj_pos *)vptr;
  int flag;

  if (sgame == NULL || opos == NULL) { return 0; }
  if (sgame->clock < 100) { return 0; }  /* deactivated */

  flag = opos->dir;

  memset(opos, 0, sizeof(*opos));
  opos->x = objvars->pos.x;
  opos->y = objvars->pos.y;
  opos->prz = objvars->pos.prz;
  opos->dir = objvars->pos.dir;
  opos->img = NULL;
  opos->u_pg = 2;
  opos->u.gh.wway = &objvars->wway;
  opos->u.gh.do_follow = objvars->do_follow;

  if (flag == 1) {
    if (!vg4->sprite->next(objvars->sprt_mom, &opos->img, &opos->attr)) {
      vg4->sprite->rewind(objvars->sprt_mom);
      vg4->sprite->next(objvars->sprt_mom, &opos->img, &opos->attr);
    }
  }

  return 1;
}
