/* object OBJID_MUSIC */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-music.h"

unsigned int objnew_MUSIC(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);


/* export-function to create a new object-instance of OBJID_MUSIC
 * @param vgame       private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_MUSIC(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_music *objvars;
  char buf[256];
  int i1;

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* load music */
  for (i1 = 0; i1 < MUSIC_MUS_MAX; i1++) {
    snprintf(buf, sizeof(buf), "files/audio/mus%d.flac", i1 + 1);
    objvars->mus.id[i1] = vg4->audio->load(buf, 60 + i1 * 5, VG_AUDIO_VOLUME_MUSIC);
  }
  objvars->mus.id_aftermid = vg4->audio->load("files/audio/mus-aftermid.flac", 80, VG_AUDIO_VOLUME_MUSIC);

  /* load water-drip */
  for (i1 = 0; i1 < MUSIC_WATER_MAX; i1++) {
    snprintf(buf, sizeof(buf), "files/audio/water%d.wav", i1 + 1);
    objvars->water.id[i1] = vg4->audio->load(buf, 100, VG_AUDIO_VOLUME_SOUND);
  }

  objvars->mus.pause = (sgame->maze.wsize * sgame->maze.hsize) / 2;
  objvars->water.pause = 50;

  /* create object-instance */
  objp = vg4->object->create(OBJID_MUSIC, 0, 0, 1, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_music *objvars = (struct sobj_music *)opriv;
  int i1;

  (void)vgame;

  /* free private struct */

  /* unload music */
  for (i1 = 0; i1 < MUSIC_MUS_MAX; i1++) {
    if (objvars->mus.id[i1] > 0) { vg4->audio->unload(objvars->mus.id[i1]); }
  }
  if (objvars->mus.id_aftermid > 0) { vg4->audio->unload(objvars->mus.id_aftermid); }

  /* unload water-drip */
  for (i1 = 0; i1 < MUSIC_WATER_MAX; i1++) {
    if (objvars->water.id[i1] > 0) { vg4->audio->unload(objvars->water.id[i1]); }
  }

  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_music *objvars = (struct sobj_music *)objp->opriv;

  if (sgame == NULL) { return VG_TRUE; }

  /* music */
  if (objvars->mus.pause > 0) {
    if (--objvars->mus.pause == 0) {
      if (objvars->mus.idrun == 0) {
        objvars->mus.idrun = 1;
        vg4->audio->play(objvars->mus.id[objvars->mus.idrun - 1], VG_TRUE, VG_TRUE);
      } else {
        vg4->audio->play(objvars->mus.id_aftermid, VG_TRUE, VG_FALSE);
      }
    }
  } else if (sgame->clockdelta == 0) {
    if (sgame->clock == 20 || sgame->clock == 60) {
      vg4->audio->stop(objvars->mus.id[objvars->mus.idrun - 1], VG_TRUE);
      objvars->mus.idrun++;
      vg4->audio->play(objvars->mus.id[objvars->mus.idrun - 1], VG_TRUE, VG_TRUE);
    } else if (sgame->clock == 100) {
      vg4->audio->stop(objvars->mus.id[objvars->mus.idrun - 1], VG_FALSE);
      objvars->mus.pause = 50;
    }
  }

  return VG_TRUE;
}
