#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"
#include "obj-player.h"
#include "obj-ghost.h"

void objcoll_PLAYER_GHOST(struct s_game *, unsigned int, unsigned int);


void
objcoll_PLAYER_GHOST(struct s_game *sgame, unsigned int iid_player, unsigned int iid_ghost)
{
  struct VG_Object *objp_player, *objp_ghost;
  struct sobj_player *objvars_player;
  struct sobj_ghost *objvars_ghost;
  int addfear;

  if (sgame == NULL || iid_player == 0 || iid_ghost == 0) { return; }

  objp_player = vg4->object->instance_getobj(iid_player);
  objp_ghost = vg4->object->instance_getobj(iid_ghost);
  if (objp_player == NULL || objp_ghost == NULL) { return; }

  objvars_player = (struct sobj_player *)objp_player->opriv;
  objvars_ghost = (struct sobj_ghost *)objp_ghost->opriv;

  if (objvars_ghost->sprt_mom == objvars_ghost->sprtapp) { return; }  /* ghost still appears */
  if (objvars_player->ghost_instanceid > 0) { return; }  /* player is already frighten by another ghost */
  if (objvars_player->garlic_smell > 0) { return; }  /* player is save because of garlic */

  objvars_player->ghost_instanceid = objp_ghost->instanceid;
  addfear = 55 - (sgame->maze.wsize / 8);
  if (addfear < 20) { addfear = 20; }
  objvars_player->fear += (addfear * objvars_player->fearmulti);
  objvars_player->map = 0;
  objvars_player->lamp_ontime = 0;
  objvars_ghost->horrorloop = HORRORLOOP_MAX;
  objvars_ghost->pos.prz = 0;

  objvars_ghost->horrorzoom = 1;
  sgame->ply.map = objvars_player->map;
  sgame->ply.lamp = (objvars_player->lamp_ontime > 0 ? VG_TRUE : VG_FALSE);
  sgame->ply.fear = objvars_player->fear / objvars_player->fearmulti;
  vg4->audio->play(objvars_ghost->sound.frighten, VG_FALSE, VG_FALSE);
  vg4->audio->play(objvars_player->sound.fear, VG_FALSE, VG_FALSE);

  objvars_ghost->sprt_mom = objvars_ghost->sprt[GHOST_SPRITE_HORROR];
  vg4->sprite->rewind(objvars_ghost->sprt_mom);
}
