#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"
#include "obj-player.h"
#include "obj-minotaur.h"

void objcoll_PLAYER_MINOTAUR(struct s_game *, unsigned int, unsigned int);


void
objcoll_PLAYER_MINOTAUR(struct s_game *sgame, unsigned int iid_player, unsigned int iid_minotaur)
{
  struct VG_Object *objp_player, *objp_minotaur;
  struct sobj_player *objvars_player;
  struct sobj_minotaur *objvars_minotaur;

  if (sgame == NULL || iid_player == 0 || iid_minotaur == 0) { return; }

  objp_player = vg4->object->instance_getobj(iid_player);
  objp_minotaur = vg4->object->instance_getobj(iid_minotaur);
  if (objp_player == NULL || objp_minotaur == NULL) { return; }

  objvars_player = (struct sobj_player *)objp_player->opriv;
  objvars_minotaur = (struct sobj_minotaur *)objp_minotaur->opriv;

  if (objvars_minotaur->sprt_mom == objvars_minotaur->sprtapp) { return; }  /* minotaur still appears */

  objvars_player->dead = 1;
  objvars_player->map = 0;
  objvars_player->lamp_ontime = 0;

  sgame->ply.map = objvars_player->map;
  sgame->ply.lamp = (objvars_player->lamp_ontime > 0 ? VG_TRUE : VG_FALSE);
}
