/* management of object OBJID_GHOST */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"

VG_BOOL objmgmt_GHOST(void *);

static void f_free(void);
static void f_run(void *);

/* internal structure for this object-management */
static struct {
  int countdown;
} mgmt_ghost;


/* export-function to create the management of OBJID_GHOST
 * @param vgame       private structure of the game
 * @return  VG_TRUE = OK or VG_FALSE = Error
 */
VG_BOOL
objmgmt_GHOST(void *vgame)
{     
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_ObjMgmt *omgmt;

  if (sgame == NULL) { return VG_FALSE; }

  /* set internal structure for this object-management */

  memset(&mgmt_ghost, 0, sizeof(mgmt_ghost));
  mgmt_ghost.countdown = sgame->maze.wsize * sgame->maze.hsize / 2 + 100;

  /* create object-management */
  omgmt = vg4->object->mgmt_create(OBJID_GHOST);
  omgmt->f_free = f_free;
  omgmt->f_run = f_run;

  return VG_TRUE;
}


/* reset internal structure for this object-management, called from vg4->object->mgmt_destroy() */
static void
f_free(void)
{ 
  memset(&mgmt_ghost, 0, sizeof(mgmt_ghost));
}


/* execute managing, called from vg4->object->call_mgmt_run() */
static void
f_run(void *vgame)
{
  struct s_game *sgame;
  int inst_ist, inst_soll;

  sgame = (struct s_game *)vgame;
  if (sgame == NULL) { return; }

  if (mgmt_ghost.countdown > 0) { mgmt_ghost.countdown--; }

  if (sgame->clock < 80) {
    inst_soll = (sgame->maze.wsize + sgame->maze.hsize) / 6 * (40 + sgame->clock / 2) / 80;
  } else {
    inst_soll = (sgame->maze.wsize + sgame->maze.hsize) / 6;
  }

  inst_ist = vg4->object->list(OBJID_GHOST, 0, NULL);

  if (inst_ist < inst_soll) {
    if (mgmt_ghost.countdown == 0) {  /* create ghost-instance */
      if (objnew_GHOST(sgame) == 0) { return; }
      mgmt_ghost.countdown = -1;
    } else if (mgmt_ghost.countdown < 0) {
      mgmt_ghost.countdown = 200 + ZUFALL(10, 80);
    }
  }
}
