#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames4.h>

/* include object-IDs */
#include "objid.h"

/* include exported object-functions */
#include "objfn.h"

/* random number from P1 to P2 inclusive */
#define ZUFALL(P1, P2)  vg4->random->get(NULL, (P1), (P2))

/* +++ highest number dice can show +++ */
#define MAX_DICE_NUMBER 5

/* +++ animations +++ */
enum {
  ANIMATION_STARTING = 1,
  ANIMATION_SMURF_BLUE,
  ANIMATION_SMURF_BLACK,
  ANIMATION_SMURF_BLACKFLY,
  ANIMATION_BLACKSMURF_BYE,
  ANIMATION_ENDING  /* must be last entry */
};

/* smurf-species */
enum { SPECIES_SMURF = 0, SPECIES_SMURF_BLACK, SPECIES_PAPASMURF, SPECIES_PAPASMURF_BLACK, SPECIES_FLY };

/* struct of actions */
enum {
  UART_ANIMATION = 1,  /* show animation
                        * hash parameters:
                        * - num (int): which one: from ANIMATION_* enum
                        * - text (string): (optional)
                        */
  UART_DICE,           /* throw dice
                        * hash parameters: no
                        */
  UART_SELSMURF,       /* select blue smurf for moving
                        * hash parameters:
                        * - steps (int): number of steps to move
                        * - instanceid (unsigned int): instance-ID of selected smurf
                        * or auto-select black smurf for moving
                        * hash parameters: no
                        */
  UART_MOVSMURF,       /* move smurf
                        * hash parameters:
                        * - steps (int): number of steps to move
                        * - instanceid (unsigned int): instance-ID
                        * - direction (int): direction to next step: 0 = default, 1 = left, 2 = right
                        */
  UART_MOUSESEL,       /* show mousepointer to select blue smurf
                        * hash parameters:
                        * - steps (int): number of steps to move
                        */
  UART_DIRSEL          /* show dialog to select direction to go: left or right
                        * hash parameters:
                        * - instanceid (unsigned int): instance-ID of selected smurf
                        */
};


/* private structure of the game */
#define PLAYFIELD_STEPS  33
struct s_game {
  int winw, winh;             /* window's width and height */
  unsigned int coll_tag;      /* collision-tag */

  struct {  /* playfield-map */
    int xpos, ypos;        /* position of center */
    VG_BOOL village;       /* is village? */
    VG_BOOL sarsaparille;  /* is located in sarsaparille field? */
    VG_BOOL river;         /* is located in the river? */
    int starting;          /* 0 = no starting-field, 1 = smurfs, 2 = papa-smurf, 3 = fly */
    VG_BOOL mirrordraw;    /* whether draw smurfs mirrored */
    int next[2];           /* next position(s) */
  } pfmap[PLAYFIELD_STEPS];

  int smurf_total;     /* total number of smurfs */
  int smurf_pending;   /* number of smurfs waiting for activation */
  int smurf_saved;     /* number of saved smurfs */
  VG_BOOL game_won;    /* whether game is won */

  struct {                    /* keys */
    int k_quit_lalt;            /* part of quit: Left-ALT */
    int k_quit_q;               /* part of quit: Q */
    int k_sysmenu;              /* system-menu */
    int k_help;                 /* help */
    int k_pause;                /* pause */
    int k_go_left;              /* go left */
    int k_go_right;             /* go right */
    int k_stop;                 /* stop dice */
  } kref;
};

/* collision functions */
extern void objcoll_MOUSESEL_SMURF(struct s_game *, unsigned int, unsigned int);

/* misc.c */
extern void check_direction(struct s_game *, int, int, int, int *, int *);

#endif /* MAIN_H_ */
