#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"

void check_direction(struct s_game *, int, int, int, int *, int *);


/* return target steps (left and right) of moving smurf */
void
check_direction(struct s_game *sgame, int pfstep, int steps, int species, int *targetstep_left, int *targetstep_right)
{
  int targetstep[2], tidx;

  if (targetstep_left != NULL) { *targetstep_left = -1; }
  if (targetstep_right != NULL) { *targetstep_right = -1; }
  if (sgame == NULL || targetstep_left == NULL || targetstep_right == NULL) { return; }
  if (pfstep < 0 || steps < 1) { return; }

  for (targetstep[0] = targetstep[1] = pfstep; steps > 0; steps--) {
    /* get next step left and right */
    if (targetstep[0] >= 0) {
      targetstep[0] = sgame->pfmap[targetstep[0]].next[0];
    }
    if (targetstep[1] >= 0) {
      if (sgame->pfmap[targetstep[1]].next[1] >= 0) {
        targetstep[1] = sgame->pfmap[targetstep[1]].next[1];
      } else {
        targetstep[1] = sgame->pfmap[targetstep[1]].next[0];
      }
    }

    /* check next step left and right */
    for (tidx = 0; tidx <= 1; tidx++) {
      if (targetstep[tidx] < 0) { continue; }
      if (sgame->pfmap[targetstep[tidx]].village) {
        if (steps > 1 || species != SPECIES_SMURF) { targetstep[tidx] = -1; continue; }
      }
      if (sgame->pfmap[targetstep[tidx]].sarsaparille) {
        if (steps == 1 && species == SPECIES_FLY) { targetstep[tidx] = -1; continue; }
      }
      if (sgame->pfmap[targetstep[tidx]].river) {
        if (steps == 1 && species != SPECIES_FLY) { targetstep[tidx] = -1; continue; }
      }
    }

    /* blue smurf can reach village: no selection of direction */
    if (steps == 1 && species == SPECIES_SMURF) {
      if (sgame->pfmap[targetstep[0]].village && targetstep[0] >= 0) { targetstep[1] = -1; }
      if (sgame->pfmap[targetstep[1]].village && targetstep[1] >= 0) { targetstep[0] = -1; }
    }
  }

  *targetstep_left = targetstep[0];
  *targetstep_right = targetstep[1];
}
