/* object OBJID_ANIMATION */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-animation.h"

unsigned int objnew_ANIMATION(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of OBJID_ANIMATION
 * @param vgame    private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_ANIMATION(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_animation *objvars;
  int i1;
  char buf[128];

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  objvars->num = 0;

  /* load sprites */
  for (i1 = 0; i1 < ANIMATION_ENDING; i1++) {
    snprintf(buf, sizeof(buf), "files/images/animation/num%d.sprite", i1 + 1);
    objvars->a[i1].sprt = vg4->sprite->load(buf);
    if (objvars->a[i1].sprt == NULL) { f_free(vgame, objvars); return 0; }
  }

  /* create object-instance */
  objp = vg4->object->create(OBJID_ANIMATION, 0, 0, 4, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_animation *objvars = (struct sobj_animation *)opriv;
  int i1;

  (void)vgame;

  /* free private struct */
  for (i1 = 0; i1 < ANIMATION_ENDING; i1++) {
    if (objvars->a[i1].sprt != NULL) { vg4->sprite->destroy(objvars->a[i1].sprt); }
  }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_animation *objvars = (struct sobj_animation *)objp->opriv;
  struct VG_Hash *hparm;
  unsigned int name_id;

  if (sgame == NULL) { return VG_TRUE; }

  hparm = vg4->actionstack->get(&name_id);
  if (name_id != UART_ANIMATION) { return VG_TRUE; }

  if (objvars->num == 0) {  /* new animation */
    objvars->num = vg4->hash->getint(hparm, "num");
    if (objvars->num < 1 || objvars->num > ANIMATION_ENDING) { objvars->num = 0; return VG_TRUE; }
    objvars->text = vg4->hash->get(hparm, "text", NULL);
    if (objvars->text != NULL && *objvars->text == '\0') { objvars->text = NULL; }
  } 

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_animation *objvars = (struct sobj_animation *)objp->opriv;
  struct s_game *sgame = (struct s_game *)vgame;
  unsigned int name_id;
  struct VG_Image *imgp;
  struct VG_ImagecopyAttr iattr;

  if (sgame == NULL) { return; }

  vg4->actionstack->get(&name_id);
  if (name_id != UART_ANIMATION) { return; }
  if (objvars->num == 0) { return; }

  if (!vg4->sprite->next(objvars->a[objvars->num - 1].sprt, &imgp, &iattr)) {
    vg4->sprite->rewind(objvars->a[objvars->num - 1].sprt);
    objvars->num = 0;
    vg4->actionstack->pop();
    return;
  }

  vg4->window->copy(imgp, NULL, &iattr);
  if (objvars->text != NULL) {
    imgp = vg4->font->totext(objvars->text, "[fgcolor=0x000000]", NULL, NULL, NULL);
    if (imgp != NULL) {
      vg4->window->copy(imgp, NULL, NULL);
      vg4->image->destroy(imgp);
    }
  }
}
