/* object OBJID_DICE */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-dice.h"

unsigned int objnew_DICE(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);

static int number_black[] = { 5, 1, 2, 3, 4, 5 };
static int number_blue[] = { 14, 1, 0, 2, 3, 4, 0, 5, 1, 2, 0, 3, 0, 4, 5 };


/* export-function to create a new object-instance of OBJID_DICE
 * @param vgame    private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_DICE(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_dice *objvars;
  int i1;
  char buf[128];

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* load images */
  objvars->imgp_dice_blue = vg4->image->load("files/images/dice/dice-blue.bmp");
  if (objvars->imgp_dice_blue == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_dice_black = vg4->image->load("files/images/dice/dice-black.bmp");
  if (objvars->imgp_dice_black == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_dice_shadow = vg4->image->load("files/images/dice/dice-shadow.bmp");
  if (objvars->imgp_dice_shadow == NULL) { f_free(vgame, objvars); return 0; }
  for (i1 = 0; i1 < MAX_DICE_WFW; i1++) {
    snprintf(buf, sizeof(buf), "files/images/dice/wfw%d.bmp", i1 + 1);
    objvars->imgp_wfw[i1] = vg4->image->load(buf);
    if (objvars->imgp_wfw[i1] == NULL) { f_free(vgame, objvars); return 0; }
  }
  for (i1 = 0; i1 < MAX_DICE_NUMBER; i1++) {
    snprintf(buf, sizeof(buf), "files/images/dice/wfz-%d.bmp", i1 + 1);
    objvars->imgp_wfz[i1] = vg4->image->load(buf);
    if (objvars->imgp_wfz[i1] == NULL) { f_free(vgame, objvars); return 0; }
  }
  objvars->imgp_wfz_fly = vg4->image->load("files/images/dice/wfz-fly.bmp");
  if (objvars->imgp_wfz_fly == NULL) { f_free(vgame, objvars); return 0; }

  objvars->snd_falling = vg4->audio->load("files/audio/dice.wav", 100, VG_AUDIO_VOLUME_SOUND);

  /* create object-instance */
  objp = vg4->object->create(OBJID_DICE, 0, 0, 4, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_dice *objvars = (struct sobj_dice *)opriv;
  int i1;

  (void)vgame;

  /* free private struct */
  if (objvars->imgp_dice_blue != NULL) { vg4->image->destroy(objvars->imgp_dice_blue); }
  if (objvars->imgp_dice_black != NULL) { vg4->image->destroy(objvars->imgp_dice_black); }
  if (objvars->imgp_dice_shadow != NULL) { vg4->image->destroy(objvars->imgp_dice_shadow); }
  for (i1 = 0; i1 < MAX_DICE_WFW; i1++) {
    if (objvars->imgp_wfw[i1] != NULL) { vg4->image->destroy(objvars->imgp_wfw[i1]); }
  }
  for (i1 = 0; i1 < MAX_DICE_NUMBER; i1++) {
    if (objvars->imgp_wfz[i1] != NULL) { vg4->image->destroy(objvars->imgp_wfz[i1]); }
  }
  if (objvars->imgp_wfz_fly != NULL) { vg4->image->destroy(objvars->imgp_wfz_fly); }
  if (objvars->snd_falling > 0) { vg4->audio->unload(objvars->snd_falling); }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_dice *objvars = (struct sobj_dice *)objp->opriv;
  unsigned int name_id;

  if (sgame == NULL) { return VG_TRUE; }

  vg4->actionstack->get(&name_id);
  if (name_id != UART_DICE) { return VG_TRUE; }

  if (objvars->anim_max2 == 0) {  /* initialize */
    objvars->number_row = number_blue;
    objvars->anim_max1 = objvars->number_row[0] + ZUFALL(0, objvars->number_row[0] - 1);
    objvars->anim_max2 = objvars->anim_max1 + 10;
    objvars->number_idx = ZUFALL(0, objvars->number_row[0] - 1);
    objvars->anim_mom = 0;
    objvars->showdice = 0;
    objvars->dice_idx = ZUFALL(0, MAX_DICE_WFW - 1);
    objvars->steps = 0;
    objvars->isblack = VG_FALSE;
    if (!vg4->object->has_instances(OBJID_SMURF, SPECIES_SMURF)
        && !vg4->object->has_instances(OBJID_SMURF, SPECIES_PAPASMURF)) {
      /* only black smurfs existing: inhibit random fly */
      objvars->isblack = VG_TRUE;
      objvars->number_row = number_black;
      objvars->anim_max1 = objvars->number_row[0] + ZUFALL(0, objvars->number_row[0] - 1);
      objvars->anim_max2 = objvars->anim_max1 + 10;
      objvars->number_idx = ZUFALL(0, objvars->number_row[0] - 1);
    } else if (!vg4->object->has_instances(OBJID_SMURF, SPECIES_SMURF_BLACK)
               && !vg4->object->has_instances(OBJID_SMURF, SPECIES_PAPASMURF_BLACK)) {
      /* no black smurf existing: inhibit random fly */
      objvars->number_row = number_black;
      objvars->number_idx = ZUFALL(0, objvars->number_row[0] - 1);
    }
  }

  if (objvars->showdice > 0) {  /* show thrown dice */
    if (--objvars->showdice == 0) {
      if (objvars->steps > 0 && !objvars->isblack) {
        int numberof, ipos;
        unsigned int *idlist;
        int pfstep, pfstep1, pfstep2;
        struct VG_Object *objp2;

        numberof = vg4->object->list(OBJID_SMURF, 0, &idlist);
        for (ipos = 0; ipos < numberof; ipos++) {
          objp2 = vg4->object->instance_getobj(idlist[ipos]);
          if (objp2->subid != SPECIES_SMURF && objp2->subid != SPECIES_PAPASMURF) { continue; }
          if (vg4->object->call_data(sgame, objp2->instanceid, &pfstep) > 0) {
            check_direction(sgame, pfstep, objvars->steps, objp2->subid, &pfstep1, &pfstep2);
            if (pfstep1 >= 0 || pfstep2 >= 0) { break; }
          }
        }
        if (ipos == numberof) { objvars->steps = 0; }
        if (idlist != NULL) { free(idlist); }
      }

      if (objvars->steps > 0) {
        vg4->actionstack->pop();

        if (objvars->number_row == number_black) {  /* fly, or no existing black smurf: insert additional fly-moving */
          int numberof;
          unsigned int *idlist;
          int pfstep, pfstep1, pfstep2, steps;
          struct VG_Object *objp2;

          if (!objvars->isblack) { steps = ZUFALL(1, MAX_DICE_NUMBER); } else { steps = objvars->steps; }

          numberof = vg4->object->list(OBJID_SMURF, SPECIES_FLY, &idlist);
          if (numberof > 0) {
            objp2 = vg4->object->instance_getobj(idlist[0]);
            if (vg4->object->call_data(sgame, objp2->instanceid, &pfstep) > 0) {
              check_direction(sgame, pfstep, steps, objp2->subid, &pfstep1, &pfstep2);
              if (pfstep1 >= 0 || pfstep2 >= 0) {
                struct VG_Hash *hparm = vg4->hash->create();
                vg4->hash->setint(hparm, "instanceid", objp2->instanceid);
                vg4->hash->setint(hparm, "steps", steps);
                vg4->hash->setint(hparm, "direction", 0);
                vg4->actionstack->push(UART_MOVSMURF, hparm);
              }
            }
          }
        }

        if (!objvars->isblack) {  /* insert smurf */
          struct VG_Hash *hparm = vg4->hash->create();
          vg4->hash->setint(hparm, "steps", objvars->steps);
          vg4->actionstack->push(UART_SELSMURF, hparm);
        }

        objvars->anim_max1 = objvars->anim_max2 = 0;

      } else {
        objvars->isblack = VG_TRUE;
        objvars->number_row = number_black;
        objvars->number_idx = ZUFALL(0, objvars->number_row[0] - 1);
        objvars->steps = ZUFALL(1, MAX_DICE_NUMBER);
        objvars->anim_max1 = objvars->number_row[0] + ZUFALL(0, objvars->number_row[0] - 1);
        objvars->anim_max2 = objvars->anim_max1 + 10;
        objvars->anim_mom = 0;
      }
    }

  } else {  /* show falling dice */
    if (objvars->anim_mom < objvars->anim_max1) {
      if (objvars->snd_falling > 0 && objvars->anim_mom == 0) { vg4->audio->play(objvars->snd_falling, VG_FALSE, VG_FALSE); }
      if (++objvars->number_idx == objvars->number_row[0]) { objvars->number_idx = 1; }
      objvars->steps = objvars->number_row[objvars->number_idx];
      objvars->anim_mom++; 
      if (vg4->input->key_newpressed(sgame->kref.k_stop)) {
        objvars->anim_mom = objvars->anim_max1;
      }
    } else if (++objvars->anim_mom == objvars->anim_max2) {
      if (objvars->steps == 0) {
        objvars->isblack = VG_TRUE;
        objvars->number_row = number_black; 
        objvars->number_idx = ZUFALL(0, objvars->number_row[0] - 1);
      }
      objvars->showdice = 20;
    }
  }

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_dice *objvars = (struct sobj_dice *)objp->opriv;
  struct s_game *sgame = (struct s_game *)vgame;
  unsigned int name_id;
  struct VG_Position posi;

  if (sgame == NULL) { return; }

  vg4->actionstack->get(&name_id);
  if (name_id != UART_DICE) { return; }

  /* draw dice-instance */

  posi.x = sgame->winw / 2 + 15;
  posi.y = sgame->winh / 2 + 15;
  posi.pos = VG_POS_CENTERED;
  vg4->window->copy(objvars->imgp_dice_shadow, &posi, NULL);

  if (objvars->isblack) {
    vg4->window->copy(objvars->imgp_dice_black, NULL, NULL);
  } else {
    vg4->window->copy(objvars->imgp_dice_blue, NULL, NULL);
  }     
          
  if (objvars->showdice) {
    if (objvars->steps > 0) {
      vg4->window->copy(objvars->imgp_wfz[objvars->steps - 1], NULL, NULL);
    } else {
      vg4->window->copy(objvars->imgp_wfz_fly, NULL, NULL);
    }       
  } else {    
    if (objvars->anim_mom > objvars->anim_max1) {
      if (objvars->anim_max2 - objvars->anim_mom == 8
          || objvars->anim_max2 - objvars->anim_mom == 5
          || objvars->anim_max2 - objvars->anim_mom == 2) {
        if (++objvars->dice_idx == MAX_DICE_WFW) { objvars->dice_idx = 0; }
      }
    } else {
      if (++objvars->dice_idx == MAX_DICE_WFW) { objvars->dice_idx = 0; }
    }
    vg4->window->copy(objvars->imgp_wfw[objvars->dice_idx], NULL, NULL);
  }
}
