/* object OBJID_DIRSEL */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-dirsel.h"

unsigned int objnew_DIRSEL(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of OBJID_DIRSEL
 * @param vgame    private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_DIRSEL(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_dirsel *objvars;

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* load images */
  objvars->imgp_def = vg4->image->load("files/images/dirsel/dirsel-def.bmp");
  if (objvars->imgp_def == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_act_left = vg4->image->load("files/images/dirsel/dirsel-act-left.bmp");
  if (objvars->imgp_act_left == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_act_right = vg4->image->load("files/images/dirsel/dirsel-act-right.bmp");
  if (objvars->imgp_act_right == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_shd = vg4->image->load("files/images/dirsel/dirsel-shadow.bmp");
  if (objvars->imgp_shd == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp = objvars->imgp_def;

  /* create object-instance */
  objp = vg4->object->create(OBJID_DIRSEL, 0, 0, 4, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_dirsel *objvars = (struct sobj_dirsel *)opriv;

  (void)vgame;

  /* free private struct */
  if (objvars->imgp_def != NULL) { vg4->image->destroy(objvars->imgp_def); }
  if (objvars->imgp_act_left != NULL) { vg4->image->destroy(objvars->imgp_act_left); }
  if (objvars->imgp_act_right != NULL) { vg4->image->destroy(objvars->imgp_act_right); }
  if (objvars->imgp_shd != NULL) { vg4->image->destroy(objvars->imgp_shd); }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_dirsel *objvars = (struct sobj_dirsel *)objp->opriv;
  struct VG_Hash *hparm;
  unsigned int name_id;
  struct VG_Rect mrect;
  VG_BOOL mleft, go_left, go_right;

  if (sgame == NULL) { return VG_TRUE; }

  vg4->actionstack->get(&name_id);
  if (name_id != UART_DIRSEL) { return VG_TRUE; }

  objvars->imgp = objvars->imgp_def;

  /* check for mouse click in image for selecting direction */
  vg4->image->getsize(objvars->imgp, NULL, &mrect.w, &mrect.h);
  vg4->input->mouse_position(&mrect.x, &mrect.y);
  vg4->input->mouse_newpressed(&mleft, NULL, NULL);

  /* position in image: 22+36,88+37 */
  go_left = VG_FALSE;
  if (mrect.x >= sgame->winw / 2 - mrect.w / 2 + 22 && mrect.x <= sgame->winw / 2 - mrect.w / 2 + 22 + 36
      && mrect.y >= sgame->winh / 2 - mrect.h / 2 + 88 && mrect.y <= sgame->winh / 2 - mrect.h / 2 + 88 + 37
     ) {
      objvars->imgp = objvars->imgp_act_left;
      if (mleft) { go_left = VG_TRUE; }
  }

  /* position in image: 235+36,88+37 */
  go_right = VG_FALSE;
  if (mrect.x >= sgame->winw / 2 - mrect.w / 2 + 235 && mrect.x <= sgame->winw / 2 - mrect.w / 2 + 235 + 36
      && mrect.y >= sgame->winh / 2 - mrect.h / 2 + 88 && mrect.y <= sgame->winh / 2 - mrect.h / 2 + 88 + 37
     ) {
      objvars->imgp = objvars->imgp_act_right;
      if (mleft) { go_right = VG_TRUE; }
  }

  /* go left? */
  if (vg4->input->key_newpressed(sgame->kref.k_go_left) || go_left) {
    hparm = vg4->actionstack->parent(&name_id);
    if (name_id == UART_MOVSMURF) { vg4->hash->setint(hparm, "direction", 1); }
    vg4->actionstack->pop();
  }

  /* go right? */
  if (vg4->input->key_newpressed(sgame->kref.k_go_right) || go_right) {
    hparm = vg4->actionstack->parent(&name_id);
    if (name_id == UART_MOVSMURF) { vg4->hash->setint(hparm, "direction", 2); }
    vg4->actionstack->pop();
  }

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_dirsel *objvars = (struct sobj_dirsel *)objp->opriv;
  unsigned int name_id;
  struct VG_Position posi;

  if (sgame == NULL) { return; }

  vg4->actionstack->get(&name_id);
  if (name_id != UART_DIRSEL) { return; }

  posi.x = sgame->winw / 2 + 15;
  posi.y = sgame->winh / 2 + 15;
  posi.pos = VG_POS_CENTERED;
  vg4->window->copy(objvars->imgp_shd, &posi, NULL);

  vg4->window->copy(objvars->imgp, NULL, NULL);
}
