/* object OBJID_MOUSESEL */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-mousesel.h"

unsigned int objnew_MOUSESEL(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);
static void f_draw(void *, struct VG_Object *);


/* export-function to create a new object-instance of OBJID_MOUSESEL
 * @param vgame    private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_MOUSESEL(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_mousesel *objvars;
  int i1;
  char buf[128];

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* load images and sprites */
  objvars->imgp = vg4->image->load("files/images/mouse/mouse.bmp");
  if (objvars->imgp == NULL) { f_free(vgame, objvars); return 0; }
  objvars->sprt = vg4->sprite->load("files/images/mouse/mouse-click.sprite");
  if (objvars->sprt == NULL) { f_free(vgame, objvars); return 0; }
  for (i1 = 0; i1 < MAX_DICE_NUMBER; i1++) {
    snprintf(buf, sizeof(buf), "files/images/dice/wfz-%d.bmp", i1 + 1);
    objvars->imgp_wfz[i1] = vg4->image->load(buf);
    if (objvars->imgp_wfz[i1] == NULL) { f_free(vgame, objvars); return 0; }
  }

  /* create object-instance */
  objp = vg4->object->create(OBJID_MOUSESEL, 0, 0, 5, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;
  objp->f_draw = f_draw;

  /* insert object-instance into collision-tag */
  { struct VG_Rect rect;
    vg4->input->mouse_position(&rect.x, &rect.y);
    rect.w = rect.h = 1;
    vg4->collision->insert(sgame->coll_tag, objp->instanceid, &rect, 100);
  }

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_mousesel *objvars = (struct sobj_mousesel *)opriv;
  int i1;

  (void)vgame;

  /* free private struct */
  if (objvars->imgp != NULL) { vg4->image->destroy(objvars->imgp); }
  if (objvars->sprt != NULL) { vg4->sprite->destroy(objvars->sprt); }
  for (i1 = 0; i1 < MAX_DICE_NUMBER; i1++) {
    if (objvars->imgp_wfz[i1] != NULL) { vg4->image->destroy(objvars->imgp_wfz[i1]); }
  }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_mousesel *objvars = (struct sobj_mousesel *)objp->opriv;
  struct VG_Hash *hparm;
  unsigned int name_id;
  struct VG_Rect rect;
  struct VG_Coll *collp;
  int canz, i1, pfstep, pfstep1, pfstep2;
  struct VG_Object *objcoll;

  if (sgame == NULL) { return VG_TRUE; }

  hparm = vg4->actionstack->get(&name_id);
  if (name_id != UART_MOUSESEL) { return VG_TRUE; }
  if (objvars->instanceid > 0) { return VG_TRUE; }

  if (!vg4->input->mouse_position(&rect.x, &rect.y)) { return VG_TRUE; }
  rect.w = rect.h = 1;

  /* check if mouse is over a selectable smurf */
  objcoll = NULL;
  canz = vg4->collision->setpos(sgame->coll_tag, objp->instanceid, &rect, &collp);
  for (i1 = 0; i1 < canz; i1++) {
    if (collp[i1].type == VG_COLL_TYPE_LEAVE) { continue; }
    objcoll = vg4->object->instance_getobj(collp[i1].instanceid);
    if (strcmp(objcoll->objid, OBJID_SMURF) == 0) {
      if (objcoll->subid == SPECIES_SMURF || objcoll->subid == SPECIES_PAPASMURF) {
        if (vg4->object->call_data(sgame, objcoll->instanceid, &pfstep) > 0) {
          check_direction(sgame, pfstep, vg4->hash->getint(hparm, "steps"), objcoll->subid, &pfstep1, &pfstep2);
          if (pfstep1 >= 0 || pfstep2 >= 0) { break; }
        }
      }
    }
  }
  free(collp);
  if (i1 == canz) { return VG_TRUE; }

  /* call collision-function */
  objcoll_MOUSESEL_SMURF(sgame, objp->instanceid, objcoll->instanceid);

  return VG_TRUE;
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_mousesel *objvars = (struct sobj_mousesel *)objp->opriv;
  unsigned int name_id;
  struct VG_Hash *hparm;
  struct VG_Position posi;
  struct VG_ImagecopyAttr iattr;
  int xpos, ypos;

  if (sgame == NULL) { return; }

  if (!vg4->input->mouse_position(&xpos, &ypos)) { return; }

  hparm = vg4->actionstack->get(&name_id);

  /* show also mouse when selecting direction */
  if (name_id == UART_DIRSEL) {
    posi.x = xpos;
    posi.y = ypos;
    posi.pos = VG_POS_CENTERED;
    vg4->window->copy(objvars->imgp, &posi, NULL);
  }

  if (name_id != UART_MOUSESEL) { return; }

  if (objvars->instanceid > 0) {
    struct VG_Image *imgp;
    if (!vg4->sprite->next(objvars->sprt, &imgp, &iattr)) {
      struct VG_Hash *hparm2;
      vg4->sprite->rewind(objvars->sprt);
      hparm2 = vg4->actionstack->parent(&name_id);
      if (name_id == UART_SELSMURF) { vg4->hash->setint(hparm2, "instanceid", objvars->instanceid); }
      vg4->actionstack->pop();
      objvars->instanceid = 0;
      return;
    }
    if (imgp != NULL) {
      posi.x = xpos;
      posi.y = ypos;
      posi.pos = VG_POS_CENTERED;
      vg4->window->copy(imgp, &posi, &iattr);
    }
  } else {
    int steps = vg4->hash->getint(hparm, "steps");
    VG_IMAGECOPY_ATTR_DEFAULT(&iattr);
    iattr.pixel.opaqueness = 60;
    vg4->window->copy(objvars->imgp_wfz[steps - 1], NULL, &iattr);
    posi.x = xpos;
    posi.y = ypos;
    posi.pos = VG_POS_CENTERED;
    vg4->window->copy(objvars->imgp, &posi, NULL);
  }
}
