/* object OBJID_MUSIC */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-music.h"

unsigned int objnew_MUSIC(void *);

static void f_free(void *, void *);
static VG_BOOL f_run(void *, struct VG_Object *);


/* export-function to create a new object-instance of OBJID_MUSIC
 * @param vgame       private structure of the game
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_MUSIC(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_music *objvars;

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* load music */
  objvars->mus_papablue = vg4->audio->load("files/audio/mus_papablue.mid", 30, VG_AUDIO_VOLUME_MUSIC);
  objvars->mus_papablack = vg4->audio->load("files/audio/mus_papablack.mid", 30, VG_AUDIO_VOLUME_MUSIC);

  /* create object-instance */
  objp = vg4->object->create(OBJID_MUSIC, 0, 0, 1, objvars);
  objp->f_free = f_free;
  objp->f_run = f_run;

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_music *objvars = (struct sobj_music *)opriv;

  (void)vgame;

  /* free private struct */
  if (objvars->mus_papablue > 0) { vg4->audio->unload(objvars->mus_papablue); }
  if (objvars->mus_papablack > 0) { vg4->audio->unload(objvars->mus_papablack); }
  free(objvars);
}


/* move object-instance, called from vg4->object->call_run() */
static VG_BOOL
f_run(void *vgame, struct VG_Object *objp)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct sobj_music *objvars = (struct sobj_music *)objp->opriv;

  if (sgame == NULL) { return VG_TRUE; }

  if (vg4->object->has_instances(OBJID_SMURF, SPECIES_PAPASMURF_BLACK)) {
    if (objvars->mus_playing != objvars->mus_papablack) {
      if (objvars->mus_playing > 0) { vg4->audio->stop(objvars->mus_playing, VG_TRUE); }
      objvars->mus_playing = objvars->mus_papablack;
      vg4->audio->play(objvars->mus_playing, VG_TRUE, VG_TRUE);
    }
  } else {
    if (objvars->mus_playing != objvars->mus_papablue) {
      if (objvars->mus_playing > 0) { vg4->audio->stop(objvars->mus_playing, VG_TRUE); }
      objvars->mus_playing = objvars->mus_papablue;
      vg4->audio->play(objvars->mus_playing, VG_TRUE, VG_TRUE);
    }
  }

  return VG_TRUE;
}
