/* object OBJID_PLAYFIELD */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "obj-playfield.h"

unsigned int objnew_PLAYFIELD(void *, VG_BOOL);

static void f_free(void *, void *);
static void f_draw(void *, struct VG_Object *);


static void
set_map(struct s_game *sgame, VG_BOOL ishard)
{
  static struct {
    int xpos, ypos, starting, mirrordraw;
  } mappos[PLAYFIELD_STEPS] = {
    { 320, 260, 0, VG_FALSE },  /* village */
    { 321, 431, 0, VG_FALSE },  /* divergency to village */
    { 264, 429, 0, VG_FALSE },
    { 213, 412, 0, VG_FALSE },
    { 159, 408, 0, VG_FALSE },
    { 114, 384, 1, VG_FALSE },  /* starting for smurfs */
    { 105, 325, 0, VG_FALSE },  /* divergency to sarsaparille */
    { 74, 275, 0, VG_FALSE },
    { 49, 227, 0, VG_FALSE },
    { 36, 168, 0, VG_FALSE },
    { 40, 115, 0, VG_FALSE },
    { 58, 66, 0, VG_TRUE },    /* in sarsaparille */
    { 103, 35, 2, VG_TRUE },   /* in sarsaparille and starting for papa-smurf */
    { 163, 36, 0, VG_TRUE },
    { 226, 45, 0, VG_TRUE },
    { 286, 44, 0, VG_TRUE },
    { 346, 59, 0, VG_TRUE },   /* in river */
    { 402, 60, 0, VG_TRUE },
    { 462, 55, 0, VG_TRUE },
    { 522, 46, 0, VG_TRUE },
    { 578, 61, 3, VG_TRUE },   /* starting for the fly */
    { 591, 116, 0, VG_FALSE },
    { 568, 167, 0, VG_FALSE },
    { 546, 224, 0, VG_FALSE },
    { 516, 280, 0, VG_FALSE },
    { 492, 329, 0, VG_FALSE },  /* in river */
    { 480, 379, 0, VG_FALSE },  /* in river */
    { 444, 426, 0, VG_FALSE },
    { 384, 420, 0, VG_FALSE },  /* little sarsaparille */
    { 131, 253, 0, VG_TRUE },  /* from divergency to sarsaparille */
    { 145, 189, 0, VG_TRUE },
    { 166, 130, 0, VG_TRUE },
    { 187, 78, 0, VG_TRUE },
  };
  int step;

  if (sgame == NULL) { VG_dest(); exit(1); }

  memset(sgame->pfmap, 0, sizeof(sgame->pfmap));
  for (step = 0; step < PLAYFIELD_STEPS; step++) {
    sgame->pfmap[step].xpos = mappos[step].xpos;
    sgame->pfmap[step].ypos = mappos[step].ypos;
    sgame->pfmap[step].starting = mappos[step].starting;
    sgame->pfmap[step].mirrordraw = mappos[step].mirrordraw;
    sgame->pfmap[step].next[0] = step + 1;
    sgame->pfmap[step].next[1] = -1;
  }

  sgame->pfmap[0].village = VG_TRUE;
  sgame->pfmap[1].next[1] = 0;
  sgame->pfmap[6].next[1] = 29;
  sgame->pfmap[16].river = VG_TRUE;
  sgame->pfmap[25].river = VG_TRUE;
  sgame->pfmap[26].river = VG_TRUE;
  sgame->pfmap[11].sarsaparille = VG_TRUE;
  sgame->pfmap[12].sarsaparille = VG_TRUE;
  sgame->pfmap[32].next[0] = 14;
  if (!ishard) {
    sgame->pfmap[28].sarsaparille = VG_TRUE;
  }
  sgame->pfmap[28].next[0] = 1;
}


/* export-function to create a new object-instance of OBJID_PLAYFIELD
 * @param vgame    private structure of the game
 * @param ishard   VG_FALSE = easy, VG_TRUE = hard
 * @return  instance-ID or 0 = error
 */
unsigned int
objnew_PLAYFIELD(void *vgame, VG_BOOL ishard)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Object *objp;
  struct sobj_playfield *objvars;

  if (sgame == NULL) { return 0; }

  /* create private struct */

  objvars = calloc(1, sizeof(*objvars));
  if (objvars == NULL) { return 0; }

  /* load images */
  if (ishard) {
    objvars->imgp = vg4->image->load("files/images/playfield-difficult.bmp");
  } else {
    objvars->imgp = vg4->image->load("files/images/playfield-easy.bmp");
  }
  if (objvars->imgp == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_smurf_pending = vg4->image->load("files/images/smurfs/smurf_pending.bmp");
  if (objvars->imgp_smurf_pending == NULL) { f_free(vgame, objvars); return 0; }
  objvars->imgp_smurf_saved = vg4->image->load("files/images/smurfs/smurf_saved.bmp");
  if (objvars->imgp_smurf_saved == NULL) { f_free(vgame, objvars); return 0; }

  /* create object-instance */
  objp = vg4->object->create(OBJID_PLAYFIELD, 0, 0, 1, objvars);
  objp->f_free = f_free;
  objp->f_draw = f_draw;

  /* set playfield-map according to playfield-image */
  set_map(sgame, ishard);

  return objp->instanceid;
}


/* free private struct of object-instance, called from vg4->object->destroy() */
static void
f_free(void *vgame, void *opriv)
{
  struct sobj_playfield *objvars = (struct sobj_playfield *)opriv;

  (void)vgame;

  /* free private struct */
  if (objvars->imgp != NULL) { vg4->image->destroy(objvars->imgp); }
  if (objvars->imgp_smurf_pending != NULL) { vg4->image->destroy(objvars->imgp_smurf_pending); }
  if (objvars->imgp_smurf_saved != NULL) { vg4->image->destroy(objvars->imgp_smurf_saved); }
  free(objvars);
}


/* draw object-instance, called from vg4->object->call_draw() */
static void
f_draw(void *vgame, struct VG_Object *objp)
{
  struct sobj_playfield *objvars = (struct sobj_playfield *)objp->opriv;
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Position posi;
  struct VG_Image *imgp;
  char buf[32];

  if (sgame == NULL) { return; }

  vg4->window->copy(objvars->imgp, NULL, NULL);

  if (sgame->smurf_pending > 0) {
    posi.x = 100;
    posi.y = 420;
    posi.pos = VG_POS_CENTERED;
    vg4->window->copy(objvars->imgp_smurf_pending, &posi, NULL);
    snprintf(buf, sizeof(buf), "%d", sgame->smurf_pending);
    imgp = vg4->font->totext(buf, "[fgcolor=0x000000]", NULL, NULL, NULL);
    if (imgp != NULL) {
      posi.x = 113;
      posi.y = 417;
      posi.pos = VG_POS_CENTERED;
      vg4->window->copy(imgp, &posi, NULL);
      vg4->image->destroy(imgp);
    }
  }

  if (sgame->smurf_saved > 0) {
    posi.x = 375;
    posi.y = 262;
    posi.pos = VG_POS_CENTERED;
    vg4->window->copy(objvars->imgp_smurf_saved, &posi, NULL);
    snprintf(buf, sizeof(buf), "%d", sgame->smurf_saved);
    imgp = vg4->font->totext(buf, "[fgcolor=0x000000]", NULL, NULL, NULL);
    if (imgp != NULL) {
      posi.x = 375;
      posi.y = 280;
      posi.pos = VG_POS_CENTERED;
      vg4->window->copy(imgp, &posi, NULL);
      vg4->image->destroy(imgp);
    }
  }

#if 0
  { int step, fcolor;
    char tparm[64];
    for (step = 0; step < PLAYFIELD_STEPS; step++) {
      snprintf(buf, sizeof(buf), "%d:\n%02d,%02d", step, sgame->pfmap[step].next[0], sgame->pfmap[step].next[1]);
      if (sgame->pfmap[step].village) {
        fcolor = VG_COLOR_RED;
      } else if (sgame->pfmap[step].sarsaparille) {
        fcolor = VG_COLOR_YELLOW;
      } else if (sgame->pfmap[step].river) {
        fcolor = VG_COLOR_GREEN;
      } else {
        fcolor = VG_COLOR_TURQUOISE;
      }
      snprintf(tparm, sizeof(tparm), "[fgcolor=0x%06x bgcolor=0x000000]", vg4->misc->colorbrightness(fcolor, 100));
      imgp = vg4->font->totext(buf, tparm, NULL, NULL, NULL);
      if (imgp != NULL) {
        posi.x = sgame->pfmap[step].xpos;
        posi.y = sgame->pfmap[step].ypos;
        posi.pos = VG_POS_CENTERED;
        vg4->window->copy(imgp, &posi, NULL);
        vg4->image->destroy(imgp);
      }
    }
  }
#endif
}
