#ifndef OBJ_SMURF_H_
#define OBJ_SMURF_H_

#include "main.h"

/* private structure for object OBJID_SMURF */
struct sobj_smurf {
  struct VG_Rect rect;              /* rectangle */
  struct VG_Image *imgp_normal;     /* normal image */
  struct VG_Image *imgp_mouseover;  /* mouse-over image */
  struct VG_Image *imgp_black;      /* black-smurf image */
  int snd_flymoving;                /* audio-descriptor when fly is moving */
  struct {                          /* for papasmurf */
    struct VG_Image *imgp_empty;      /* image when empty */
    int fuel;                         /* sarsaparille in his bellows */
  } papa;
  int pfstep;                       /* actual playfield-step-number */
  VG_BOOL mouseover;                /* whether mouse-over */
  int vanish;                       /* whether black smurf vanishes */
  struct {                          /* next moving position */
    struct VG_Rect *rectmov;          /* positions of moving between both playfield-step-numbers */
    int movmax, movmom;               /* number of positions in rectmov, and actual position-index */
  } pos;
};

#endif /* OBJ_SMURF_H_ */
