/* management of object OBJID_SMURF */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include "main.h"

VG_BOOL objmgmt_SMURF(void *);

static void f_free(void);
static void f_run(void *);

/* internal structure for this object-management */
static struct {
  int smurf_active;  /* number of active smurfs */
} mgmt_smurf;


/* export-function to create the management of OBJID_SMURF
 * @param vgame       private structure of the game
 * @return  VG_TRUE = OK or VG_FALSE = Error
 */
VG_BOOL
objmgmt_SMURF(void *vgame)
{     
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_ObjMgmt *omgmt;

  if (sgame == NULL) { return VG_FALSE; }

  /* set internal structure for this object-management */

  memset(&mgmt_smurf, 0, sizeof(mgmt_smurf));

  sgame->smurf_pending = 20;
  mgmt_smurf.smurf_active = 7;

  sgame->smurf_total = sgame->smurf_pending;

  /* create object-management */
  omgmt = vg4->object->mgmt_create(OBJID_SMURF);
  omgmt->f_free = f_free;
  omgmt->f_run = f_run;

  return VG_TRUE;
}


/* reset internal structure for this object-management, called from vg4->object->mgmt_destroy() */
static void
f_free(void)
{ 
  memset(&mgmt_smurf, 0, sizeof(mgmt_smurf));
}


/* execute managing, called from vg4->object->call_mgmt_run() */
static void
f_run(void *vgame)
{
  struct s_game *sgame = (struct s_game *)vgame;
  struct VG_Hash *hparm;
  unsigned int name_id;

  if (sgame == NULL) { return; }

  hparm = vg4->actionstack->get(&name_id);

  /* handle no action */
  if (name_id == 0) {
    int numberof, ipos;
    unsigned int *idlist; 
    struct VG_Object *objp = NULL;
    int pfstep, startblue, anzblue, anzblack;
    
    /* find starting-field for normal smurf */
    for (startblue = 0; startblue < PLAYFIELD_STEPS; startblue++) {
      if (sgame->pfmap[startblue].starting == 1) { break; }
    }
    if (startblue == PLAYFIELD_STEPS) { startblue = -1; }

    /* count active blue and black smurfs and check whether starting-field is free */
    anzblue = anzblack = 0;
    numberof = vg4->object->list(OBJID_SMURF, 0, &idlist);
    for (ipos = 0; ipos < numberof; ipos++) {
      objp = vg4->object->instance_getobj(idlist[ipos]);
      if (vg4->object->call_data(sgame, objp->instanceid, &pfstep) > 0) {
        if (objp->subid == SPECIES_SMURF_BLACK || objp->subid == SPECIES_PAPASMURF_BLACK || objp->subid == SPECIES_FLY) {
          if (startblue >= 0) {
            if (pfstep == startblue) { startblue = -1; }  /* starting-field black-occupated */
          }
        }
      }
      if (objp->subid == SPECIES_SMURF) { anzblue++; }
      if (objp->subid == SPECIES_SMURF_BLACK) { anzblack++; }
    }
    if (idlist != NULL) { free(idlist); }

    /* throw dice */
    vg4->actionstack->push(UART_DICE, NULL);

    /* if no blue smurf is active, all black smurfs vanish */
    if ((sgame->smurf_pending == 0 && anzblue == 0) || (anzblack == mgmt_smurf.smurf_active)) {
      if (sgame->smurf_pending == 0 && anzblack == 0) {
        /* exit if no blue smurf (except papa-smurf) is left */
        sgame->game_won = VG_TRUE;
        vg4->actionstack->pop();  /* pop dice */
        return;
      } else {
        struct VG_Hash *hparm2 = vg4->hash->create(); 
        numberof = vg4->object->list(OBJID_SMURF, SPECIES_SMURF_BLACK, &idlist);
        for (ipos = 0; ipos < numberof; ipos++) {
          vg4->object->call_data(sgame, idlist[ipos], NULL);
        }
        if (idlist != NULL) { free(idlist); }
        if (sgame->smurf_pending == 0 && anzblue == 0) { vg4->actionstack->pop(); }  /* pop dice */
        vg4->hash->setint(hparm2, "num", ANIMATION_BLACKSMURF_BYE);
        vg4->actionstack->push(UART_ANIMATION, hparm2);
        anzblack = 0;
      }
    }

    /* instantiate a new smurf? */
    if ((startblue >= 0 || anzblue == 0) && sgame->smurf_pending > 0 && mgmt_smurf.smurf_active > anzblue + anzblack) {
      if (objnew_SMURF(sgame, SPECIES_SMURF) > 0) {
        sgame->smurf_pending--;
      } else {
        sgame->smurf_pending = 0;
      }
    }

    return;
  }

  /* relevant? */
  if (name_id != UART_SELSMURF) { return; }

  if (hparm == NULL || vg4->hash->getint(hparm, "steps") == 0) {
    /* move black smurf */
    int numberof, ipos;
    unsigned int *idlist; 
    int pfstep, pfstep1, pfstep2;
    struct VG_Object *objp;
    int bluesteps[PLAYFIELD_STEPS];
    unsigned int black_mov_id[vg4->object->list(OBJID_SMURF, 0, NULL) + 1];
    unsigned int black_hit_id[vg4->object->list(OBJID_SMURF, 0, NULL) + 1];
    int blacksteps, black_mov_pos, black_hit_pos;

    blacksteps = ZUFALL(1, MAX_DICE_NUMBER);

    /* get playfield-steps occupated by blue smurfs */
    memset(bluesteps, 0, sizeof(bluesteps));
    numberof = vg4->object->list(OBJID_SMURF, 0, &idlist);
    for (ipos = 0; ipos < numberof; ipos++) {
      objp = vg4->object->instance_getobj(idlist[ipos]);
      if (objp->subid == SPECIES_SMURF || objp->subid == SPECIES_PAPASMURF) {
        if (vg4->object->call_data(sgame, objp->instanceid, &pfstep) > 0) { bluesteps[pfstep] = 1; }
      }
    }
    if (idlist != NULL) { free(idlist); }

    /* check moving each black smurf */
    memset(black_mov_id, 0, sizeof(black_mov_id)); black_mov_pos = 0;
    memset(black_hit_id, 0, sizeof(black_hit_id)); black_hit_pos = 0;
    numberof = vg4->object->list(OBJID_SMURF, 0, &idlist);
    for (ipos = 0; ipos < numberof; ipos++) {
      objp = vg4->object->instance_getobj(idlist[ipos]);
      if (objp->subid != SPECIES_SMURF_BLACK && objp->subid != SPECIES_PAPASMURF_BLACK) { continue; }
      if (vg4->object->call_data(sgame, objp->instanceid, &pfstep) > 0) {
        check_direction(sgame, pfstep, blacksteps, objp->subid, &pfstep1, &pfstep2);
        if (pfstep1 < 0 && pfstep2 < 0) { continue; }  /* moving not possible */
        black_mov_id[black_mov_pos++] = objp->instanceid;
        if (pfstep1 >= 0 && bluesteps[pfstep1]) {  /* hit moving left */
          black_hit_id[black_hit_pos++] = objp->instanceid;
        } else if (pfstep2 >= 0 && bluesteps[pfstep2]) {  /* hit moving right */
          black_hit_id[black_hit_pos++] = objp->instanceid;
        }
      }
    }
    if (idlist != NULL) { free(idlist); }
    vg4->actionstack->pop();

    if (black_hit_pos > 0 || black_mov_pos > 0) {
      struct VG_Hash *hparm2 = vg4->hash->create(); 
      if (black_hit_pos > 0) {
        black_hit_pos = ZUFALL(0, black_hit_pos - 1);
        vg4->hash->setint(hparm2, "instanceid", black_hit_id[black_hit_pos]);
      } else if (black_mov_pos > 0) {
        black_mov_pos = ZUFALL(0, black_mov_pos - 1);
        vg4->hash->setint(hparm2, "instanceid", black_mov_id[black_mov_pos]);
      }
      vg4->hash->setint(hparm2, "steps", blacksteps);
      vg4->hash->setint(hparm2, "direction", 0);
      vg4->actionstack->push(UART_MOVSMURF, hparm2);
    }
    return;

  } else if (vg4->hash->getint(hparm, "instanceid") > 0) {
    /* start moving blue smurf-instance, after then select black smurf for moving */
    struct VG_Hash *hparm2 = vg4->hash->create(); 
    vg4->hash->setint(hparm2, "instanceid", vg4->hash->getint(hparm, "instanceid"));
    vg4->hash->setint(hparm2, "steps", vg4->hash->getint(hparm, "steps"));
    vg4->hash->setint(hparm2, "direction", 0);
    vg4->actionstack->pop();
    vg4->actionstack->push(UART_SELSMURF, NULL);
    vg4->actionstack->push(UART_MOVSMURF, hparm2);
    return;
  }

  /* select blue smurf */
  { struct VG_Hash *hparm2 = vg4->hash->create(); 
    vg4->hash->setint(hparm2, "steps", vg4->hash->getint(hparm, "steps"));
    vg4->actionstack->push(UART_MOUSESEL, hparm2);
  }
}
