#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames.h>
#include "main.h"

int intro(int);
int extro(void);
static int zeigs(int,const char *);
static char * itext(int);
static char * etext(int);


int intro(int flag) {
  /* flag: 0=return only, 1=Intro
  ** return value: 1=first time, 0=else
  */
  char buf[512],* txt;
  int vfarb,tlen,i1,ftim;
  FILE * ffp;
  CLEAR_BOX(NULL,RGB_BLACK);
  set_font(NULL,0,0);
  itext(0);
  vfarb=color_index(CL_TURQUOISE,100);

  /* erster Aufruf? */
  ftim=0;
  snprintf(buf,sizeof(buf),"%s/save/intro",install_path);
  if ((ffp=fopen(buf,"r"))==NULL) {
    ftim=1;
    if (flag==0) {return(ftim);}
    unlink(buf);
    if ((ffp=fopen(buf,"w"))!=NULL) {fclose(ffp);}
  } else {
    fclose(ffp);
  }
  if (flag==0) {return(ftim);}
  CLEAR_KEYS;
  if (ftim==0) {ADD_KEYS(KEY_SPACE,SHORT_KEY);}

  /* 1. Bild */
  txt=itext(lang_nr); tlen=strlen(txt);
  draw_text(NULL,vfarb,5,100,txt,tlen,RGB_TRANS);
  snprintf(buf,sizeof(buf),"%s/sprites/intro1.sprite",install_path);
  if (zeigs(150,buf)>0) {return(ftim);}

  /* 2. Bild */
  for (i1=0;i1<6;i1++) {
    txt=itext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/intro2.sprite",install_path);
  if (zeigs(400,buf)>0) {return(ftim);}

  /* 3. Bild */
  txt=itext(lang_nr); tlen=strlen(txt);
  draw_text(NULL,vfarb,5,100,txt,tlen,RGB_TRANS);
  snprintf(buf,sizeof(buf),"%s/sprites/intro3.sprite",install_path);
  if (zeigs(250,buf)>0) {return(ftim);}

  /* 4. Bild */
  for (i1=0;i1<5;i1++) {
    txt=itext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/intro4.sprite",install_path);
  if (zeigs(350,buf)>0) {return(ftim);}

  /* 5. Bild */
  for (i1=0;i1<5;i1++) {
    txt=itext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/intro5.sprite",install_path);
  if (zeigs(300,buf)>0) {return(ftim);}

  /* 6. Bild */
  for (i1=0;i1<5;i1++) {
    txt=itext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/intro6.sprite",install_path);
  if (zeigs(300,buf)>0) {return(ftim);}

  /* 7. Bild */
  for (i1=0;i1<6;i1++) {
    txt=itext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/intro7.sprite",install_path);
  if (zeigs(400,buf)>0) {return(ftim);}

  /* 8. Bild */
  for (i1=0;i1<6;i1++) {
    txt=itext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/intro8.sprite",install_path);
  if (zeigs(400,buf)>0) {return(ftim);}

  CLEAR_BOX(NULL,RGB_BLACK);
  flush_window();
  brightness(0);
  set_font(NULL,0,0);
  return(ftim);
} /* Ende intro */


int extro() {
  char buf[512],* txt;
  int vfarb,tlen,i1;
  CLEAR_BOX(NULL,RGB_BLACK);
  set_font(NULL,0,0);
  etext(0);
  vfarb=color_index(CL_TURQUOISE,100);

  CLEAR_KEYS;

  /* 1. Bild */
  for (i1=0;i1<5;i1++) {
    txt=etext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/extro1.sprite",install_path);
  if (zeigs(350,buf)>0) {return(0);}

  /* 2. Bild */
  for (i1=0;i1<5;i1++) {
    txt=etext(lang_nr); tlen=strlen(txt);
    draw_text(NULL,vfarb,5,100+12*i1,txt,tlen,RGB_TRANS);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/extro2.sprite",install_path);
  if (zeigs(400,buf)>0) {return(0);}

  CLEAR_BOX(NULL,RGB_BLACK);
  flush_window();
  brightness(0);
  set_font(NULL,0,0);
  return(0);
} /* Ende extro */


static int zeigs(int runden,const char * pfad) {
  int i1,xd,yd,x,y;
  grafik * grf;
  sprite * spr;
  if ((spr=load_sprite(pfad))!=NULL) {
    x=(SC_WIDTH-SPRITE_WIDTH(spr))/2; y=20;
  } else {x=y=0;}
  for (i1=-63;i1<=0;i1++) {
    if (spr!=NULL) {
      draw_fillbox(NULL,0,0,SC_WIDTH,100,RGB_BLACK);
      grf=next_sprite(spr,&xd,&yd);
      copy_grafik(NULL,x+xd,y+yd,grf,0,0,0,0,RGB_TRANS);
    }
    brightness(i1);
    flush_window();
    wait_time(30);
    get_keys();
    if (IS_KEYS(KEY_SPACE)) {
      if (spr!=NULL) {free_sprite(spr);}
      brightness(0);
      return(1);
    }
  }
  for (i1=0;i1<runden;i1++) {
    if (spr!=NULL) {
      draw_fillbox(NULL,0,0,SC_WIDTH,100,RGB_BLACK);
      grf=next_sprite(spr,&xd,&yd);
      copy_grafik(NULL,x+xd,y+yd,grf,0,0,0,0,RGB_TRANS);
    }
    flush_window();
    wait_time(30);
    get_keys();
    if (IS_KEYS(KEY_SPACE)) {
      if (spr!=NULL) {free_sprite(spr);}
      brightness(0);
      return(1);
    }
  }
  for (i1=0;i1>=-63;i1--) {
    if (spr!=NULL) {
      draw_fillbox(NULL,0,0,SC_WIDTH,100,RGB_BLACK);
      grf=next_sprite(spr,&xd,&yd);
      copy_grafik(NULL,x+xd,y+yd,grf,0,0,0,0,RGB_TRANS);
    }
    brightness(i1);
    flush_window();
    wait_time(30);
    get_keys();
    if (IS_KEYS(KEY_SPACE)) {
      if (spr!=NULL) {free_sprite(spr);}
      brightness(0);
      return(1);
    }
  }
  if (spr!=NULL) {free_sprite(spr);}
  CLEAR_BOX(NULL,RGB_BLACK);
  flush_window();
  return(0);
} /* Ende zeigs */


static char * itext(int lang_nr) {
  static int pos=0;
  if (lang_nr<=0) {pos=0; return(NULL);}
  if (lang_nr==2) {  /* englisch */
    switch(++pos) {
      /* Bild 1 */
      case 1:  return("This is a garden gnome");
      /* Bild 2 */
      case 2:  return("And that is the king gnome,");
      case 3:  return(" - William the Conqueror III -");
      case 4:  return("");
      case 5:  return("A puny gnome, who does not even");
      case 6:  return("have a beard. Besides nobody knows");
      case 7:  return("his real name ...");
      /* Bild 3 */
      case 8:  return("Nevertheless the garden gnomes obey him");
      /* Bild 4 */
      case 9:  return("That's the attac plan of the king gnome");
      case 10:  return("");
      case 11:  return("According to it, they want to conquer");
      case 12:  return("our country, to lay out gardens");
      case 13:  return("all over it. Strange, isn't it?");
      /* Bild 5 */
      case 14:  return("6:00 o'clock this morning.");
      case 15:  return("");
      case 16:  return("That's the time, when the attac");
      case 17:  return("plan was put into action.");
      case 18:  return("Not very kind, really?");
      /* Bild 6 */
      case 19:  return("8:00 o'clock this morning.");
      case 20:  return("");
      case 21:  return("This is now.");
      case 22:  return("For the most part our country is");
      case 23:  return("occupied. They are quick, aren't they?");
      /* Bild 7 */
      case 24:  return("This is the desk of colonel F.");
      case 25:  return("");
      case 26:  return("The poor colonel is running excitedly");
      case 27:  return("somewhere around and is searching for");
      case 28:  return("his best pilot, who please shall stop");
      case 29:  return("the invasion.");
      /* Bild 8 */
      case 30:  return("What did you say?");
      case 31:  return("");
      case 32:  return("No, your mission is not to help the");
      case 33:  return("colonel searching for his pilot.");
      case 34:  return("YOU are his pilot! Go to colonel F.,");
      case 35:  return("but quickly ...");
    }
  } else {  /* deutsch */
    switch(++pos) {
      /* Bild 1 */
      case 1:  return("Dies ist ein Gartenzwerg");
      /* Bild 2 */
      case 2:  return("Und das da ist der Oberzwerg,");
      case 3:  return(" - Wilhelm der Eroberer III -");
      case 4:  return("");
      case 5:  return("Ein kmmerlicher Zwerg, der nicht mal");
      case 6:  return("einen Bart hat. Auerdem kennt niemand");
      case 7:  return("seinen richtigen Namen ...");
      /* Bild 3 */
      case 8:  return("Trotzdem gehorchen ihm die Gartenzwerge");
      /* Bild 4 */
      case 9:  return("Das ist der Angriffsplan des Oberzwergs");
      case 10:  return("");
      case 11:  return("Er sieht vor, unser Land zu erobern,");
      case 12:  return("um berall Grten anzulegen.");
      case 13:  return("Kurios, was?");
      /* Bild 5 */
      case 14:  return("6:00 Uhr heute morgen.");
      case 15:  return("");
      case 16:  return("Dies ist die Zeit, zu der der");
      case 17:  return("Angriffsplan in die Tat umgesetzt");
      case 18:  return("wurde. Unfreundlich, nicht wahr?");
      /* Bild 6 */
      case 19:  return("8:00 Uhr heute morgen.");
      case 20:  return("");
      case 21:  return("Dies ist die jetzige Zeit.");
      case 22:  return("Weite Teile unseres Landes sind");
      case 23:  return("bereits besetzt. Irre schnell, gell?");
      /* Bild 7 */
      case 24:  return("Dies ist der Schreibtisch von Oberst F.");
      case 25:  return("");
      case 26:  return("Der arme Oberst rennt irgendwo");
      case 27:  return("aufgeregt herum und sucht seinen besten");
      case 28:  return("Piloten. Der soll nmlich die Invasion");
      case 29:  return("aufhalten.");
      /* Bild 8 */
      case 30:  return("Was meinten Sie soeben?");
      case 31:  return("");
      case 32:  return("Nein, Sie sollen dem Oberst nicht bei");
      case 33:  return("der Suche seines Piloten helfen.");
      case 34:  return("SIE sind gemeint! Begeben Sie sich");
      case 35:  return("zu Oberst F., aber schnell ...");
    }
  }
  return("");
} /* Ende itext */


static char * etext(int lang_nr) {
  static int pos=0;
  if (lang_nr<=0) {pos=0; return(NULL);}
  if (lang_nr==2) {  /* englisch */
    switch(++pos) {
      case 1:  return("Well done, pilot!");
      case 2:  return("");
      case 3:  return("The garden gnomes will furthermore");
      case 4:  return("have to use their own gardens.");
      case 5:  return("");
      /* Bild 2 */
      case 6:  return("Colonel F. ist proud of you and");
      case 7:  return("allows you half a pound of ordens.");
      case 8:  return("They be will sent to you tomorrow per");
      case 9:  return("post. The postage you have to pay,");
      case 10:  return("of course.");
    }
  } else {  /* deutsch */
    switch(++pos) {
      /* Bild 1 */
      case 1:  return("Gute Arbeit, Pilot!");
      case 2:  return("");
      case 3:  return("Die Gartenzwerge werden weiterhin mit");
      case 4:  return("ihren eigenen Grten vorlieb nehmen");
      case 5:  return("mssen.");
      /* Bild 2 */
      case 6:  return("Oberst F. ist stolz auf Sie und");
      case 7:  return("bewilligt Ihnen ein halbes Pfund Orden.");
      case 8:  return("Sie werden Ihnen morgen per Post");
      case 9:  return("zugesandt. Porto geht zu Ihren Lasten,");
      case 10:  return("versteht sich.");
    }
  }
  return("");
} /* Ende etext */
