/* game function for 3plane */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <vgagames.h>
#include "main.h"
#include "kette.h"

#ifndef M_PI
  #define M_PI  3.14159265358979323846
#endif
#ifndef PI
  #define PI  M_PI
#endif
#ifndef PI2
  #define PI2  (M_PI + M_PI)
#endif

#define MAX_FKETTE 64
#define MAX_IKETTE 16

#define MAX_I_LEPU 30

#define MUNSCHUESSE 100

struct neue_fzg {
  int fndmax;  /* number of allocated elements in du_fzg */
  int fndmom;
  grafik ** text;  /* appearing text */
  int textmax;
  int * bld;  /* screen number when becoming active */
  int rgbmax;
  int * rgb1;  /* colormap: 0=RGB256, 1=GREY256 */
  int * rgb2;  /* brightness */
  struct f_fzg * du_fzg;  /* allocated list */
};

static int trfz_min=0,trfz_2=0;
static int mun_schuss=0,mun_magazin=0;
static int wav_eff=CN_(1)|CN_(2)|CN_(3)|CN_(4);
static int wav_troet=CN_(6);
static int wav_mus=CN_(5);

char * game(int *,int *);
static grafik * lade_weg(int,struct neue_fzg *);
static char * init_ich(struct i_fzg *,struct i_shs *,int);
static void entlade_weg(struct neue_fzg *);
static int ob_treffer(void *,void *,int);
static int xy2winkel(double,double);
static void winkel2xy(int,double *,double *);
int rechnei(const char *,int []);


char * game(int * runde,int * lepu) {
  const int wpix_decr=1;  /* decrement for wpix each loop */
  int i1,i2,scmom,x1,x2,e_luft,zeigetext,rumms,rummi,troet;
  struct neue_fzg alle_fzg;
  struct kette ** ktt_ffzg,** ktt_fshs,** ktt_ishs;
  grafik * gweg,* gesbalk,* gr_ptr,* shs_gr[4],* grmag;
  char * p1,val[128];
  int wpix;
  int iktte[MAX_IKETTE],ikt_mom,ikt_max;
  int fktte[MAX_FKETTE],fkt_mom,fkt_max;
  int r_status=0;  /* return value for completed mission:
                   ** -2=quit -1=game over, 0=mission failed, 1=successful
                   */
  int mission_ende=0;  /* set to >0 when mission completed */
  int gesund=0;
  float f1,f1x,f1y;
  struct i_fzg ich_fzg;
  struct i_shs ich_shs[MAX_IKETTE],* ich_ptrs;
  struct f_fzg * du_fzg[MAX_FKETTE],* du_ptrf;
  struct f_shs du_shs[MAX_FKETTE],* du_ptrs;

  if (((ktt_ffzg=kette_create(MAX_FKETTE))==NULL) \
  || ((ktt_fshs=kette_create(MAX_FKETTE))==NULL) \
  || ((ktt_ishs=kette_create(MAX_IKETTE))==NULL)) {
    return("game.c: allocation error (kette)");
  }
  CLEAR_KEYS;
  ADD_KEYS(KEY_UCURS,LONG_KEY);
  ADD_KEYS(KEY_DCURS,LONG_KEY);
  ADD_KEYS(KEY_RCURS,LONG_KEY);
  ADD_KEYS(KEY_LCURS,LONG_KEY);
  ADD_KEYS(KEY_LCTRL,LONG_KEY);
  ADD_KEYS(KEY_LALT,LONG_KEY);
  ADD_KEYS(KEY_P,SHORT_KEY);
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  ADD_KEYS(KEY_F2,SHORT_KEY);

  /* +++ loading way graphic and initialization +++ */
  CLEAR_BOX(NULL,RGB_BLACK);
  if ((gweg=lade_weg(*runde,&alle_fzg))==NULL) {return("game.c: cannot load way graphic");}
  if ((wpix=GRAFIK_HEIGHT(gweg)-SC_HEIGHT)<=wpix_decr) {return("game.c: way graphic too small");}
  scmom=1;
  zeigetext=150;
  rumms=rummi=troet=0;
  if ((p1=init_ich(&ich_fzg,ich_shs,*lepu))!=NULL) {return(p1);}
  if ((gesbalk=create_grafik(102,5))==NULL) {return("game.c: error creating graphic gesbalk");}
  if ((grmag=create_grafik(7,5))==NULL) {return("game.c: error creating graphic grmag");}
  draw_fillbox(grmag,0,0,7,5,color_index(CL_BROWN,100));
  draw_pixel(grmag,0,0,RGB_BLACK);
  draw_pixel(grmag,2,0,RGB_BLACK);
  draw_pixel(grmag,2,1,RGB_BLACK);
  draw_pixel(grmag,4,0,RGB_BLACK);
  draw_pixel(grmag,4,1,RGB_BLACK);
  draw_pixel(grmag,6,0,RGB_BLACK);

  /* +++ loop +++ */
  play_wave(mus_nr[*runde],wav_mus,1,0);  /* Musik */
  clearstate();
  while (wpix>0) {

    if ((mission_ende) && (--mission_ende==0)) {break;}

    /* +++ check own air plane whether hit +++ */
    if ((ich_fzg.lebenspunkte>0) && (mission_ende==0)) {
      /* enemies */
      fkt_max=kette_members(ktt_ffzg,fktte);  /* get all active enemies into fktte */
      for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
        /* test with existing enemy air planes */
        du_ptrf=du_fzg[fktte[fkt_mom]];
        if ((du_ptrf->lebenspunkte>0) && (du_ptrf->def->luft) \
        && ((i1=ob_treffer(&ich_fzg,du_ptrf,1)))) {  /* collapsed */
          if ((ich_fzg.lebenspunkte-=i1)<=0) {
            ich_fzg.lebenspunkte=0;
            ich_fzg.expl_runde=expl_sum;
            ich_fzg.expl_pos=0;
          } else {
            ich_fzg.expl_pos=-1;
            ich_fzg.expl_runde=tref_sum;
          }
          if ((du_ptrf->lebenspunkte-=du_ptrf->def->minus_collp)<=0) {
            du_ptrf->lebenspunkte=0;
            du_ptrf->expl_runde=expl_sum;
            du_ptrf->expl_pos=0;
            if (du_ptrf->trfz==2) {trfz_2=0; mission_ende=120;}
            else {r_status+=du_ptrf->trfz;}
          } else {
            du_ptrf->expl_runde=tref_sum;
            du_ptrf->expl_pos=-1;
          }
          rumms=30; rummi=0;
          play_wave(wav_nr[WAVE_I_E],wav_eff,0,0);  /* Zusammenstoss */
        }
      }
      /* shots */
      fkt_max=kette_members(ktt_fshs,fktte);  /* get all active shots into fktte */
      for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
        /* test with shots */
        du_ptrs=&du_shs[fktte[fkt_mom]];
        if ((du_ptrs->lebenspunkte>0) \
        && ((i1=ob_treffer(&ich_fzg,du_ptrs,2)))) {  /* hit */
          if ((ich_fzg.lebenspunkte-=i1)<=0) {
            ich_fzg.lebenspunkte=0;
            ich_fzg.expl_runde=expl_sum;
            ich_fzg.expl_pos=0;
            play_wave(wav_nr[WAVE_ES_I],wav_eff,0,0);  /* Schuss zerstoert 3plane */
          } else {
            ich_fzg.expl_runde=tref_sum;
            ich_fzg.expl_pos=-1;
            /* SOUND Schuss trifft 3plane */
          }
          du_ptrs->lebenspunkte=0;
        }
      }
    }

    /* +++ check own shots whether hit +++ */
    ikt_max=kette_members(ktt_ishs,iktte);  /* get all own shots into iktte */
    for (ikt_mom=0;ikt_mom<ikt_max;ikt_mom++) {  /* active indices */
      ich_ptrs=&ich_shs[iktte[ikt_mom]];
      /* enemies */
      fkt_max=kette_members(ktt_ffzg,fktte);  /* get all active enemies into fktte */
      for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
        du_ptrf=du_fzg[fktte[fkt_mom]];
        if ((du_ptrf->lebenspunkte>0) \
        && ((i1=ob_treffer(ich_ptrs,du_ptrf,3)))) {  /* hit */
          ich_ptrs->lebenspunkte=0;
          if ((du_ptrf->lebenspunkte-=du_ptrf->def->minus_shs)<=0) {
            du_ptrf->lebenspunkte=0;
            du_ptrf->expl_runde=expl_sum;
            du_ptrf->expl_pos=0;
            if (du_ptrf->trfz==2) {trfz_2=0; mission_ende=120;}
            else {r_status+=du_ptrf->trfz;}
            play_wave(wav_nr[WAVE_IS_E],wav_eff,0,0);  /* Schuss zerstoert Feind */
          } else {
            du_ptrf->expl_runde=tref_sum;
            du_ptrf->expl_pos=-1;
            /* SOUND Schuss trifft Feind */
          }
          break;
        }
      }
      if (ich_ptrs->lebenspunkte==0) {continue;}
      /* shots */
      fkt_max=kette_members(ktt_fshs,fktte);  /* get all active shots into fktte */
      for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
        du_ptrs=&du_shs[fktte[fkt_mom]];
        if ((du_ptrs->lebenspunkte>0) \
        && (du_ptrs->art>1) && ((i1=ob_treffer(ich_ptrs,du_ptrs,4)))) {  /* hit */
          ich_ptrs->lebenspunkte=0;
          du_ptrs->lebenspunkte=0;
          play_wave(wav_nr[WAVE_IS_ES],wav_eff,0,0);  /* Schuss zerstoert Schuss */
          break;
        }
      }
    }

    /* +++ decrement wpix and check for new screen +++ */
    wpix-=wpix_decr;
    if ((wpix+wpix_decr)%SC_HEIGHT<wpix%SC_HEIGHT) {  /* new screen */
      scmom++;  /* screen number */
      if (alle_fzg.rgb1[scmom-2]!=alle_fzg.rgb1[scmom-1]) {
        load_colormap(alle_fzg.rgb1[scmom-1]==0?RGB256:GREY256);
      }
      if (alle_fzg.rgb2[scmom-2]!=alle_fzg.rgb2[scmom-1]) {
        brightness(alle_fzg.rgb2[scmom-1]);
      }
      if (mission_ende==0) {
        /* set all enemies of this screen active */
        while ((alle_fzg.fndmom<alle_fzg.fndmax) \
        && (alle_fzg.bld[alle_fzg.fndmom]==scmom)) {
          i1=kette_activate_memb(ktt_ffzg,1);
          du_fzg[i1]=&alle_fzg.du_fzg[alle_fzg.fndmom];
          alle_fzg.fndmom++;
        }
        zeigetext=150;
      }
    }
    if (wpix<=0) {break;}  /* mission clear */

    /* +++ increase own air planes health +++ */
    if (ich_fzg.lebenspunkte>0) {
      if (++gesund==20*diffi) {
        if (++ich_fzg.lebenspunkte>MAX_I_LEPU) {ich_fzg.lebenspunkte=MAX_I_LEPU;}
        gesund=0;
      }
    }

    /* +++ move own air plane +++ */
    get_keys();
    if (ich_fzg.lebenspunkte>0) {
      static int fire_gdr=0;
      if (IS_KEYS(KEY_UCURS)==1) {  /* go up */
        if ((ich_fzg.ym-=3.)<(float)(SPRITE_HEIGHT(ich_fzg.bild[0])/2)) {ich_fzg.ym=(float)(SPRITE_HEIGHT(ich_fzg.bild[0])/2);}
      }
      if (IS_KEYS(KEY_DCURS)==1) {  /* go down */
        if ((ich_fzg.ym+=3.)>(float)(SC_HEIGHT-SPRITE_HEIGHT(ich_fzg.bild[0])/2)) {ich_fzg.ym=(float)(SC_HEIGHT-SPRITE_HEIGHT(ich_fzg.bild[0])/2);}
      }
      if (IS_KEYS(KEY_RCURS)==1) {  /* go right */
        if ((ich_fzg.xm+=4.)>(float)(SC_WIDTH-1)) {ich_fzg.xm=(float)(SC_WIDTH-1);}
      }
      if (IS_KEYS(KEY_LCURS)==1) {  /* go left */
        if ((ich_fzg.xm-=4.)<0.) {ich_fzg.xm=0.;}
      }
      if (IS_KEYS(KEY_F2)) {  /* screenshot as ppm */
        save_grafik_as_ppm(NULL,"/tmp/_vgag_bs.ppm");
      }
      if (IS_KEYS(KEY_LCTRL)==1) {  /* fire MG */
        if (fire_gdr<1) {
          if (mun_schuss>0) {
            if ((i1=kette_activate_memb(ktt_ishs,0))>=0) {
              ich_shs[i1].lebenspunkte=1;
              ich_shs[i1].xm=ich_fzg.xm;
              ich_shs[i1].ym=ich_fzg.ym-SPRITE_WIDTH(ich_fzg.bild[0])/2+8;
              ich_shs[i1].xp=0.;
              ich_shs[i1].yp=-5.;
              fire_gdr=3;
              mun_schuss--;
            }
          } else if (mun_magazin==0) {
            static int zhlleer=0;
            if (++zhlleer==7) {
              play_wave(wav_nr[WAVE_MUN0],wav_eff,0,0);  /* Mun leer */
              zhlleer=0;
            }
          }
        } else {fire_gdr--;}
      } else {fire_gdr=0;}
      if ((mun_schuss<=0) && (mun_magazin>0)) {
        if (--mun_schuss==-8) {
          play_wave(wav_nr[WAVE_MUN1],wav_eff,0,0);  /* Mun nachladen */
        } else if (mun_schuss==-25) {mun_schuss=MUNSCHUESSE; mun_magazin--;}
      }
    }
    if (IS_KEYS(KEY_P)==1) {  /* pause */
      pause_wave(CN_ALL);
      draw_text(NULL,color_index(CL_GREEN,100),SC_WIDTH/2-20,(SC_HEIGHT-10)/2-4,"PAUSE",5,RGB_TRANS);
      flush_window();
      do {
        wait_time(150);
        get_keys();
      } while (IS_KEYS(KEY_P)==0);
      continue_wave(CN_ALL);
    }
    if (IS_KEYS(KEY_ENTER)==1) {  /* menu */
      stop_wave(CN_ALL,0);
      load_colormap(RGB256);
      brightness(0);
      if (menu_main(NULL,NULL)==0) {r_status=-2; break;}  /* quit */
      load_colormap(alle_fzg.rgb1[scmom-1]==0?RGB256:GREY256);
      brightness(alle_fzg.rgb2[scmom-1]);
      play_wave(mus_nr[*runde],wav_mus,1,0);  /* Musik */
    }

    /* +++ move own shots +++ */
    ikt_max=kette_members(ktt_ishs,iktte);  /* get all own shots into iktte */
    for (ikt_mom=0;ikt_mom<ikt_max;ikt_mom++) {  /* active indices */
      ich_ptrs=&ich_shs[iktte[ikt_mom]];
      if (ich_ptrs->lebenspunkte==0) {
        kette_inactivate_memb(ktt_ishs,iktte[ikt_mom]);
        continue;
      }
      ich_ptrs->xm+=ich_ptrs->xp;
      ich_ptrs->ym+=ich_ptrs->yp;
      if ((ich_ptrs->xm>SC_WIDTH+10) || (ich_ptrs->xm<0-10) \
      || (ich_ptrs->ym>SC_HEIGHT+10) || (ich_ptrs->ym<0-10)) {
        kette_inactivate_memb(ktt_ishs,iktte[ikt_mom]);
        continue;
      }
    }

    /* +++ move enemies, release shots +++ */
    fkt_max=kette_members(ktt_ffzg,fktte);  /* get all active enemies into fktte */
    for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
      du_ptrf=du_fzg[fktte[fkt_mom]];
      if (du_ptrf->bewg_pos<du_ptrf->bewg_anz) {
        while (du_ptrf->bewg_runde>=du_ptrf->bewg[du_ptrf->bewg_pos].runden) {
          du_ptrf->bewg_runde=0;
          if (++du_ptrf->bewg_pos>=du_ptrf->bewg_anz) {break;}
        }
      }
      if (du_ptrf->bewg_pos<du_ptrf->bewg_anz) {
        if (du_ptrf->lebenspunkte>0) {
          du_ptrf->xm+=du_ptrf->bewg[du_ptrf->bewg_pos].x;
          du_ptrf->ym+=du_ptrf->bewg[du_ptrf->bewg_pos].y;
          if (abs((int)(du_ptrf->bewg[du_ptrf->bewg_pos].x*100.))>abs((int)(du_ptrf->bewg[du_ptrf->bewg_pos].y*100.))) {
            if (du_ptrf->bewg[du_ptrf->bewg_pos].x<0.) {du_ptrf->bildidx=1;} else {du_ptrf->bildidx=3;}
          } else {
            if (du_ptrf->bewg[du_ptrf->bewg_pos].y>=0.) {du_ptrf->bildidx=0;} else {du_ptrf->bildidx=2;}
          }
        }
        du_ptrf->ym+=(float)wpix_decr;
        du_ptrf->bewg_runde++;
      } else {kette_inactivate_memb(ktt_ffzg,fktte[fkt_mom]); continue;}
      /* turning of gun */
      f1x=du_ptrf->xm-(SPRITE_WIDTH(du_ptrf->def->bild[du_ptrf->bildidx])/2-du_ptrf->def->xgun[du_ptrf->bildidx]);
      f1y=du_ptrf->ym-(SPRITE_HEIGHT(du_ptrf->def->bild[du_ptrf->bildidx])/2-du_ptrf->def->ygun[du_ptrf->bildidx]);
      if ((ich_fzg.ym-f1y>-.001) && (ich_fzg.ym-f1y<.001)) {
        f1=PI/2.;
        if (ich_fzg.xm-f1x<-.001) {f1+=PI;}
      } else {
        f1=atan((ich_fzg.xm-f1x)/(ich_fzg.ym-f1y));
        if (ich_fzg.ym-f1y<-.001) {f1+=PI;}
      }
      if ((du_ptrf->gunidx=(int)((f1+PI/16.)/(PI/4.)))>=8) {du_ptrf->gunidx-=8;} else if (du_ptrf->gunidx<0) {du_ptrf->gunidx+=8;}
      /* release shots */
      if ((du_ptrf->lebenspunkte>0) && (mission_ende==0)) {
        float xt,yt;
        for (i1=0;i1<du_ptrf->def->schs_anz;i1++) {
          if (du_ptrf->def->schs[i1].xm[du_ptrf->bildidx]==-1) {  /* gun-shot */
            xt=du_ptrf->xm-SPRITE_WIDTH(du_ptrf->def->bild[du_ptrf->bildidx])/2+du_ptrf->def->xgun[du_ptrf->bildidx];
            yt=du_ptrf->ym-SPRITE_HEIGHT(du_ptrf->def->bild[du_ptrf->bildidx])/2+du_ptrf->def->ygun[du_ptrf->bildidx];
          } else {
            xt=du_ptrf->xm-SPRITE_WIDTH(du_ptrf->def->bild[du_ptrf->bildidx])/2+du_ptrf->def->schs[i1].xm[du_ptrf->bildidx];
            yt=du_ptrf->ym-SPRITE_HEIGHT(du_ptrf->def->bild[du_ptrf->bildidx])/2+du_ptrf->def->schs[i1].ym[du_ptrf->bildidx];
          }
          if ((xt<0.) || (xt>=(float)SC_WIDTH) || (yt<0.) || (yt>=(float)SC_HEIGHT)) {continue;}
          if ((du_ptrf->schs_max[i1]>0) && (du_ptrf->schs_warte[i1]==0) && (ZUFALL(du_ptrf->def->schs[i1].rand)==0)) {
            double db=0.;
            du_ptrf->schs_max[i1]--;
            du_ptrf->schs_warte[i1]=du_ptrf->def->schs[i1].warte;
            i2=kette_activate_memb(ktt_fshs,1);
            du_shs[i2].lebenspunkte=1;
            du_shs[i2].art=du_ptrf->def->schs[i1].art;
            du_shs[i2].expl_runde=du_shs[i2].art==1?expl_sum:expl_sum;
            du_shs[i2].wdz=0;
            du_shs[i2].xm=xt;
            du_shs[i2].ym=yt;
            if (du_ptrf->def->schs[i1].xm[du_ptrf->bildidx]==-1) {  /* gun-shot */
              if ((du_ptrf->gunidx>=1) && (du_ptrf->gunidx<=3)) {
                du_shs[i2].xm+=GRAFIK_WIDTH(du_ptrf->def->gungr[du_ptrf->gunidx])/2;
              } else if ((du_ptrf->gunidx>=5) && (du_ptrf->gunidx<=7)) {
                du_shs[i2].xm-=GRAFIK_WIDTH(du_ptrf->def->gungr[du_ptrf->gunidx])/2;
              }
              if ((du_ptrf->gunidx<=1) || (du_ptrf->gunidx>=7)) {
                du_shs[i2].ym+=GRAFIK_HEIGHT(du_ptrf->def->gungr[du_ptrf->gunidx])/2;
              } else if ((du_ptrf->gunidx>=3) && (du_ptrf->gunidx<=5)) {
                du_shs[i2].ym-=GRAFIK_HEIGHT(du_ptrf->def->gungr[du_ptrf->gunidx])/2;
              }
            }
            du_shs[i2].runden=0;
            du_shs[i2].wnkl=(float)du_ptrf->gunidx*PI/4.;
#if 0
            if (du_ptrf->def->luft) {du_shs[i2].wnkl=0.;}
#endif
            if (du_shs[i2].art==1) {db=((double)ZUFALL(78)-39.)/100.;}
            else if (du_shs[i2].art==2) {db=((double)ZUFALL(471)+78.)/100.;}
            du_shs[i2].xp=F_SHS_ADD(du_shs[i2].art)*sin(du_shs[i2].wnkl+db);
            du_shs[i2].yp=F_SHS_ADD(du_shs[i2].art)*cos(du_shs[i2].wnkl+db);
          }
          if (du_ptrf->schs_warte[i1]>0) {du_ptrf->schs_warte[i1]--;}
        }
      }
    }

    /* +++ move enemy shots +++ */
    fkt_max=kette_members(ktt_fshs,fktte);  /* get all active shots into fktte */
    for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
      du_ptrs=&du_shs[fktte[fkt_mom]];
      if (du_ptrs->runden>300) {du_ptrs->lebenspunkte=0;}
      if (((du_ptrs->lebenspunkte==0) && (du_ptrs->expl_runde==0)) || (mission_ende)) {
        kette_inactivate_memb(ktt_fshs,fktte[fkt_mom]);
        continue;
      }
      du_ptrs->xm+=du_ptrs->xp;
      du_ptrs->ym+=du_ptrs->yp+(float)wpix_decr;
      if (du_ptrs->art==3) {
        double x,y,v;
        winkel2xy(du_ptrs->wdz,&x,&y);
        x=-x*F_SHS_ADD(du_ptrs->art);
        y=y*F_SHS_ADD(du_ptrs->art);
        if ((v=du_ptrs->xp-x)>.08) {v=.08;} else if (v<-.08) {v=-.08;}
        du_ptrs->xp-=v;
        if ((v=du_ptrs->yp-y)>.08) {v=.08;} else if (v<-.08) {v=-.08;}
        du_ptrs->yp-=v;
      }
      du_ptrs->runden++;
      if ((du_ptrs->xm>SC_WIDTH+50) || (du_ptrs->xm<0-50) \
      || (du_ptrs->ym>SC_HEIGHT+50) || (du_ptrs->ym<0-50)) {
        kette_inactivate_memb(ktt_fshs,fktte[fkt_mom]);
        continue;
      }
    }

    /* +++ draw out +++ */
    if ((rumms) && (--rumms)) {CLEAR_BOX(NULL,RGB_BLACK); rummi=(rumms%4>=2?5:-5);} else {rummi=0;}
    for (i1=0;i1<fdefmax;i1++) {
      next_sprite(fdef[i1].bild[0],NULL,NULL);
      next_sprite(fdef[i1].bild[1],NULL,NULL);
      next_sprite(fdef[i1].bild[2],NULL,NULL);
      next_sprite(fdef[i1].bild[3],NULL,NULL);
      next_sprite(fdef[i1].bild[4],NULL,NULL);
    }
    next_sprite(expl_bild,NULL,NULL);
    next_sprite(tref_bild,NULL,NULL);
    next_sprite(rauch_bild,NULL,NULL);
    copy_grafik(NULL,rummi+0,0,gweg,0,wpix,0,SC_HEIGHT,RGB_FULL);
    /* enemies */
    fkt_max=kette_members(ktt_ffzg,fktte);  /* get all active enemies into fktte */
    for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
      du_ptrf=du_fzg[fktte[fkt_mom]];
      if (du_ptrf->lebenspunkte>0) {continue;}
      if (du_ptrf->def->luft) {continue;}
      if (du_ptrf->expl_pos>=du_ptrf->def->expl_anz) {  /* dead */
        gr_ptr=last_sprite(du_ptrf->def->bild[4],&i1,&i2);
        copy_grafik(NULL,rummi+(int)du_ptrf->xm-SPRITE_WIDTH(du_ptrf->def->bild[4])/2+i1,(int)du_ptrf->ym-SPRITE_HEIGHT(du_ptrf->def->bild[4])/2+i2,gr_ptr,0,0,0,0,RGB_TRANS);
      }
    }
    for (e_luft=0;e_luft<2;e_luft++) {
      for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
        du_ptrf=du_fzg[fktte[fkt_mom]];
        if (e_luft) {
          if (!du_ptrf->def->luft) {continue;}
        } else {
          if (du_ptrf->def->luft) {continue;}
        }
        if (du_ptrf->lebenspunkte>0) {
          gr_ptr=last_sprite(du_ptrf->def->bild[du_ptrf->bildidx],&i1,&i2);
          x1=(int)du_ptrf->xm-SPRITE_WIDTH(du_ptrf->def->bild[du_ptrf->bildidx])/2+i1;
          x2=(int)du_ptrf->ym-SPRITE_HEIGHT(du_ptrf->def->bild[du_ptrf->bildidx])/2+i2;
          if (e_luft) {
            i1+=(int)du_ptrf->xm+5;
            i2+=(int)du_ptrf->ym-2;
            copy_grafik(NULL,rummi+i1,i2,flugschatt[du_ptrf->bildidx],0,0,0,0,RGB_TRANS);
          }
          copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
          if (du_ptrf->def->gungr[du_ptrf->gunidx]) {
            copy_grafik(NULL,rummi+x1+du_ptrf->def->xgun[du_ptrf->bildidx]-GRAFIK_WIDTH(du_ptrf->def->gungr[du_ptrf->gunidx])/2,x2+du_ptrf->def->ygun[du_ptrf->bildidx]-GRAFIK_HEIGHT(du_ptrf->def->gungr[du_ptrf->gunidx])/2,du_ptrf->def->gungr[du_ptrf->gunidx],0,0,0,0,RGB_TRANS);
          }
          if (du_ptrf->expl_pos==-1) {
            if (du_ptrf->def->expl_anz>0) {
              gr_ptr=last_sprite(tref_bild,&i1,&i2);
              copy_grafik(NULL,rummi+x1+du_ptrf->def->expl[0].xm[du_ptrf->bildidx]-SPRITE_WIDTH(tref_bild)/2+i1,x2+du_ptrf->def->expl[0].ym[du_ptrf->bildidx]-SPRITE_HEIGHT(tref_bild)/2+i2,gr_ptr,0,0,0,0,RGB_TRANS);
              if (--du_ptrf->expl_runde<=0) {du_ptrf->expl_pos=0;}
            } else {du_ptrf->expl_pos=0;}
          }
          if (du_ptrf->lebenspunkte<du_ptrf->def->rauch) {
            if (du_ptrf->def->expl_anz>0) {
              gr_ptr=last_sprite(rauch_bild,&i1,&i2);
              copy_grafik(NULL,rummi+x1+du_ptrf->def->expl[0].xm[du_ptrf->bildidx]-SPRITE_WIDTH(rauch_bild)/2+i1,x2+du_ptrf->def->expl[0].ym[du_ptrf->bildidx]-SPRITE_HEIGHT(rauch_bild)/2+i2,gr_ptr,0,0,0,0,RGB_TRANS);
            }
          }
        } else {  /* destroyed */
          if (du_ptrf->expl_pos<du_ptrf->def->expl_anz) {  /* exploding */
            gr_ptr=last_sprite(du_ptrf->def->bild[du_ptrf->bildidx],&i1,&i2);
            x1=(int)du_ptrf->xm-SPRITE_WIDTH(du_ptrf->def->bild[du_ptrf->bildidx])/2+i1;
            x2=(int)du_ptrf->ym-SPRITE_HEIGHT(du_ptrf->def->bild[du_ptrf->bildidx])/2+i2;
            copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
            if (du_ptrf->def->gungr[du_ptrf->gunidx]) {
              copy_grafik(NULL,rummi+x1+du_ptrf->def->xgun[du_ptrf->bildidx]-GRAFIK_WIDTH(du_ptrf->def->gungr[du_ptrf->gunidx])/2,x2+du_ptrf->def->ygun[du_ptrf->bildidx]-GRAFIK_HEIGHT(du_ptrf->def->gungr[du_ptrf->gunidx])/2,du_ptrf->def->gungr[du_ptrf->gunidx],0,0,0,0,RGB_TRANS);
            }
            gr_ptr=last_sprite(expl_bild,&i1,&i2);
            x1+=du_ptrf->def->expl[du_ptrf->expl_pos].xm[du_ptrf->bildidx]-SPRITE_WIDTH(expl_bild)/2+i1;
            x2+=du_ptrf->def->expl[du_ptrf->expl_pos].ym[du_ptrf->bildidx]-SPRITE_HEIGHT(expl_bild)/2+i2;
            copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
            if (--du_ptrf->expl_runde<=0) {
              du_ptrf->expl_pos++;
              du_ptrf->expl_runde=expl_sum;
            }
          }
        }
      }
    }
    /* 3plane */
    if (ich_fzg.lebenspunkte>0) {
      gr_ptr=next_sprite(ich_fzg.bild[0],&i1,&i2);
      x1=(int)ich_fzg.xm-SPRITE_WIDTH(ich_fzg.bild[0])/2+i1;
      x2=(int)ich_fzg.ym-SPRITE_HEIGHT(ich_fzg.bild[0])/2+i2;
      i1+=(int)ich_fzg.xm+5;
      i2+=(int)ich_fzg.ym-2;
      copy_grafik(NULL,rummi+i1,i2,flugschatt[2],0,0,0,0,RGB_TRANS);
      copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
      if (ich_fzg.expl_pos==-1) {
        if (ich_fzg.expl_anz>0) {
          gr_ptr=last_sprite(tref_bild,&i1,&i2);
          copy_grafik(NULL,rummi+x1+ich_fzg.expl[0].xm-SPRITE_WIDTH(tref_bild)/2+i1,x2+ich_fzg.expl[0].ym-SPRITE_HEIGHT(tref_bild)/2+i2,gr_ptr,0,0,0,0,RGB_TRANS);
          if (--ich_fzg.expl_runde<=0) {ich_fzg.expl_pos=0;}
        } else {ich_fzg.expl_pos=0;}
      }
      if (ich_fzg.lebenspunkte<ich_fzg.rauch) {
        if (ich_fzg.expl_anz>0) {
          gr_ptr=last_sprite(rauch_bild,&i1,&i2);
          copy_grafik(NULL,rummi+x1+ich_fzg.expl[0].xm-SPRITE_WIDTH(rauch_bild)/2+i1,x2+ich_fzg.expl[0].ym-SPRITE_HEIGHT(rauch_bild)/2+i2,gr_ptr,0,0,0,0,RGB_TRANS);
        }
      }
    } else {  /* destroyed */
      if (ich_fzg.expl_pos>=ich_fzg.expl_anz) {  /* dead */
        r_status=-1;  /* game over */
        break;
      } else {  /* exploding */
        gr_ptr=last_sprite(ich_fzg.bild[0],&i1,&i2);
        x1=(int)ich_fzg.xm-SPRITE_WIDTH(ich_fzg.bild[0])/2+i1;
        x2=(int)ich_fzg.ym-SPRITE_HEIGHT(ich_fzg.bild[0])/2+i2;
        copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
        gr_ptr=last_sprite(expl_bild,&i1,&i2);
        x1+=ich_fzg.expl[ich_fzg.expl_pos].xm-SPRITE_WIDTH(expl_bild)/2+i1;
        x2+=ich_fzg.expl[ich_fzg.expl_pos].ym-SPRITE_HEIGHT(expl_bild)/2+i2;
        copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
        if (--ich_fzg.expl_runde<=0) {
          ich_fzg.expl_pos++;
          ich_fzg.expl_runde=expl_sum;
        }
      }
    }
    /* enemy shots */
    memset(shs_gr,0,sizeof(shs_gr));
    fkt_max=kette_members(ktt_fshs,fktte);  /* get all active shots into fktte */
    for (fkt_mom=0;fkt_mom<fkt_max;fkt_mom++) {  /* active indices */
      du_ptrs=&du_shs[fktte[fkt_mom]];
      if (shs_gr[du_ptrs->art]==NULL) {
        shs_gr[du_ptrs->art]=next_sprite(shs_bild[du_ptrs->art],&i1,&i2);
      } else {
        shs_gr[du_ptrs->art]=last_sprite(shs_bild[du_ptrs->art],&i1,&i2);
      }
      x1=(int)du_ptrs->xm-SPRITE_WIDTH(shs_bild[du_ptrs->art])/2+i1;
      x2=(int)du_ptrs->ym-SPRITE_HEIGHT(shs_bild[du_ptrs->art])/2+i2;
      if (du_ptrs->art==3) {
        static grafik * rotgr=NULL;
        static int a1,a2,a3,a4;
        if (rotgr==NULL) {rotgr=create_grafik(50,50);}
        a1=a2=a3=a4=0;
        du_ptrs->wdz=xy2winkel(du_ptrs->xm-ich_fzg.xm,du_ptrs->ym-ich_fzg.ym);
        rotate_grafik(rotgr,shs_gr[du_ptrs->art],du_ptrs->wdz,&a1,&a2,&a3,&a4);
        copy_grafik(NULL,rummi+x1+a1,x2+a2,rotgr,0,0,a3,a4,RGB_TRANS);
      } else {copy_grafik(NULL,rummi+x1,x2,shs_gr[du_ptrs->art],0,0,0,0,RGB_TRANS);}
      if (du_ptrs->lebenspunkte==0) {  /* shots exploding */
        gr_ptr=last_sprite(expl_bild,&i1,&i2);
        x1+=SPRITE_WIDTH(shs_bild[du_ptrs->art])/2-SPRITE_WIDTH(expl_bild)/2+i1;
        x2+=SPRITE_HEIGHT(shs_bild[du_ptrs->art])/2-SPRITE_HEIGHT(expl_bild)/2+i2;
        copy_grafik(NULL,rummi+x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
        du_ptrs->expl_runde--;
      }
    }
    /* 3planes shots */
    shs_gr[0]=next_sprite(shs_bild[0],&i1,&i2);
    ikt_max=kette_members(ktt_ishs,iktte);  /* get all own shots into iktte */
    for (ikt_mom=0;ikt_mom<ikt_max;ikt_mom++) {  /* active indices */
      ich_ptrs=&ich_shs[iktte[ikt_mom]];
      x1=(int)ich_ptrs->xm-SPRITE_WIDTH(shs_bild[0])/2+i1;
      x2=(int)ich_ptrs->ym-SPRITE_HEIGHT(shs_bild[0])/2+i2;
      copy_grafik(NULL,rummi+x1,x2,shs_gr[0],0,0,0,0,RGB_TRANS);
    }
    /* other */
    if (ich_fzg.lebenspunkte>MAX_I_LEPU*2/3) {
      i1=color_index(CL_GREEN,100);
    } else if (ich_fzg.lebenspunkte>MAX_I_LEPU/3) {
      i1=color_index(CL_YELLOW,100);
    } else {i1=color_index(CL_RED,100);}
    i2=ich_fzg.lebenspunkte*100/MAX_I_LEPU;
    draw_fillbox(gesbalk,0,0,102,5,i1);
    if (i2<100) {draw_fillbox(gesbalk,1+i2,1,100-i2,3,RGB_BLACK);}
    if (ich_fzg.lebenspunkte<=MAX_I_LEPU/4) {
      if (troet==0) {
        if (ich_fzg.lebenspunkte>0) {play_wave(wav_nr[WAVE_GEFAHR],wav_troet,1,0); troet=1;}
      } else if (ich_fzg.lebenspunkte<=0) {stop_wave(wav_troet,0); troet=0;}
      if ((gesund%10>4) || (ich_fzg.lebenspunkte<=0)) {i1=1;} else {i1=0;}
    } else {
      if (troet) {stop_wave(wav_troet,0); troet=0;}
      i1=1;
    }
    if (i1) {copy_grafik(NULL,rummi+109,3,gesbalk,0,0,0,0,RGB_TRANS);}

    draw_line(NULL,rummi+240,3,rummi+240,7,color_index(CL_RED,100));
    sprintf(val,"%d",mun_schuss<0?0:mun_schuss);
    draw_text(NULL,RGB_WHITE,rummi+245,1,val,strlen(val),RGB_TRANS);
    copy_grafik(NULL,rummi+280,3,grmag,0,0,0,0,RGB_TRANS);
    sprintf(val,"%d",mun_magazin);
    draw_text(NULL,RGB_WHITE,rummi+292,1,val,strlen(val),RGB_TRANS);

    /* +++ text +++ */
    if ((ich_fzg.lebenspunkte>0) && (--zeigetext>0) && (zeigetext%20>=8)) {
      x1=(SC_WIDTH-GRAFIK_WIDTH(alle_fzg.text[scmom-1]))/2;
      x2=(SC_HEIGHT-GRAFIK_HEIGHT(alle_fzg.text[scmom-1]))/2;
      copy_grafik(NULL,rummi+x1,x2,alle_fzg.text[scmom-1],0,0,0,0,RGB_TRANS);
    }

    /* +++ rest +++ */
    flush_window();
    wait_time(50);
    if (wow) {ich_fzg.lebenspunkte=MAX_I_LEPU;}
  } /* end while */

  if ((r_status>=0) && (ich_fzg.lebenspunkte>0)) {
    int i0;
    for (i0=(int)ich_fzg.ym;i0>=-SPRITE_HEIGHT(ich_fzg.bild[0])/2;i0--) {
      copy_grafik(NULL,0,0,gweg,0,0,0,SC_HEIGHT,RGB_FULL);
      ich_fzg.ym=(float)i0;
      gr_ptr=next_sprite(ich_fzg.bild[0],&i1,&i2);
      x1=(int)ich_fzg.xm-SPRITE_WIDTH(ich_fzg.bild[0])/2+i1;
      x2=(int)ich_fzg.ym-SPRITE_HEIGHT(ich_fzg.bild[0])/2+i2;
      i1+=(int)ich_fzg.xm+5;
      i2+=(int)ich_fzg.ym-2;
      copy_grafik(NULL,i1,i2,flugschatt[2],0,0,0,0,RGB_TRANS);
      copy_grafik(NULL,x1,x2,gr_ptr,0,0,0,0,RGB_TRANS);
      flush_window();
      wait_time(20);
    }
  }
  load_colormap(RGB256);
  brightness(0);

  stop_wave(CN_ALL,0);
  CLEAR_BOX(NULL,RGB_BLACK);
  flush_window();

  *lepu=ich_fzg.lebenspunkte;  /* return lebenspunkte */
  init_ich(&ich_fzg,ich_shs,-1);
  entlade_weg(&alle_fzg);
  free_grafik(grmag);
  free_grafik(gesbalk);
  free_grafik(gweg);
  kette_destroy(ktt_ffzg);
  kette_destroy(ktt_fshs);
  kette_destroy(ktt_ishs);
  if (r_status>=0) {
    if ((r_status>=trfz_min) && (trfz_2==0)) {r_status=1;} else {r_status=0;}
  }
  *runde=r_status;  /* return status */
  return(NULL);
} /* Ende game */


static grafik * lade_weg(int runde,struct neue_fzg * alle_fzg) {
/* load way of actual mission.
** path: <install_path>/mission/way/way.<missionnumber>
** file contents global (one time):
**   $W01=<how many trfz=1 needed for success>
** file contents for each screen:
**   $W10                                      (=next screen, 1.=first)
**   $W11=<color index of background>
**   $W12=<0=color or 1=grey>,<brightness -63 to 62>
**   (repeated $W20-$W21)
**     $W20=<filename of foreground graphic>   (under "mission/graphics")
**     $W21=<x-pos>,<y-pos>,<"f"|"t">
**   (repeated $W30-$W33)
**     $W30=<definition filename of enemy>     (under "mission/enemies")
**     $W31=<trfz>
**     $W32=<xm start>,<ym start>
**     (repeated $W33)
**       $W33=<x moving>,<y moving>,<runden>
**   $W40=<text color>
**   $W41-$W49=<text language-number 1-9>
**
**   $WI <filename> <para1> <para2> ... <para9>  (include file)
*/
  const int schuss_pro_screen=30;
  FILE * ffp[9];
  char pfad[1024],buf[1024],* bufptr,* p1;
  grafik * gr_weg;
  int scmax,scmom,i1,fdx,ipar[9][9],bgvor,tefa=RGB_WHITE;

#define NEUE_UNTERDATEI \
  {char * px; \
   int ii; \
   if (++fdx>=9) {strcpy(errmsg,"too many includes ($WI)"); return(NULL);} \
   if ((px=strpbrk(bufptr+4," \t"))!=NULL) {*px='\0';} \
   snprintf(pfad,sizeof(pfad),"%s/mission/way/%s",install_path,bufptr+4); \
   if ((ffp[fdx]=fopen(pfad,"r"))==NULL) { \
     snprintf(errmsg,sizeof(errmsg),"\"%s\" not found",pfad); \
     return(NULL); \
   } \
   for (ii=0;ii<9;ii++) {ipar[fdx][ii]=0;} \
   for (ii=0;px!=NULL;px=strpbrk(px," \t")) { \
     for (px++;(*px==' '||*px=='\t');px++) {;} \
     ipar[fdx][ii]=atoi(px); \
     if (++ii>=9) {break;} \
   } \
  }

  fdx=0;
  for (i1=0;i1<9;i1++) {ipar[fdx][i1]=0;}
  /* open way graphic and count+allocate enemies */
  snprintf(pfad,sizeof(pfad),"%s/mission/way/way.%d",install_path,runde);
  if ((ffp[fdx]=fopen(pfad,"r"))==NULL) {
    snprintf(errmsg,sizeof(errmsg),"\"%s\" not found",pfad);
    return(NULL);
  }
  mun_schuss=mun_magazin=0;
  scmax=0;
  alle_fzg->fndmax=alle_fzg->fndmom=0;
_ldw1:
  while (fgets(buf,sizeof(buf),ffp[fdx])!=NULL) {
    if ((p1=strchr(buf,'#'))!=NULL) {*p1='\0';}
    bufptr=buf+strspn(buf," \t\v");
    if (strncmp(bufptr,"$W30=",5)==0) {
      alle_fzg->fndmax++;
    } else if (strncmp(bufptr,"$WI=",4)==0) {
      for (i1=strlen(bufptr)-1;i1>=0;i1--) {
        if ((unsigned char)bufptr[i1]>' ') {break;}
      }
      bufptr[i1+1]='\0';
      NEUE_UNTERDATEI;
    } else if (strncmp(bufptr,"$W10",4)==0) {scmax++;}
  }
  if (fdx>0) {fclose(ffp[fdx]); fdx--; goto _ldw1;}
  rewind(ffp[fdx]);
  mun_schuss=MUNSCHUESSE;
  mun_magazin=(scmax-1)*schuss_pro_screen/mun_schuss;
  if (alle_fzg->fndmax>0) {
    if (((alle_fzg->du_fzg=calloc(alle_fzg->fndmax,sizeof(struct f_fzg)))==NULL) \
    || ((alle_fzg->bld=malloc(sizeof(int)*alle_fzg->fndmax))==NULL)) {
      strcpy(errmsg,"allocation error of way graphic");
      return(NULL);
    }
  } else {alle_fzg->du_fzg=NULL; alle_fzg->bld=NULL;}
  if ((gr_weg=create_grafik(SC_WIDTH,scmax*SC_HEIGHT))==NULL) {return(NULL);}
  alle_fzg->textmax=scmax;
  if ((alle_fzg->text=calloc(alle_fzg->textmax,sizeof(grafik *)))==NULL) {
    strcpy(errmsg,"allocation error of way graphic");
    return(NULL);
  }
  alle_fzg->rgbmax=scmax;
  if ((alle_fzg->rgb1=calloc(alle_fzg->rgbmax,sizeof(int)))==NULL) {
    strcpy(errmsg,"allocation error of way graphic");
    return(NULL);
  }
  if ((alle_fzg->rgb2=calloc(alle_fzg->rgbmax,sizeof(int)))==NULL) {
    strcpy(errmsg,"allocation error of way graphic");
    return(NULL);
  }

  /* read $W00 to $W09 */
  trfz_min=trfz_2=0;
  while (fgets(buf,sizeof(buf),ffp[fdx])!=NULL) {
    if ((p1=strchr(buf,'#'))!=NULL) {*p1='\0';}
    bufptr=buf+strspn(buf," \t\v");
    if (strncmp(bufptr,"$W01=",5)==0) {
      trfz_min=atoi(bufptr+5);
    } else if ((strncmp(bufptr,"$W10",4)==0) || (strncmp(bufptr,"$WI=",4)==0)) {break;}
  }
  rewind(ffp[fdx]);

  /* draw for each screen way graphic and set enemies */
  scmom=0;
  bgvor=0;
_ldw2:
  while (fgets(buf,sizeof(buf),ffp[fdx])!=NULL) {
    if ((p1=strchr(buf,'#'))!=NULL) {*p1='\0';}
    bufptr=buf+strspn(buf," \t\v");
    if (strncmp(bufptr,"$W10",4)==0) {
      char tb[128];
      scmom++;
      sprintf(tb,"Mission %d%% ...",scmom*100/scmax);
      set_font(font10x17,10,17);
      draw_text(NULL,color_index(CL_YELLOW,100),110,92,tb,strlen(tb),RGB_FULL);
      set_font(NULL,0,0);
      flush_window();
      tefa=RGB_WHITE;
    }
    for (i1=strlen(bufptr)-1;i1>=0;i1--) {
      if ((unsigned char)bufptr[i1]>' ') {break;}
    }
    bufptr[i1+1]='\0';
    if (scmom==0) {
      if (strncmp(bufptr,"$WI=",4)==0) {
        NEUE_UNTERDATEI;
      }
      continue;
    }

    if (strncmp(bufptr,"$W11=",5)==0) {  /* background color index */
      i1=rechnei(bufptr+5,ipar[fdx]);
      if (i1!=bgvor) {
        bgvor=i1;
        draw_fillbox(gr_weg,0,(scmax-scmom)*SC_HEIGHT,SC_WIDTH,SC_HEIGHT,bgvor);
      }
      draw_fillbox(gr_weg,0,(scmax-scmom-1)*SC_HEIGHT,SC_WIDTH,SC_HEIGHT,bgvor);
    } else if (strncmp(bufptr,"$W12=",5)==0) {  /* colormap+brightness */
      if ((p1=strchr(bufptr+5,','))==NULL) {continue;}
      if ((alle_fzg->rgb1[scmom-1]=atoi(bufptr+5))!=1) {alle_fzg->rgb1[scmom-1]=0;}
      alle_fzg->rgb2[scmom-1]=atoi(p1+1);
    } else if (strncmp(bufptr,"$W2",3)==0) {  /* foreground graphic */
      static struct {
        grafik ** grf;
        char ** nam;
        int mom,max;
      } fgc={NULL,NULL,0,0};
      if (fgc.grf==NULL) {
        fgc.grf=malloc(sizeof(grafik *));
        fgc.nam=malloc(sizeof(char *));
      }
      if (strncmp(bufptr,"$W20=",5)==0) {  /* filename foreground gr. */
        for (fgc.mom=1;fgc.mom<=fgc.max;fgc.mom++) {
          if (strcmp(bufptr+5,fgc.nam[fgc.mom-1])==0) {break;}
        }
        if (fgc.mom>fgc.max) {
          fgc.max++;
          if (((fgc.grf=realloc(fgc.grf,sizeof(grafik *)*fgc.max))==NULL) \
          || ((fgc.nam=realloc(fgc.nam,sizeof(char *)*fgc.max))==NULL) \
          || ((fgc.nam[fgc.mom-1]=strdup(bufptr+5))==NULL)) {
            strcpy(errmsg,"allocation error of struct");
            return(NULL);
          }
          snprintf(pfad,sizeof(pfad),"%s/mission/graphics/%s",install_path,bufptr+5);
          if ((fgc.grf[fgc.mom-1]=load_grafik(pfad))==NULL) {return(NULL);}
        }
      } else if ((fgc.mom>0) && (strncmp(bufptr,"$W21=",5)==0)) {  /* x,y,<"f"|"t"> */
        int x,y;
        x=rechnei(bufptr+5,ipar[fdx]);
        if ((p1=strchr(bufptr+5,','))==NULL) {continue;}
        y=rechnei(p1+1,ipar[fdx]);
        if ((p1=strchr(p1+1,','))==NULL) {continue;}
        p1++;
        copy_grafik(gr_weg,x,(scmax-scmom)*SC_HEIGHT+y,fgc.grf[fgc.mom-1],0,0,0,0,*p1=='f'?RGB_FULL:RGB_TRANS);
      }
    } else if (strncmp(bufptr,"$W3",3)==0) {  /* enemies */
      struct f_fzg * fptr;
      if (strncmp(bufptr,"$W30=",5)==0) {  /* enemy definition filename */
        int fdefmom;
        struct f_def * fdefptr;
        for (fdefmom=0,fdefptr=fdef;fdefmom<fdefmax;fdefmom++,fdefptr++) {
          if (strcmp(fdefptr->defname,bufptr+5)==0) {break;}
        }
        if (fdefmom==fdefmax) {snprintf(errmsg,sizeof(errmsg),"cannot find \"%s\" ($W30)",bufptr+5); return(NULL);}
        alle_fzg->fndmom++;
        fptr=&alle_fzg->du_fzg[alle_fzg->fndmom-1];
        fptr->def=fdefptr;
        fptr->lebenspunkte=fdefptr->c_lebenspunkte;
        if ((fptr->schs_max=malloc(sizeof(int)*fdefptr->schs_anz))==NULL) {strcpy(errmsg,"allocation error ($W30)"); return(NULL);}
        if ((fptr->schs_warte=malloc(sizeof(int)*fdefptr->schs_anz))==NULL) {strcpy(errmsg,"allocation error ($W30)"); return(NULL);}
        for (i1=0;i1<fdefptr->schs_anz;i1++) {
          fptr->schs_max[i1]=fdefptr->schs[i1].c_max;
          fptr->schs_warte[i1]=0;
        }
        fptr->bewg_runde=0;
        fptr->bewg_pos=0;
        fptr->bewg_anz=0;
        fptr->expl_runde=0;
        fptr->expl_pos=0;
        fptr->bildidx=0;
        alle_fzg->bld[alle_fzg->fndmom-1]=scmom;
      } else if (strncmp(bufptr,"$W31=",5)==0) {  /* trfz */
        fptr=&alle_fzg->du_fzg[alle_fzg->fndmom-1];
        fptr->trfz=rechnei(bufptr+5,ipar[fdx]);
        if (fptr->trfz<1) {fptr->trfz=0;}
        else if (fptr->trfz>2) {fptr->trfz=1;}
        else if (fptr->trfz==2) {trfz_2=1;}
      } else if (strncmp(bufptr,"$W32=",5)==0) {  /* xm/ym start */
        fptr=&alle_fzg->du_fzg[alle_fzg->fndmom-1];
        fptr->xm=(float)rechnei(bufptr+5,ipar[fdx]);
        if ((p1=strchr(bufptr+5,','))!=NULL) {
          fptr->ym=(float)rechnei(p1+1,ipar[fdx])-(float)200;
        } else {fptr->ym=0.;}
      } else if (strncmp(bufptr,"$W33=",5)==0) {  /* x/y moving, runden */
        fptr=&alle_fzg->du_fzg[alle_fzg->fndmom-1];
        if (fptr->bewg_anz++==0) {
          fptr->bewg=malloc(sizeof(*fptr->bewg)*fptr->bewg_anz);
        } else {
          fptr->bewg=realloc(fptr->bewg,sizeof(*fptr->bewg)*fptr->bewg_anz);
        }
        if (fptr->bewg==NULL) {strcpy(errmsg,"allocation error ($W33)"); return(NULL);}
        fptr->bewg[fptr->bewg_anz-1].x=atof(bufptr+5);
        if ((p1=strchr(bufptr+5,','))!=NULL) {
          fptr->bewg[fptr->bewg_anz-1].y=atof(p1+1);
          if ((p1=strchr(p1+1,','))!=NULL) {
            fptr->bewg[fptr->bewg_anz-1].runden=rechnei(p1+1,ipar[fdx]);
          } else {fptr->bewg[fptr->bewg_anz-1].runden=0;}
        } else {fptr->bewg[fptr->bewg_anz-1].y=0.; fptr->bewg[fptr->bewg_anz-1].runden=0;}
      }
    } else if (strncmp(bufptr,"$W40=",5)==0) {
      tefa=atoi(bufptr+5);
    } else if ((strncmp(bufptr,"$W4",3)==0) && (bufptr[3]==lang_nr+'0') && (bufptr[4]=='=')) {  /* text */
      if (*(bufptr+5)!='\0') {
        alle_fzg->text[scmom-1]=text_to_grafik(tefa,RGB_BLACK,2,1,bufptr+5);
      }
    } else if (strncmp(bufptr,"$WI=",4)==0) {
      NEUE_UNTERDATEI;
    }
  }
  if (fdx>0) {fclose(ffp[fdx]); fdx--; goto _ldw2;}
  fclose(ffp[fdx]);
  alle_fzg->fndmom=0;
  return(gr_weg);
} /* Ende lade_weg */


static char * init_ich(struct i_fzg * ich_fzg,struct i_shs * ich_shs,int lepu) {
/* initialize 3plane. lepu: -1: destroy, >=0: init */
  int i1,i2,i3;
  char buf[1024];
  if (lepu<0) {
    free_sprite(ich_fzg->bild[0]);
    free(ich_fzg->expl);
  } else {
    memset(ich_fzg,0,sizeof(*ich_fzg));
    if (lepu==0) {lepu=MAX_I_LEPU;}
    ich_fzg->lebenspunkte=lepu>MAX_I_LEPU?MAX_I_LEPU:lepu;
    ich_fzg->minus_feind=10;
    ich_fzg->minus_shs[0]=2;
    ich_fzg->minus_shs[1]=5;
    ich_fzg->minus_shs[2]=8;
    ich_fzg->rauch=MAX_I_LEPU/3;
    snprintf(buf,sizeof(buf),"%s/sprites/i_air.sprite",install_path);
    if ((ich_fzg->bild[0]=load_sprite(buf))==NULL) {return("game.c");}
    ich_fzg->xm=(float)(SC_WIDTH/2);
    ich_fzg->ym=(float)(SC_HEIGHT-30);
    ich_fzg->expl_runde=ich_fzg->expl_pos=0;
    i1=SPRITE_WIDTH(ich_fzg->bild[0]); i2=SPRITE_HEIGHT(ich_fzg->bild[0]);
    ich_fzg->expl_anz=3*5;
    if ((ich_fzg->expl=malloc(sizeof(*ich_fzg->expl)*ich_fzg->expl_anz))==NULL) {return("game.c: allocation error");}
    for (i3=0;i3<3;i3++) {
      ich_fzg->expl[0+i3*5].xm=i1/2; ich_fzg->expl[0+i3*5].ym=i2/2;
      ich_fzg->expl[1+i3*5].xm=i1*2/3; ich_fzg->expl[1+i3*5].ym=i2/3;
      ich_fzg->expl[2+i3*5].xm=i1/3; ich_fzg->expl[2+i3*5].ym=i2/3;
      ich_fzg->expl[3+i3*5].xm=i1/2; ich_fzg->expl[3+i3*5].ym=i2/4;
      ich_fzg->expl[4+i3*5].xm=i1/2; ich_fzg->expl[4+i3*5].ym=i2*3/4;
    }
    for (i1=0;i1<MAX_IKETTE;i1++) {
      memset(&ich_shs[i1],0,sizeof(ich_shs[i1]));
      ich_shs[i1].xp=0.;
      ich_shs[i1].yp=-3.;
    }
  }
  return(NULL);
} /* Ende init_ich */


static void entlade_weg(struct neue_fzg * alle_fzg) {
  int i1;
  struct f_fzg * fptr;
  for (alle_fzg->fndmom=1;alle_fzg->fndmom<=alle_fzg->fndmax;alle_fzg->fndmom++) {
    fptr=&alle_fzg->du_fzg[alle_fzg->fndmom-1];
    free(fptr->bewg);
    free(fptr->schs_max);
    free(fptr->schs_warte);
  }
  free(alle_fzg->du_fzg);
  free(alle_fzg->bld);
  for (i1=0;i1<alle_fzg->textmax;i1++) {
    if (alle_fzg->text[i1]!=NULL) {free_grafik(alle_fzg->text[i1]);}
  }
  free(alle_fzg->text);
  free(alle_fzg->rgb1);
  free(alle_fzg->rgb2);
} /* Ende entlade_weg */


static int ob_treffer(void * meins,void * deins,int nr) {
/* 1.Arg: ich_fzg or ich_shs[]
** 2.Arg: du_fzg or du_shs[]
** 3.Arg: 1=ich_fzg+du_fzg[]
**        2=ich_fzg+du_shs[]
**        3=ich_shs[]+du_fzg[]
**        4=ich_shs[]+du_shs[]
** return value: when hit:
**                 1.Arg=ich_fzg: number to decrement lebenspunkte
**                          else: 1
**               or: 0=no hit
*/
  int a1x,a1y,a2x,a2y,ruck;
  struct i_fzg * ifzg;
  struct i_shs * ishs;
  struct f_fzg * ffzg;
  struct f_shs * fshs;
  ruck=0;
  if (nr==1) {
    ifzg=(struct i_fzg *)meins;
    ffzg=(struct f_fzg *)deins;
    if ((a1x=SPRITE_WIDTH(ifzg->bild[0])/2-5)<0) {a1x=0;}
    if ((a1y=SPRITE_HEIGHT(ifzg->bild[0])/2-5)<0) {a1y=0;}
    if ((a2x=SPRITE_WIDTH(ffzg->def->bild[ffzg->bildidx])/2-5)<0) {a2x=0;}
    if ((a2y=SPRITE_HEIGHT(ffzg->def->bild[ffzg->bildidx])/2-5)<0) {a2y=0;}
    if ((ifzg->xm>ffzg->xm-a2x-a1x) && (ifzg->xm<ffzg->xm+a2x+a1x) \
    && (ifzg->ym>ffzg->ym-a2y-a1y) && (ifzg->ym<ffzg->ym+a2y+a1y)) {
      ruck=ifzg->minus_feind;
    }
  } else if (nr==2) {
    ifzg=(struct i_fzg *)meins;
    fshs=(struct f_shs *)deins;
    if ((a1x=SPRITE_WIDTH(ifzg->bild[0])/2-3)<0) {a1x=0;}
    if ((a1y=SPRITE_HEIGHT(ifzg->bild[0])/2-3)<0) {a1y=0;}
    if ((a2x=SPRITE_WIDTH(shs_bild[fshs->art])/2-1)<0) {a2x=0;}
    if ((a2y=SPRITE_HEIGHT(shs_bild[fshs->art])/2-1)<0) {a2y=0;}
    if ((ifzg->xm>fshs->xm-a2x-a1x) && (ifzg->xm<fshs->xm+a2x+a1x) \
    && (ifzg->ym>fshs->ym-a2y-a1y) && (ifzg->ym<fshs->ym+a2y+a1y)) {
      ruck=ifzg->minus_shs[fshs->art-1];
    }
  } else if (nr==3) {
    ishs=(struct i_shs *)meins;
    ffzg=(struct f_fzg *)deins;
    if ((a1x=SPRITE_WIDTH(shs_bild[0])/2-1)<0) {a1x=0;}
    if ((a1y=SPRITE_HEIGHT(shs_bild[0])/2-1)<0) {a1y=0;}
    if ((a2x=SPRITE_WIDTH(ffzg->def->bild[ffzg->bildidx])/2-1)<0) {a2x=0;}
    if ((a2y=SPRITE_HEIGHT(ffzg->def->bild[ffzg->bildidx])/2-1)<0) {a2y=0;}
    if ((ishs->xm>ffzg->xm-a2x-a1x) && (ishs->xm<ffzg->xm+a2x+a1x) \
    && (ishs->ym>ffzg->ym-a2y-a1y) && (ishs->ym<ffzg->ym+a2y+a1y)) {
      ruck=1;
    }
  } else if (nr==4) {
    ishs=(struct i_shs *)meins;
    fshs=(struct f_shs *)deins;
    if ((a1x=SPRITE_WIDTH(shs_bild[0])/2-1)<0) {a1x=0;}
    if ((a1y=SPRITE_HEIGHT(shs_bild[0])/2-1)<0) {a1y=0;}
    if ((a2x=SPRITE_WIDTH(shs_bild[fshs->art])/2-1)<0) {a2x=0;}
    if ((a2y=SPRITE_HEIGHT(shs_bild[fshs->art])/2-1)<0) {a2y=0;}
    if (a2x>a2y) {a2y=a2x;} else {a2x=a2y;}
    if ((ishs->xm>fshs->xm-a2x-a1x) && (ishs->xm<fshs->xm+a2x+a1x) \
    && (ishs->ym>fshs->ym-a2y-a1y) && (ishs->ym<fshs->ym+a2y+a1y)) {
      ruck=1;
    }
  }
  return(ruck);
} /* Ende ob_treffer */


static int xy2winkel(double x,double y) {
/* returns angle of x,y in degrees */
  double wdz=0;
  y=-y;
  if (x<0) {y=-y; x=-x; wdz=PI;}
  wdz+=acos(y/sqrt(y*y+x*x));
  if (wdz>=PI2) {wdz-=PI2;}
  return((int)(wdz*360./PI2));
} /* Ende xy2winkel */


static void winkel2xy(int wdz,double * x,double * y) {
/* gives x,y based on radius 1 of angle wdz in degrees */
  wdz%=360;
  *x=sin((double)wdz*PI2/360.);
  *y=cos((double)wdz*PI2/360.);
} /* Ende winkel2xy */


int rechnei(const char * ptr,int ipar[]) {
  int zahl=0,zl=0,zlv=1,plmi=1,doll=0,i1,i2,i3,i4;
  for (;;ptr++) {
    if ((*ptr=='\0') || (strchr("+-,",*ptr)!=NULL)) {
      zl*=zlv;
      if (plmi==1) {zahl+=zl;} else {zahl-=zl;}
      if (*ptr=='+') {plmi=1;} else if (*ptr=='-') {plmi=2;} else {break;}
      zl=0; zlv=1;
    } else if (strchr("0123456789",*ptr)!=NULL) {
      if (doll) {
        if (*ptr!='0') {i1=ipar[*ptr-'1'];} else {i1=0;}
        if (i1<0) {zlv=-1; i1=-i1;}
        for (i3=i1,i2=0;i3>0;i3/=10,i2++) {;}
        for (;i2>0;i2--) {
          for (i4=1,i3=1;i3<i2;i4*=10,i3++) {;}
          zl*=10; zl+=(i1/i4);
          i1%=i4;
        }
      } else {
        zl*=10;
        zl+=(*ptr-'0');
      }
    }
    if (*ptr=='$') {
      doll=1; zlv=1;
    } else {doll=0;}
  }
  return(zahl);
} /* Ende rechnei */
