/* display help text
** - at first call lies_hilfe(), get number of lines
** - then in a loop:
**   call gibaus_hilfe() with starting line number;
**   when scrolling down, increment starting line number
**   and call gibaus_hilfe() again
**   when scrolling up, decrement starting line number
**   and call gibaus_hilfe() again
** creating help file "help.<language number>":
** - each line contains: text or "[IMG]"
**   - text: displayed as text line
**   - [IMG]: display next image, file name: img<number>.<lang_nr>.vga
**            where 1st image of language number 1 is: img1.1.vga
**                  2nd image of language number 1 is: img2.1.vga
** Example:
**   Hello you!
**   Look a nice picture:
**   [IMG]                             <-- img1.<lang_nr>.vga
**   And another picture:
**   [IMG]                             <-- img2.<lang_nr>.vga
**   Now press [Return]
*/

static char ** hf_hbuf=NULL;
static int hf_hzl=0;
static grafik ** hf_grf=NULL;
static int hf_grfanz=0;
static int * hf_zlnr=NULL;
static int hf_zlmax=0;
static int hf_pix=10;
static int hf_col=0;

int lies_hilfe(const char *,int,int);
int gibaus_hilfe(int);


int lies_hilfe(const char * pfad,int lang_nr,int col) {
/* reads in help text
** 1.arg: path to help-files: "help.<lang_nr>"
** 2.arg: language number
** 3.arg: color index of text color
** return value: >=0: OK (number of lines)
**                -1: error reading file
**                -2: allocation error
**                -3: error loading graphic file "img<number>.<lang_nr>.vga"
*/
  FILE * ffp;
  char buf[512];
  int len,i1,i2;
  if (hf_zlmax!=0) {return(hf_zlmax);}
  if (pfad==NULL) {hf_zlmax=-1; return(hf_zlmax);}
  snprintf(buf,sizeof(buf),"%s/help.%d",pfad,lang_nr);
  if ((ffp=fopen(buf,"r"))==NULL) {hf_zlmax=-1; return(hf_zlmax);}
  hf_hzl=0;
  hf_grfanz=0;
  hf_zlmax=0;
  if ((hf_hbuf=malloc(sizeof(char *)))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
  if ((hf_grf=malloc(sizeof(grafik *)))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
  if ((hf_zlnr=malloc(sizeof(int *)))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
  while (fgets(buf,sizeof(buf),ffp)!=NULL) {
    len=strlen(buf);
    while ((len>0) && ((unsigned char)buf[len-1]<=' ')) {len--;}
    buf[len]='\0';
    if (strncmp(buf,"[IMG]",5)==0) {  /* load image */
      hf_grfanz++;
      if ((hf_grf=realloc(hf_grf,sizeof(grafik *)*hf_grfanz))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
      snprintf(buf,sizeof(buf),"%s/img%d.%d.vga",pfad,hf_grfanz,lang_nr);
      if ((hf_grf[hf_grfanz-1]=load_grafik(buf))==NULL) {fprintf(stderr,"(helpfile) %s!\n",errmsg); fclose(ffp); hf_zlmax=-3; return(hf_zlmax);}
      i1=(GRAFIK_HEIGHT(hf_grf[hf_grfanz-1])+(hf_pix-8-1))/hf_pix+1;
      if ((hf_zlnr=realloc(hf_zlnr,sizeof(int)*(hf_zlmax+i1)))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
      hf_zlnr[hf_zlmax]=-hf_grfanz;
      for (i2=1;i2<i1;i2++) {hf_zlnr[hf_zlmax+i2]=0;}
      hf_zlmax+=i1;
    } else {  /* text line */
      hf_hzl++;
      if ((hf_hbuf=realloc(hf_hbuf,sizeof(char *)*hf_hzl))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
      if ((hf_hbuf[hf_hzl-1]=strdup(buf))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
      hf_zlmax++;
      if ((hf_zlnr=realloc(hf_zlnr,sizeof(int)*hf_zlmax))==NULL) {fclose(ffp); hf_zlmax=-2; return(hf_zlmax);}
      hf_zlnr[hf_zlmax-1]=hf_hzl;
    }
  }
  fclose(ffp);
  hf_col=col;
  set_font(NULL,0,0);
  return(hf_zlmax);
} /* Ende lies_hilfe */


int gibaus_hilfe(int zeile) {
/* displays help text
** 1.arg: starting line (from 1)
** return value: number of lines per screen
*/
  int zlbs,zlend,i1,zy;
  zlbs=SC_HEIGHT/hf_pix;  /* lines per screen */
  CLEAR_BOX(NULL,RGB_BLACK);
  zy=0;
  zlend=zeile+zlbs;
  if (zeile<=hf_zlmax) {
    while ((zeile>1) && (hf_zlnr[zeile-1]==0)) {zeile--; zy-=hf_pix;}
  }
  for (i1=zeile;i1<zlend;i1++,zy+=hf_pix) {
    if (i1>hf_zlmax) {break;}
    if (i1<=0) {continue;}
    if (hf_zlnr[i1-1]==0) {continue;}
    if (hf_zlnr[i1-1]<0) {  /* image */
      copy_grafik(NULL,0,zy,hf_grf[-hf_zlnr[i1-1]-1],0,0,0,0,RGB_FULL);
    } else {  /* text */
      draw_text(NULL,hf_col,0,zy,hf_hbuf[hf_zlnr[i1-1]-1],strlen(hf_hbuf[hf_zlnr[i1-1]-1]),RGB_FULL);
    }
  }
  flush_window();
  return(zlbs);
} /* Ende gibaus_hilfe */
