/* kette functions */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "kette.h"

struct kette ** kette_create(int);
int kette_activate_memb(struct kette **,int);
void kette_inactivate_memb(struct kette **,int);
int kette_members(struct kette **,int *);
void kette_destroy(struct kette **);


struct kette ** kette_create(int max_kette) {
/* create a new kette
** 1.arg: number of chains members
** return value: kette or NULL=allocation error
*/
  struct kette ** ktt,* ktg;
  int i1;
  if (max_kette<1) {max_kette=1;}
  /* 2 chains: 0=unused members, 1=active members */
  if (((ktt=malloc(sizeof(struct kette *)*2))==NULL) \
  || ((ktt[0]=malloc(sizeof(struct kette)))==NULL)) {
    return(NULL);
  }
  /* all members are unused */
  ktt[0]->nr=0;
  ktt[0]->nextptr=NULL;
  for (ktg=ktt[0],i1=1;i1<max_kette;i1++) {
    if ((ktg->nextptr=malloc(sizeof(struct kette)))==NULL) {return(NULL);}
    ktg=ktg->nextptr;
    ktg->nr=i1; ktg->nextptr=NULL;
  }
  /* no member is active */
  ktt[1]=NULL;
  return(ktt);
} /* Ende kette_create */


int kette_activate_memb(struct kette ** ktt,int flag) {
/* make an unused (or evtl. the oldest active one) chain member active
** 1.arg: kette created with kette_create()
** 2.arg: if all are used: 0=return -1
**                         1=return oldest active one
** return value: number from 0 to max_kette-1 (see 1.arg of kette_create())
**               to use as index for new active chain member
**               or -1=nothing available
*/
  struct kette * ktg;
  if (ktt==NULL) {return(-1);}
  if ((ktt[0]==NULL) && (flag==1)) {  /* nothing available */
    if ((ktg=ktt[1])==NULL) {return(-1);}
    while (ktg->nextptr!=NULL) {ktg=ktg->nextptr;}
    kette_inactivate_memb(ktt,ktg->nr);
  }
  if (ktt[0]==NULL) {return(-1);}  /* (still) nothing available */
  ktg=ktt[1];
  ktt[1]=ktt[0];
  ktt[0]=ktt[0]->nextptr;
  ktt[1]->nextptr=ktg;
  return(ktt[1]->nr);
} /* Ende kette_activate_memb */


void kette_inactivate_memb(struct kette ** ktt,int membnr) {
/* make an active chain member unused
** 1.arg: kette created with kette_create()
** 2.arg: index number to make unused
**          (number from 0 to max_kette-1 (see 1.arg of kette_create())
**        or -1=make all chain members unused
*/
  struct kette * ktg,* ktv,* kta;
  if (ktt==NULL) {return;}
  ktv=NULL;
_inak1:
  kta=ktt[1];
  while (kta!=NULL) {
    if ((membnr==-1) || (kta->nr==membnr)) {break;}
    ktv=kta;
    kta=kta->nextptr;
  }
  if (kta==NULL) {return;}  /* requested member not found */
  ktg=ktt[0];
  ktt[0]=kta;
  if (ktv!=NULL) {ktv->nextptr=kta->nextptr;} else {ktt[1]=kta->nextptr;}
  ktt[0]->nextptr=ktg;
  if (membnr==-1) {goto _inak1;}
} /* Ende kette_inactivate_memb */


int kette_members(struct kette ** ktt,int * feld) {
/* gives back in 2.arg all active members
** 1.arg: kette created with kette_create()
** 2.arg: address of integer field for active members
**        (field length must be at least max_kette (see 1.arg of kette_create())
** return value: number of active members
*/
  struct kette * ktg;
  int i1=0;
  if (ktt==NULL) {return(0);}
  ktg=ktt[1];
  while (ktg!=NULL) {
    if (feld!=NULL) {feld[i1]=ktg->nr;}
    i1++;
    ktg=ktg->nextptr;
  }
  return(i1);
} /* Ende kette_members */


void kette_destroy(struct kette ** ktt) {
/* destroy and free a kette
** 1.arg: kette created with kette_create()
*/
  struct kette * ktg;
  if (ktt==NULL) {return;}
  while (ktt[0]!=NULL) {
    ktg=ktt[0]->nextptr;
    free(ktt[0]);
    ktt[0]=ktg;
  }
  while (ktt[1]!=NULL) {
    ktg=ktt[1]->nextptr;
    free(ktt[1]);
    ktt[1]=ktg;
  }
  free(ktt);
} /* Ende kette_destroy */
