/* kette functions
**
** Example program (arguments: 0-9 +):
**
** #include "kette.h"
** #define MAX_KNR 32
** int main(int argc,char ** argv) {
**   int ri[MAX_KNR],i1,i3,runde;
**   struct kette ** ktt;
**   ktt=kette_create(MAX_KNR);
**   for (runde=1;runde<argc;runde++) {
**     if (argv[runde][0]=='+') {
**       kette_activate_memb(ktt,1);
**     } else {
**       kette_inactivate_memb(ktt,atoi(argv[runde]));
**     }
**     printf("(%s): ",argv[runde]);
**     i3=kette_members(ktt,ri);
**     printf("Kette=");
**     for (i1=0;i1<i3;i1++) {printf("%d,",ri[i1]);};
**     printf("\n");
**   }
**   kette_destroy(ktt);
**   return(0);
** }
*/

#ifndef KETTE_H
#define KETTE_H

struct kette {
  int nr;
  struct kette * nextptr;
};


/* create a new kette
** 1.arg: number of chains members
** return value: kette or NULL=allocation error
*/
extern struct kette ** kette_create(int);


/* make an unused (or the oldest active one) chain member active
** 1.arg: kette created with kette_create()
** 2.arg: if all are used: 0=return -1
**                         1=return oldest active one
** return value: number from 0 to max_kette-1 (see 1.arg of kette_create())
**               to use as index for new active chain member
**               or -1=nothing available
*/
extern int kette_activate_memb(struct kette **,int);


/* make an active chain member unused
** 1.arg: kette created with kette_create()
** 2.arg: index number to make unused
**          (number from 0 to max_kette-1 (see 1.arg of kette_create())
**        or -1=make all chain members unused
*/
extern void kette_inactivate_memb(struct kette **,int);


/* gives back in 2.arg all active members
** 1.arg: kette created with kette_create()
** 2.arg: address of integer field for active members
**        (field length must be at least max_kette (see 1.arg of kette_create())
** return value: number of active members
*/
extern int kette_members(struct kette **,int *);


/* destroy and free a kette
** 1.arg: kette created with kette_create()
*/
extern void kette_destroy(struct kette **);

#endif /* KETTE_H */
