/* *****************************************************************
   3plane: game for vgagames
   Copyright (C) 2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   ***************************************************************** */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <dirent.h>
#include <vgagames.h>
#include "main.h"
#include "hilfe.h"


char * arg0=NULL;
char install_path[512],sound_set_path[512];
sprite * shs_bild[3+1];
sprite * expl_bild;
sprite * tref_bild;
sprite * rauch_bild;
grafik * flugschatt[4];
int expl_sum,tref_sum,rauch_sum,wow;
struct f_def * fdef;
int fdefmax,diffi,missanz;
int lang_nr,volfld[9];
int mvol[2],wav_nr[7],* mus_nr;

extern int intro(int);
extern int extro(void);
extern char * game(int *,int *);

static void dreh_xy(int *,int *,int);
static void vortext(int);
static void nachtext(int);

int menu_main(int *,int *);
int miss_anz(void);
void load_save(int *,int *,int);
void wie_diffi(void);
void hilfe(void);
void end_err(const char *);


static void dreh_xy(int * x,int * y,int h) {
  int tmp;
  if (*x==-1) {return;}
  tmp=*x;
  *x=h-1-*y;
  *y=tmp;
} /* Ende dreh_xy */


static void vortext(int runde) {
  FILE * ffp;
  char buf[512];
  size_t len;
  char * svk;
  int colind=color_index(CL_GREEN,100),ypos=10;
  CLEAR_BOX(NULL,RGB_BLACK);
  set_font(NULL,0,0);
  snprintf(buf,sizeof(buf),"%s/mission/way/info-%d.%d",install_path,lang_nr,runde);
  if ((ffp=fopen(buf,"r"))!=NULL) {
    while (fgets(buf,sizeof(buf),ffp)!=NULL) {
      if (*buf=='#') {continue;}
      if ((len=strlen(buf)-1)>0) {draw_text(NULL,colind,0,ypos,buf,len,RGB_TRANS);}
      ypos+=11;
    }
    fclose(ffp);
  } else {
    sprintf(buf,"Stage %d",runde);
    draw_text(NULL,colind,0,ypos,buf,strlen(buf),RGB_TRANS);
    ypos+=11;
  }
  draw_text(NULL,colind,0,191,"[Return]",8,RGB_TRANS);
  flush_window();
  SAVE_KEYS(svk);
  CLEAR_KEYS;
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  while (1) {
    get_keys();
    if ((IS_KEYS(KEY_SPACE)) || (IS_KEYS(KEY_ENTER))) {
      break;
    }
  }
  RESTORE_KEYS(svk);
} /* Ende vortext */


static void nachtext(int ok) {
  char buf[512];
  size_t len;
  char * svk;
  int colind;
  if (ok) {
    colind=color_index(CL_GREEN,100);
  } else {
    colind=color_index(CL_RED,100);
  }
  CLEAR_BOX(NULL,RGB_BLACK);
  set_font(NULL,0,0);
  if (ok) {
    if (lang_nr==2) {  /* english */
      strcpy(buf,"Mission completed");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,95,buf,len,RGB_TRANS);
    } else {  /* deutsch */
      strcpy(buf,"Aufgabe erledigt");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,95,buf,len,RGB_TRANS);
    }
  } else {
    if (lang_nr==2) {  /* english */
      strcpy(buf,"You shouldn't just walk around!");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,74,buf,len,RGB_TRANS);
      strcpy(buf,"Perhaps you would like");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,85,buf,len,RGB_TRANS);
      strcpy(buf,"to sweep clean the landing strip???");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,96,buf,len,RGB_TRANS);
      strcpy(buf,"I think we will redo this stage.");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,112,buf,len,RGB_TRANS);
    } else {  /* deutsch */
      strcpy(buf,"Die Landschaft bewundern");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,63,buf,len,RGB_TRANS);
      strcpy(buf,"knnen Sie im Urlaub!");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,74,buf,len,RGB_TRANS);
      strcpy(buf,"Oder ziehen Sie es vor,");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,85,buf,len,RGB_TRANS);
      strcpy(buf,"die Ladebahn zu fegen???");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,96,buf,len,RGB_TRANS);
      strcpy(buf,"Ich gewhre Ihnen noch einen Versuch.");
      len=strlen(buf);
      draw_text(NULL,colind,(SC_WIDTH-len*8)/2,112,buf,len,RGB_TRANS);
    }
  }
  draw_text(NULL,colind,0,191,"[Return]",8,RGB_TRANS);
  flush_window();
  SAVE_KEYS(svk);
  CLEAR_KEYS;
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  while (1) {
    get_keys();
    if ((IS_KEYS(KEY_SPACE)) || (IS_KEYS(KEY_ENTER))) {
      break;
    }
  }
  RESTORE_KEYS(svk);
} /* Ende nachtext */


int main(int argc,char ** argv) {
  int i1,i2,i3,i4,rstat,runde,lepu;
  char buf[1024],* p1;
  grafik * gr1,* gr2;
  FILE * ffp;

  /* initializing */
  arg0=argv[0];
  p1=strrchr(arg0,'/');
  snprintf(install_path,sizeof(install_path),"%.*s",(int)(p1==NULL?1:p1-arg0),p1==NULL?".":arg0);
  snprintf(sound_set_path,sizeof(sound_set_path),"%s/soundcfg",install_path);
  umask(0);
  srand(time(NULL)%1000);
  diffi=2;
  missanz=0;

  wow=0;
  i2=VGAWINDOW_2;
  i3=VGAWINDOW_FULL;
  i4=0;
#ifdef WINDOW_RESIZABLE
  opterr=opterr?opterr:0;
  while ((i1=getopt(argc,argv,"+01234wnt"))!=-1) {
    switch(i1) {
      case '0':  i2=0; break;
      case '1':  i2=VGAWINDOW_1; break;
      case '2':  i2=VGAWINDOW_2; break;
      case '3':  i2=VGAWINDOW_3; break;
      case '4':  i2=VGAWINDOW_4; break;
      case 'w':  i3=0; break;
      case 'n':  i4=VGAWINDOW_NOSWITCH; break;
      case 't':  wow=1; break;
      default:
        fprintf(stderr,"Usage: %s [-0|-1|-2|-3|-4] [-w]\n",arg0);
        fprintf(stderr,"  -0:       maximal scaling factor\n");
        fprintf(stderr,"  -1 to -4: scaling factor 1 to 4\n");
        fprintf(stderr,"  -w:       window rather than full screen\n");
        fprintf(stderr,"  -n:       no switching to another mode\n");
        exit(1);
    }
  }
#endif

  i1=(i2|i3|i4);
  if ((p1=strrchr(arg0,'/'))==NULL) {p1=arg0;} else {p1++;}
  if (open_window(p1,i1)!=0) {fprintf(stderr,"%s: %s\n",arg0,errmsg); exit(1);}
  if (init_sound(22050,0)!=0) {end_err("init_sound");}

  /* get/set language-number */
  if ((lang_nr=init_language(sound_set_path))<0) {end_err("init_language");}

  /* init volume */
  if (init_volume(sound_set_path,volfld,&mvol[0],&mvol[1])<0) {end_err("init_volume");}

  CLEAR_BOX(NULL,RGB_BLACK);
  set_font(font10x17,10,17);
  strcpy(buf,"3plane: Loading ...");
  i1=strlen(buf);
  draw_text(NULL,color_index(CL_YELLOW,100),(SC_WIDTH-i1*10)/2,92,buf,i1,RGB_FULL);
  set_font(NULL,0,0);
  flush_window();

  /* load sound */
  for (i1=0;i1<=6;i1++) {
    snprintf(buf,sizeof(buf),"%s/wave/%d.wav",install_path,i1);
    if ((ffp=fopen(buf,"r"))!=NULL) {
      fclose(ffp);
      wav_nr[i1]=load_wave(buf,TYP_IS_WAVE);
    } else {wav_nr[i1]=0;}
  }

  /* create shot sprites */

  if ((shs_bild[0]=create_sprite())==NULL) {end_err("create_sprite");}
  if ((gr1=create_grafik(1,5))==NULL) {end_err("create_grafik");}
  draw_line(gr1,0,0,0,4,color_index(CL_RED,100));
  add_grafik_to_sprite(shs_bild[0],gr1,0,0,0,0,100);
  free_grafik(gr1);

  if ((shs_bild[1]=create_sprite())==NULL) {end_err("create_sprite");}
  if ((gr1=create_grafik(4,4))==NULL) {end_err("create_grafik");}
  draw_fillbox(gr1,0,0,4,4,color_index(CL_GREEN,100));
  draw_pixel(gr1,0,0,RGB_BLACK);
  draw_pixel(gr1,0,3,RGB_BLACK);
  draw_pixel(gr1,3,0,RGB_BLACK);
  draw_pixel(gr1,3,3,RGB_BLACK);
  draw_pixel(gr1,2,1,color_index(CL_RED,100));
  add_grafik_to_sprite(shs_bild[1],gr1,0,0,0,0,4);
  draw_pixel(gr1,2,1,color_index(CL_GREEN,100));
  draw_pixel(gr1,2,2,color_index(CL_RED,100));
  add_grafik_to_sprite(shs_bild[1],gr1,0,0,0,0,4);
  draw_pixel(gr1,2,2,color_index(CL_GREEN,100));
  draw_pixel(gr1,1,2,color_index(CL_RED,100));
  add_grafik_to_sprite(shs_bild[1],gr1,0,0,0,0,4);
  draw_pixel(gr1,1,2,color_index(CL_GREEN,100));
  draw_pixel(gr1,1,1,color_index(CL_RED,100));
  add_grafik_to_sprite(shs_bild[1],gr1,0,0,0,0,4);
  free_grafik(gr1);

  if ((shs_bild[2]=create_sprite())==NULL) {end_err("create_sprite");}
  if ((gr1=create_grafik(9,9))==NULL) {end_err("create_grafik");}
  draw_line(gr1,2,2,6,2,color_index(CL_BROWN,100));
  draw_line(gr1,2,6,6,6,color_index(CL_BROWN,100));
  draw_line(gr1,2,3,2,5,color_index(CL_BROWN,100));
  draw_line(gr1,6,3,6,5,color_index(CL_BROWN,100));
  draw_fillbox(gr1,3,3,3,3,color_index(CL_BROWN,100));
  draw_pixel(gr1,1,1,color_index(CL_BLUE,100));
  draw_pixel(gr1,0,0,color_index(CL_BLUE,100));
  draw_pixel(gr1,7,1,color_index(CL_BLUE,100));
  draw_pixel(gr1,8,0,color_index(CL_BLUE,100));
  draw_pixel(gr1,1,7,color_index(CL_BLUE,100));
  draw_pixel(gr1,0,8,color_index(CL_BLUE,100));
  draw_pixel(gr1,7,7,color_index(CL_BLUE,100));
  draw_pixel(gr1,8,8,color_index(CL_BLUE,100));
  draw_pixel(gr1,4,1,color_index(CL_YELLOW,100));
  add_grafik_to_sprite(shs_bild[2],gr1,0,0,0,0,10);
  draw_fillbox(gr1,3,3,3,3,color_index(CL_VIOLET,100));
  add_grafik_to_sprite(shs_bild[2],gr1,0,0,0,0,5);
  draw_fillbox(gr1,3,3,3,3,color_index(CL_RED,100));
  add_grafik_to_sprite(shs_bild[2],gr1,0,0,0,0,7);
  draw_fillbox(gr1,3,3,3,3,color_index(CL_VIOLET,100));
  add_grafik_to_sprite(shs_bild[2],gr1,0,0,0,0,5);
  free_grafik(gr1);

  for (i1=3;i1<4;i1++) {
    snprintf(buf,sizeof(buf),"%s/sprites/fshs%d.sprite",install_path,i1);
    shs_bild[i1]=load_sprite(buf);
  }
  snprintf(buf,sizeof(buf),"%s/sprites/expl.sprite",install_path);
  if ((expl_bild=load_sprite(buf))==NULL) {end_err("load expl sprite");}
  expl_sum=reset_sprite(expl_bild);
  snprintf(buf,sizeof(buf),"%s/sprites/tref.sprite",install_path);
  if ((tref_bild=load_sprite(buf))==NULL) {end_err("load tref sprite");}
  tref_sum=reset_sprite(tref_bild);
  snprintf(buf,sizeof(buf),"%s/sprites/rauch.sprite",install_path);
  if ((rauch_bild=load_sprite(buf))==NULL) {end_err("load rauch sprite");}
  rauch_sum=reset_sprite(rauch_bild);

  /* create air plane shadow */
  {int z1,z2,z3,z4;
   grafik * grf;
   if ((flugschatt[0]=create_grafik(13,13))==NULL) {end_err("create_grafik: flugschatt");}
   draw_fillbox(flugschatt[0],0,7,13,3,RGB_DARK);
   draw_fillbox(flugschatt[0],5,0,3,13,RGB_DARK);
   draw_fillbox(flugschatt[0],3,0,7,2,RGB_DARK);
   if ((grf=create_grafik(13,13))==NULL) {end_err("create_grafik: flugschatt");}
   for (i1=1;i1<4;i1++) {
     z1=z2=z3=z4=0;
     if (rotate_grafik(grf,flugschatt[0],90*i1,&z1,&z2,&z3,&z4)==NULL) {end_err("rotate_grafik flugschatt");}
     if ((flugschatt[i1]=create_grafik(z3,z4))==NULL) {end_err("create_grafik flugschatt");}
     copy_grafik(flugschatt[i1],0,0,grf,0,0,z3,z4,RGB_FULL);
   }
   free_grafik(grf);
  }

  /* load enemy definitions */
  {char pfad[1024],buf[1024],* bufptr,* p1;
   int f_allo;
   DIR * ddp;
   struct dirent * dirp;
   if ((fdef=malloc(sizeof(*fdef)))==NULL) {strcpy(errmsg,"malloc"); end_err("allocate enemy def");}
   f_allo=0;
   snprintf(pfad,sizeof(pfad),"%s/mission/enemies",install_path);
   if ((ddp=opendir(pfad))!=NULL) {
     while ((dirp=readdir(ddp))!=NULL) {
       p1=dirp->d_name;
       if ((*p1=='.') || ((i1=(int)strlen(p1))<=4) || (strcmp(p1+i1-4,".def")!=0)) {continue;}
       snprintf(pfad,sizeof(pfad),"%s/mission/enemies/%s",install_path,p1);
       if ((ffp=fopen(pfad,"r"))==NULL) {continue;}

       f_allo++;
       if ((fdef=realloc(fdef,sizeof(*fdef)*f_allo))==NULL) {strcpy(errmsg,"realloc"); end_err("allocate enemy def");}
       memset(&fdef[f_allo-1],0,sizeof(*fdef));
       fdef[f_allo-1].defname=strdup(p1);
       if ((p1=strrchr(fdef[f_allo-1].defname,'.'))!=NULL) {*p1='\0';}
       fdef[f_allo-1].schs_anz=0;
       fdef[f_allo-1].expl_anz=0;
       while (fgets(buf,sizeof(buf),ffp)!=NULL) {
         bufptr=buf+strspn(buf," \t\v");
         for (i1=(int)strlen(bufptr)-1;i1>=0;i1--) {
           if ((unsigned char)bufptr[i1]>' ') {break;}
         }
         bufptr[i1+1]='\0';

         if (strncmp(bufptr,"$E10=",5)==0) {  /* lebenspunkte */
           fdef[f_allo-1].c_lebenspunkte=atoi(bufptr+5);
         } else if (strncmp(bufptr,"$E11=",5)==0) {  /* rauch */
           fdef[f_allo-1].rauch=atoi(bufptr+5);
         } else if (strncmp(bufptr,"$E12=",5)==0) {  /* minus_collp */
           fdef[f_allo-1].minus_collp=atoi(bufptr+5);
         } else if (strncmp(bufptr,"$E13=",5)==0) {  /* minus_shs */
           fdef[f_allo-1].minus_shs=atoi(bufptr+5);
         } else if (strncmp(bufptr,"$E20=",5)==0) {  /* filename "ok" */
           snprintf(pfad,sizeof(pfad),"%s/mission/sprites/%s",install_path,bufptr+5);
           if ((fdef[f_allo-1].bild[0]=load_sprite(pfad))==NULL) {fclose(ffp); end_err("$E20");}
           if ((fdef[f_allo-1].bild[1]=rotate_sprite(fdef[f_allo-1].bild[0],90))==NULL) {fclose(ffp); end_err("$E20");}
           if ((fdef[f_allo-1].bild[2]=rotate_sprite(fdef[f_allo-1].bild[0],180))==NULL) {fclose(ffp); end_err("$E20");}
           if ((fdef[f_allo-1].bild[3]=rotate_sprite(fdef[f_allo-1].bild[0],270))==NULL) {fclose(ffp); end_err("$E20");}
         } else if (strncmp(bufptr,"$E21=",5)==0) {  /* filename "dead" */
           snprintf(pfad,sizeof(pfad),"%s/mission/sprites/%s",install_path,bufptr+5);
           if ((fdef[f_allo-1].bild[4]=load_sprite(pfad))==NULL) {fclose(ffp); end_err("$E21");}
         } else if (strncmp(bufptr,"$E22=",5)==0) {  /* x,y pos gun */
           fdef[f_allo-1].xgun[0]=fdef[f_allo-1].ygun[0]=atoi(bufptr+5);
           if ((p1=strchr(bufptr+5,','))!=NULL) {fdef[f_allo-1].ygun[0]=atoi(p1+1);}
           for (i1=1;i1<4;i1++) {
             fdef[f_allo-1].xgun[i1]=fdef[f_allo-1].xgun[i1-1];
             fdef[f_allo-1].ygun[i1]=fdef[f_allo-1].ygun[i1-1];
             dreh_xy(&fdef[f_allo-1].xgun[i1],&fdef[f_allo-1].ygun[i1],SPRITE_HEIGHT(fdef[f_allo-1].bild[i1-1]));
           }
         } else if (strncmp(bufptr,"$E23=",5)==0) {  /* filename of gun */
           int ii,z1,z2,z3,z4;
           snprintf(pfad,sizeof(pfad),"%s/mission/graphics/%s",install_path,bufptr+5);
           if ((gr1=load_grafik(pfad))==NULL) {fclose(ffp); end_err("$E23");}
           ii=(GRAFIK_WIDTH(gr1)>GRAFIK_HEIGHT(gr1)?GRAFIK_WIDTH(gr1):GRAFIK_HEIGHT(gr1));
           if ((gr2=create_grafik(ii,ii))==NULL) {end_err("create_grafik $E23");}
           for (i1=0;i1<8;i1++) {
             z1=z2=z3=z4=0;
             if (rotate_grafik(gr2,gr1,-45*i1,&z1,&z2,&z3,&z4)==NULL) {end_err("rotate_grafik $E23");}
             if ((fdef[f_allo-1].gungr[i1]=create_grafik(z3,z4))==NULL) {end_err("create_grafik $E23");}
             copy_grafik(fdef[f_allo-1].gungr[i1],0,0,gr2,0,0,z3,z4,RGB_FULL);
           }
           free_grafik(gr2);
           free_grafik(gr1);
         } else if (strncmp(bufptr,"$E30=",5)==0) {  /* luft */
           fdef[f_allo-1].luft=atoi(bufptr+5);
         } else if (strncmp(bufptr,"$E4",3)==0) {  /* shots */
           if (strncmp(bufptr,"$E40=",5)==0) {  /* xm,ym shot */
             if (fdef[f_allo-1].schs_anz++==0) {
               fdef[f_allo-1].schs=malloc(sizeof(*fdef[f_allo-1].schs)*fdef[f_allo-1].schs_anz);
             } else {
               fdef[f_allo-1].schs=realloc(fdef[f_allo-1].schs,sizeof(*fdef[f_allo-1].schs)*fdef[f_allo-1].schs_anz);
             }
             if (fdef[f_allo-1].schs==NULL) {strcpy(errmsg,"malloc/realloc"); end_err("allocation error ($E40)");}
             memset(&fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1],0,sizeof(fdef[f_allo-1].schs[0]));
             fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].xm[0]=fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].ym[0]=atoi(bufptr+5);
             if ((p1=strchr(bufptr+5,','))!=NULL) {fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].ym[0]=atoi(p1+1);}
             for (i1=1;i1<4;i1++) {
               fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].xm[i1]=fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].xm[i1-1];
               fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].ym[i1]=fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].ym[i1-1];
               dreh_xy(&fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].xm[i1],&fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].ym[i1],SPRITE_HEIGHT(fdef[f_allo-1].bild[i1-1]));
             }
           } else if (strncmp(bufptr,"$E41=",5)==0) {  /* art */
             fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].art=atoi(bufptr+5);
           } else if (strncmp(bufptr,"$E42=",5)==0) {  /* rand */
             fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].rand=atoi(bufptr+5);
             if ((p1=strchr(bufptr+5,','))!=NULL) {fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].warte=atoi(p1+1);}
           } else if (strncmp(bufptr,"$E43=",5)==0) {  /* max */
             fdef[f_allo-1].schs[fdef[f_allo-1].schs_anz-1].c_max=atoi(bufptr+5);
           }
         } else if (strncmp(bufptr,"$E5",3)==0) {  /* expl */
           if (strncmp(bufptr,"$E50=",5)==0) {  /* xm,ym expl */
             if (fdef[f_allo-1].expl_anz++==0) {
               fdef[f_allo-1].expl=malloc(sizeof(*fdef[f_allo-1].expl)*fdef[f_allo-1].expl_anz);
             } else {
               fdef[f_allo-1].expl=realloc(fdef[f_allo-1].expl,sizeof(*fdef[f_allo-1].expl)*fdef[f_allo-1].expl_anz);
             }
             if (fdef[f_allo-1].expl==NULL) {strcpy(errmsg,"malloc/realloc"); end_err("allocation error ($E50)");}
             memset(&fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1],0,sizeof(fdef[f_allo-1].expl[0]));
             fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].xm[0]=fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].ym[0]=atoi(bufptr+5);
             if ((p1=strchr(bufptr+5,','))!=NULL) {fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].ym[0]=atoi(p1+1);}
             for (i1=1;i1<4;i1++) {
               fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].xm[i1]=fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].xm[i1-1];
               fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].ym[i1]=fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].ym[i1-1];
               dreh_xy(&fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].xm[i1],&fdef[f_allo-1].expl[fdef[f_allo-1].expl_anz-1].ym[i1],SPRITE_HEIGHT(fdef[f_allo-1].bild[i1-1]));
             }
           }
         }
       }
       fclose(ffp);
     }
     closedir(ddp);
   }
   fdefmax=f_allo;
  }

  missanz=miss_anz();
  /* load music */
  if ((mus_nr=malloc(sizeof(int)*(missanz+1)))==NULL) {end_err("allocation error (music)");}
  for (i1=1;i1<=missanz;i1++) {
    snprintf(buf,sizeof(buf),"%s/wave/%d.mid",install_path,i1);
    if ((ffp=fopen(buf,"r"))!=NULL) {
      fclose(ffp);
      mus_nr[i1]=load_wave(buf,TYP_IS_MIDI);
    } else {mus_nr[i1]=0;}
  }
_nochmalgame:
  rstat=runde=lepu=0;
  CLEAR_BOX(NULL,RGB_BLACK);
  flush_window();
  if (menu_main(&runde,&lepu)==0) {goto _endegame;}
  if (runde==0) {intro(1);}
  for (runde++;runde<=missanz;runde++) {
    vortext(runde);
    rstat=runde;
    if ((p1=game(&rstat,&lepu))!=NULL) {end_err(p1);}
    if (rstat<0) {  /* game over or quit */
      if (rstat==-2) {goto _endegame;}  /* quit */
      if (rstat==-1) {  /* game over */
        CLEAR_BOX(NULL,RGB_BLACK);
        set_font(font10x17,10,17);
        draw_text(NULL,color_index(CL_RED,100),(SC_WIDTH-9*10)/2,91,"Game over",9,RGB_TRANS);
        set_font(NULL,0,0);
        flush_window();
        sleep(4);
      }
      break;
    } else if (rstat==0) {  /* mission failed */
      nachtext(0);
      runde--;
    } else {  /* mission successful */
      nachtext(1);
    }
    load_save(&runde,&lepu,1);  /* save last mission */
  }

  if (rstat>0) {extro();}
  goto _nochmalgame;

_endegame:
  /* Ende */
  for (i1=0;i1<4;i1++) {free_sprite(shs_bild[i1]);}
  free(mus_nr);
  set_vol(mvol[0],0);
  set_vol(mvol[1],1);
  end_sound();
  close_window();
  exit(0);
} /* Ende main */


int menu_main(int * runde,int * lepu) {
/* give out menu */
#define MENU_EINTR 5
  char text[][MENU_EINTR][128]={
    {"Neues Spiel","Lautstrke","Hilfe","Weiterspielen","Beenden"},
    {"New game","Volume","Help","Play on","Quit"}
  };
  grafik * gzoom,* grf;
  int rd,lp;
  int i1,posi,lgn,cl0,cl1;
  int imm,ypo,x,y,w,h,fb;
  float blah,blm;
  char * svk;
  if ((lgn=lang_nr)>2) {lgn=1;}
  lgn--;
  rd=lp=0;
  if (runde!=NULL) {load_save(&rd,&lp,0);}
  SAVE_KEYS(svk);
  CLEAR_KEYS;
  ADD_KEYS(KEY_UCURS,SHORT_KEY);
  ADD_KEYS(KEY_DCURS,SHORT_KEY);
  ADD_KEYS(KEY_KP_2,SHORT_KEY);
  ADD_KEYS(KEY_KP_8,SHORT_KEY);
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  posi=1;
  if (runde!=NULL) {
    if (intro(0)>0) {posi=3;} else if ((rd>0) && (rd<missanz)) {posi=4;}
  }
  if (runde==NULL) {posi=4;}
  cl0=color_index(CL_YELLOW,50);
  cl1=color_index(CL_YELLOW,100);
  if ((gzoom=create_grafik(SC_WIDTH,SC_HEIGHT/4))==NULL) {RESTORE_KEYS(svk); return(0);}
  blah=2.; blm=.1;
  fb=0;

  while (1) {
    CLEAR_BOX(NULL,RGB_BLACK);
    set_font(font10x17,10,17);
    if (++fb>=16) {fb=0;}
    switch(fb/2) {
      case 0: i1=color_index(CL_ORANGE,100); break;
      case 1: i1=color_index(CL_REDORANGE,100); break;
      case 2: i1=color_index(CL_RED,100); break;
      case 3: i1=color_index(CL_REDVIOLET,100); break;
      case 4: i1=color_index(CL_VIOLET,100); break;
      case 5: i1=color_index(CL_REDVIOLET,100); break;
      case 6: i1=color_index(CL_RED,100); break;
      case 7: i1=color_index(CL_REDORANGE,100); break;
      default: i1=RGB_BLACK;
    }
    draw_text(NULL,i1,(SC_WIDTH-140)/2,10,"+++ 3plane +++",14,RGB_FULL);
    set_font(NULL,0,0);
    ypo=60;
    for (imm=1;imm<=MENU_EINTR;imm++) {
      if ((grf=text_to_grafik(posi==imm?cl1:cl0,RGB_BLACK,0,0,text[lgn][imm-1]))==NULL) {RESTORE_KEYS(svk); return(0);}
      if (imm%2==1) {i1=20-blah;} else {i1=blah;}
      x=y=w=h=0;
      if (zoom_grafik(gzoom,grf,imm%2==1?4.-blah:blah,imm%2==1?4.-blah:blah,&x,&y,&w,&h)==NULL) {RESTORE_KEYS(svk); return(0);}
      free_grafik(grf);
      copy_grafik(NULL,(SC_WIDTH-w)/2,ypo,gzoom,0,0,w,h,RGB_FULL);
      ypo+=h+5;
    }
    flush_window();
    get_keys();
    i1=posi;
    if ((IS_KEYS(KEY_DCURS)) || (IS_KEYS(KEY_KP_2))) {
      if (++posi>MENU_EINTR) {posi=MENU_EINTR;}
    }
    if ((IS_KEYS(KEY_UCURS)) || (IS_KEYS(KEY_KP_8))) {
      if (--posi<1) {posi=1;}
    }
    if ((posi==1) && (runde==NULL)) {posi=2;}
    if ((posi==4) && (rd==0) && (runde!=NULL)) {
      if (i1==3) {posi=5;} else {posi=3;}
    }
    if (IS_KEYS(KEY_ENTER)) {
      if (posi==1) {RESTORE_KEYS(svk); wie_diffi(); return(1);}
      if (posi==2) {menu_volume(sound_set_path,volfld);}
      if (posi==3) {hilfe();}
      if (posi==4) {
        if (runde!=NULL) {*runde=rd;}
        if (lepu!=NULL) {*lepu=lp;}
        RESTORE_KEYS(svk);
        return(1);
      }
      if (posi==5) {RESTORE_KEYS(svk); return(0);}
    }
    blah+=blm;
    if (blah>=3.) {blah=3.; blm=-.1;} else if (blah<=1.) {blah=1.; blm=.1;}
    wait_time(50);
  }
  RESTORE_KEYS(svk);
  return(0);
} /* Ende menu_main */


int miss_anz() {
  /* count number of missions */
  char pfad[1024];
  FILE * ffp;
  int i1;
  for (i1=1;;i1++) {
    snprintf(pfad,sizeof(pfad),"%s/mission/way/way.%d",install_path,i1);
    if ((ffp=fopen(pfad,"r"))==NULL) {break;}
    fclose(ffp);
  }
  return(--i1);
} /* Ende miss_anz */


void load_save(int * runde,int * lepu,int flag) {
/* flag=0: continue last mission; flag=1: save completed mission */
  char pfad[1024];
  FILE * ffp;
  snprintf(pfad,sizeof(pfad),"%s/save/savegame",install_path);
  if (flag==0) {
    if ((ffp=fopen(pfad,"r"))==NULL) {return;}
    if (fgets(pfad,sizeof(pfad),ffp)!=NULL) {*runde=atoi(pfad);}
    if (fgets(pfad,sizeof(pfad),ffp)!=NULL) {*lepu=atoi(pfad);}
    if (fgets(pfad,sizeof(pfad),ffp)!=NULL) {diffi=atoi(pfad);}
  } else if (flag==1) {
    unlink(pfad);
    if ((ffp=fopen(pfad,"w"))==NULL) {return;}
    fprintf(ffp,"%d\n%d\n%d\n",*runde,*lepu,diffi);
    fchmod(fileno(ffp),0666);
  } else {return;}
  fclose(ffp);
} /* Ende load_save */


void wie_diffi() {
/* set difficulty */
  char buf[256];
  int * svk,len;
  int colind=color_index(CL_YELLOW,100);
  if (wow) {diffi=2; return;}
  SAVE_KEYS(svk);
  CLEAR_KEYS;
  ADD_KEYS(KEY_1,SHORT_KEY); ADD_KEYS(KEY_KP_1,SHORT_KEY);
  ADD_KEYS(KEY_2,SHORT_KEY); ADD_KEYS(KEY_KP_2,SHORT_KEY);
  ADD_KEYS(KEY_3,SHORT_KEY); ADD_KEYS(KEY_KP_3,SHORT_KEY);
  CLEAR_BOX(NULL,RGB_BLACK);
  if (lang_nr==2) {  /* english */
    len=snprintf(buf,sizeof(buf),"%s","Skill");
    draw_text(NULL,colind,(SC_WIDTH-len*8)/2,10,buf,len,RGB_TRANS);
    len=snprintf(buf,sizeof(buf),"%s","[1] - easy");
    draw_text(NULL,colind,50,80,buf,len,RGB_TRANS);
    len=snprintf(buf,sizeof(buf),"%s","[2] - middle");
    draw_text(NULL,colind,50,100,buf,len,RGB_TRANS);
    len=snprintf(buf,sizeof(buf),"%s","[3] - hard");
    draw_text(NULL,colind,50,120,buf,len,RGB_TRANS);
  } else {  /* deutsch */
    len=snprintf(buf,sizeof(buf),"%s","Schwierigkeit");
    draw_text(NULL,colind,(SC_WIDTH-len*8)/2,10,buf,len,RGB_TRANS);
    len=snprintf(buf,sizeof(buf),"%s","[1] - leicht");
    draw_text(NULL,colind,50,80,buf,len,RGB_TRANS);
    len=snprintf(buf,sizeof(buf),"%s","[2] - mittel");
    draw_text(NULL,colind,50,100,buf,len,RGB_TRANS);
    len=snprintf(buf,sizeof(buf),"%s","[3] - schwer");
    draw_text(NULL,colind,50,120,buf,len,RGB_TRANS);
  }
  len=snprintf(buf,sizeof(buf),"%s","--> ?");
  draw_text(NULL,colind,50,140,buf,len,RGB_TRANS);
  flush_window();
  /* key input */
  while (1) {
    wait_time(50);
    get_keys();
    if ((IS_KEYS(KEY_1)) || (IS_KEYS(KEY_KP_1))) {diffi=1; break;}
    if ((IS_KEYS(KEY_2)) || (IS_KEYS(KEY_KP_2))) {diffi=2; break;}
    if ((IS_KEYS(KEY_3)) || (IS_KEYS(KEY_KP_3))) {diffi=3; break;}
  }
  len=snprintf(buf,sizeof(buf),"--> %d ",diffi);
  draw_text(NULL,colind,50,140,buf,len,RGB_FULL);
  flush_window();
  sleep(1);
  RESTORE_KEYS(svk);
  CLEAR_BOX(NULL,RGB_BLACK);
  flush_window();
} /* Ende wie_diffi */


void hilfe() {
  int col=color_index(CL_VIOLET,100),zlmax,zl,zlbs;
  char * svk;
  char buf[512];
  SAVE_KEYS(svk);
  CLEAR_KEYS;
  ADD_KEYS(KEY_UCURS,LONG_KEY);
  ADD_KEYS(KEY_DCURS,LONG_KEY);
  ADD_KEYS(KEY_KP_2,LONG_KEY);
  ADD_KEYS(KEY_KP_8,LONG_KEY);
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  ADD_KEYS(KEY_SPACE,SHORT_KEY);
  ADD_KEYS(KEY_BSP,SHORT_KEY);
  snprintf(buf,sizeof(buf),"%s/help",install_path);
  if ((zlmax=lies_hilfe(buf,lang_nr,col))<0) {
    if (zlmax==-1) {fprintf(stderr,"%s: error reading help-file\n",arg0);}
    else if (zlmax==-2) {fprintf(stderr,"%s: allocation error\n",arg0);}
    else if (zlmax==-3) {fprintf(stderr,"%s: error loading help-image\n",arg0);}
    else {fprintf(stderr,"%s: help: unknown error\n",arg0);}
    RESTORE_KEYS(svk);
    return;
  }

  CLEAR_BOX(NULL,RGB_BLACK);
  col=color_index(CL_YELLOW,100);
  if (lang_nr==2) {  /* english */
    draw_text(NULL,col,0,20,"Using help:",11,RGB_FULL);
    draw_text(NULL,col,0,40,"  [CURSOR UP]   - scroll up",27,RGB_FULL);
    draw_text(NULL,col,0,50,"  [CURSOR DOWN] - scroll down",29,RGB_FULL);
    draw_text(NULL,col,0,60,"  [BACKSPACE]   - screen up",27,RGB_FULL);
    draw_text(NULL,col,0,70,"  [SPACE]       - screen down",29,RGB_FULL);
    draw_text(NULL,col,0,80,"  [RETURN]      - exit",22,RGB_FULL);
    draw_text(NULL,col,0,190,"[Return]",8,RGB_FULL);
  } else {  /* deutsch */
    draw_text(NULL,col,0,20,"Hilfe benutzen:",15,RGB_FULL);
    draw_text(NULL,col,0,40,"  [CURSOR RAUF]   - Zeile rauf",30,RGB_FULL);
    draw_text(NULL,col,0,50,"  [CURSOR RUNTER] - Zeile runter",32,RGB_FULL);
    draw_text(NULL,col,0,60,"  [BACKSPACE]     - Bildschirm rauf",35,RGB_FULL);
    draw_text(NULL,col,0,70,"  [LEERTASTE]     - Bildschirm runter",37,RGB_FULL);
    draw_text(NULL,col,0,80,"  [RETURN]        - Exit",24,RGB_FULL);
    draw_text(NULL,col,0,190,"[Return]",8,RGB_FULL);
  }
  flush_window();
  while (1) {
    get_keys();
    if (IS_KEYS(KEY_ENTER)) {break;}
    wait_time(50);
  }

  zl=1;
  while (1) {
    zlbs=gibaus_hilfe(zl);
    get_keys();
    if ((IS_KEYS(KEY_DCURS)) || (IS_KEYS(KEY_KP_2))) {
      zl++;
      if (zl>zlmax-zlbs+1) {zl=zlmax-zlbs+1;}
      if (zl<1) {zl=1;}
    }
    if ((IS_KEYS(KEY_UCURS)) || (IS_KEYS(KEY_KP_8))) {
      zl--;
      if (zl<1) {zl=1;}
    }
    if (IS_KEYS(KEY_SPACE)) {
      zl+=zlbs;
      if (zl>zlmax-zlbs+1) {zl=zlmax-zlbs+1;}
      if (zl<1) {zl=1;}
    }
    if (IS_KEYS(KEY_BSP)) {
      zl-=zlbs;
      if (zl<1) {zl=1;}
    }
    if (IS_KEYS(KEY_ENTER)) {break;}
    wait_time(50);
  }
  RESTORE_KEYS(svk);
} /* Ende hilfe */


void end_err(const char * msg) {
  set_vol(mvol[0],0);
  set_vol(mvol[1],1);
  end_sound();
  close_window();
  fprintf(stderr,"%s: %s: %s\n",arg0,msg,errmsg);
  exit(1);
} /* Ende end_err */
