#ifndef MAIN_H
#define MAIN_H

/* Zufallszahl von 0 bis Z-1 */
#define ZUFALL(Z)  ((int)((float)(Z)*rand()/(RAND_MAX+1.0)))

#include "soundset/sound_set.h"
extern char install_path[512];

/* structs: (c) means constant */

/* enemy definitions */
struct f_def {
  int c_lebenspunkte;  /* (c) healthy */
  int rauch;           /* (c) when lebenspunkte<rauch: rauchts */
  int minus_collp;     /* (c) decrement when collapsed with 3plane */
  int minus_shs;       /* (c) decrement when hit from 3planes shot */
  sprite * bild[5];    /* (c) 4 sprites for "ok" and 1 sprite for "dead" */
  grafik * gungr[8];   /* (c) 8 graphics for a rotating gun */
  int xgun[4],ygun[4]; /* (c) gun MiPu */
  int luft;            /* (c) 1=air enemy, 0=ground enemy */
  /* shot */
  int schs_anz;        /* (c) number of allocated elements in struct schs */
  struct {             /* struct schs */
    int xm[4],ym[4];     /* (c) shot MiPu of enemy */
    int art;             /* (c) type of shot: 1=MG, 2=air-mine, 3=rocket */
    int rand;            /* (c) random number for shots */
    int warte;           /* (c) loops to wait at least between shots */
    int c_max;           /* (c) maximum of shots */
  } * schs;
  /* explosions */
  int expl_anz;        /* (c) number of allocated elements in struct expl */
  struct {             /* struct expl */
    int xm[4],ym[4];     /* (c) explosion MiPu of enemy */
  } * expl;
  char * defname;      /* definition name */
};

extern struct f_def * fdef;
extern int fdefmax,diffi;
extern int lang_nr,volfld[9];
extern int wav_nr[7],* mus_nr;
#define WAVE_GEFAHR 0
#define WAVE_I_E   1
#define WAVE_ES_I  2
#define WAVE_IS_E  3
#define WAVE_IS_ES 4
#define WAVE_MUN0  5
#define WAVE_MUN1  6

/* enemy in ground and air */
struct f_fzg {
  struct f_def * def;
  int lebenspunkte;    /* healthy decremeted when hit */
  float xm,ym;         /* x,y MiPu for starting and actually */
  int trfz;            /* (c) 0=no count, 1=count when hit, 2=won when hit */
  int gunidx,gsx,gsy;  /* index of gun graphic, x/y-start of gunshot */
  int bildidx;         /* index for bild: 0=down, 1=left, 2=up, 3=right */
  /* moving */
  int bewg_runde;      /* counter for loops when moving */
  int bewg_anz;        /* (c) number of allocated elements in struct bewg */
  int bewg_pos;        /* index which position actual in struct bewg */
  struct {             /* struct bewg */
    float x,y;           /* (c) x,y moving */
    int runden;          /* (c) number of loops */
  } * bewg;
  /* shot */
  int * schs_max;      /* maximum of shots decremented */
  int * schs_warte;    /* how long waited between shots actually */
  /* explosions */
  int expl_runde;      /* counter for sprite when exploding (decremented) */
  int expl_pos;        /* index which position actual in struct expl
                          or -1=only first position one time (when hit) */
};

/* enemy shots */
struct f_shs {
  int lebenspunkte;    /* 1=existing or 0=dead */
  int art;             /* (c) type of shot: 1=MG, 2=air-mine, 3=rocket */
  int expl_runde;      /* counter for sprite when exploding (decremented) */
  float xm,ym;         /* actual position x,y (MiPu) */
  int runden;          /* number of loops already existing */
  int wdz;             /* (c) angle in degrees to ship */
  float wnkl;          /* (c) angle in radians (-PI/2 to PI/2) at release */
  float xp,yp;         /* (c) x,y values to add each loop */
};
#define F_SHS_ADD(P1) (P1==1?3.:(P1==2?1.:3.))  /* pixels per loop */
extern sprite * shs_bild[3+1];  /* sprites for shots
                                   (index: 0=3plane, 1=MG, 2=air-mine, 3=rocket) */
extern sprite * expl_bild;  /* sprite for explosions */
extern sprite * tref_bild;  /* sprite for hit explosion */
extern sprite * rauch_bild;  /* sprite for rauch */
extern grafik * flugschatt[4];  /* graphic for air plane shadow */
extern int expl_sum,tref_sum,rauch_sum,wow;
extern int menu_main(int *,int *);

/* 3plane */
struct i_fzg {
  int lebenspunkte;    /* decremeted when hit */
  int minus_feind;     /* (c) decrement when collapsed with enemy */
  int minus_shs[3];    /* (c) decrement when hit from MG/air-mine/rocket */
  int rauch;           /* (c) when lebenspunkte<rauch: rauchts */
  sprite * bild[1];    /* (c) sprite for 3plane */
  float xm,ym;         /* x,y MiPu for starting and actually */
  /* explosions */
  int expl_runde;      /* counter for sprite when exploding (decremented) */
  int expl_anz;        /* (c) number of allocated elements in struct expl */
  int expl_pos;        /* index which position actual in struct expl
                          or -1=only first position one time (when hit) */
  struct {             /* struct expl */
    int xm,ym;           /* (c) explosion MiPu of 3plane */
  } * expl;
};

/* 3planes shots */
struct i_shs {
  int lebenspunkte;    /* 1=existing or 0=dead */
  float xm,ym;         /* actual position x,y (MiPu) */
  float xp,yp;         /* (c) x,y values to add each loop */
};

#endif /* MAIN_H */
