/* Global sound and language setting functions */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <vgagames.h>

#define CHN_TABLE  "chn.table"
#define LANG_TABLE "lang.table"
#define SNDVOL_CFG "sndvol.cfg"
#define LANG_CFG   "lang.cfg"

#define MENU_BILD(X1,Y1,X2,Y2,Y0) \
   {draw_fillbox(NULL,X1+7,Y1+7,X2-X1,Y2-Y1,RGB_BLACK); \
    draw_fillbox(NULL,X1,Y1,X2-X1,Y2-Y1,color_index(CL_BLUE,30)); \
    draw_line(NULL,X1+5,Y1+5,X2-5,Y1+5,RGB_WHITE); \
    draw_line(NULL,X1+5,Y2-5,X2-5,Y2-5,RGB_WHITE); \
    draw_line(NULL,X1+5,Y1+5,X1+5,Y2-5,RGB_WHITE); \
    draw_line(NULL,X2-5,Y1+5,X2-5,Y2-5,RGB_WHITE); \
    Y0=Y1+10; \
    copy_grafik(NULL,X1+(X2-X1-GRAFIK_WIDTH(groben))/2,Y0,groben,0,0,0,0,RGB_TRANS); \
    Y0+=GRAFIK_HEIGHT(groben)+2; \
   }

static int langnr=0;             /* language-number */
static int c_anz=0;              /* number of "volume field" indexes */
static int test_sound_nr[9]={};  /* test sound numbers (0 to c_anz) */
static int channel_nr[9]={};     /* joined channel numbers (0 to c_anz) */
static char s_text[9][11];       /* display text up to 9 chars (0 to c_anz) */
static grafik * groben=NULL;

int init_language(const char *);
int init_volume(const char *,int *,int *,int *);
void menu_volume(const char *,int *);


int init_language(const char * set_path) {
/* initialilly set or load saved language-number
** 1.arg: pathname to "sound setting directory"
** return value: >0: language-number
**               -1: error (errmsg is set)
*/
  int lnr,i1;
  size_t txtlen;
  char sfil[512],buf[256],txt[2048],* p1;
  FILE * flg;
  grafik * grf;
  if (set_path==NULL) {
    strcpy(errmsg,"argument NULL");
    return(-1);
  }
  /* read language(s) from lang.cfg and lang.table */
  snprintf(sfil,sizeof(sfil),"%s/%s",set_path,LANG_CFG);
  if ((flg=fopen(sfil,"r"))==NULL) {  /* have language-number set */
    struct stat sbuf;
    snprintf(sfil,sizeof(sfil),"%s/%s",set_path,LANG_TABLE);
    if ((flg=fopen(sfil,"r"))==NULL) {
      snprintf(errmsg,sizeof(errmsg),"cannot open %s",sfil);
      return(-1);
    }
    set_font(NULL,0,0);
    CLEAR_BOX(NULL,RGB_BLACK);
    lnr=0;
    txtlen=0; *txt='\0';
    while (fgets(buf,sizeof(buf),flg)!=NULL) {
      if ((p1=strchr(buf,'#'))!=NULL) {*p1='\0';}
      for (p1=buf;((p1!='\0')&&((unsigned char)*p1<=' '));p1++) {;}
      for (p1=buf+strlen(buf);((p1>=buf)&&((unsigned char)*p1<=' '));p1--) {;}
      p1[1]='\0';
      if (*buf=='\0') {continue;}
      i1=snprintf(txt+txtlen,sizeof(txt)-txtlen,"%d - %s\n",++lnr,buf);
      if ((i1==-1) || (i1>=(int)(sizeof(txt)-txtlen)) || (txtlen+i1>=sizeof(txt))) {
        strcpy(errmsg,"too much text for language settings");
        fclose(flg);
        return(-1);
      }
      txtlen+=i1;
    }
    fclose(flg);
    i1=snprintf(txt+txtlen,sizeof(txt)-txtlen,"? ");
    if ((i1==-1) || (i1>=(int)(sizeof(txt)-txtlen)) || (txtlen+i1>=sizeof(txt))) {
      strcpy(errmsg,"too much text for language settings");
      return(-1);
    }
    grf=text_to_grafik(RGB_WHITE,RGB_BLACK,4,0,txt);
    copy_grafik(NULL,(SC_WIDTH-GRAFIK_WIDTH(grf))/2,(SC_HEIGHT-GRAFIK_HEIGHT(grf))/2,grf,0,0,0,0,RGB_FULL);
    free_grafik(grf);
    langnr=1;
    if (lnr>1) {
      int * svk;
      SAVE_KEYS(svk);
      CLEAR_KEYS;
      if (lnr>=1) {ADD_KEYS(KEY_1,SHORT_KEY); ADD_KEYS(KEY_KP_1,SHORT_KEY);}
      if (lnr>=2) {ADD_KEYS(KEY_2,SHORT_KEY); ADD_KEYS(KEY_KP_2,SHORT_KEY);}
      if (lnr>=3) {ADD_KEYS(KEY_3,SHORT_KEY); ADD_KEYS(KEY_KP_3,SHORT_KEY);}
      if (lnr>=4) {ADD_KEYS(KEY_4,SHORT_KEY); ADD_KEYS(KEY_KP_4,SHORT_KEY);}
      if (lnr>=5) {ADD_KEYS(KEY_5,SHORT_KEY); ADD_KEYS(KEY_KP_5,SHORT_KEY);}
      if (lnr>=6) {ADD_KEYS(KEY_6,SHORT_KEY); ADD_KEYS(KEY_KP_6,SHORT_KEY);}
      if (lnr>=7) {ADD_KEYS(KEY_7,SHORT_KEY); ADD_KEYS(KEY_KP_7,SHORT_KEY);}
      if (lnr>=8) {ADD_KEYS(KEY_8,SHORT_KEY); ADD_KEYS(KEY_KP_8,SHORT_KEY);}
      if (lnr>=9) {ADD_KEYS(KEY_9,SHORT_KEY); ADD_KEYS(KEY_KP_9,SHORT_KEY);}
      flush_window();
      /* key input */
      while (1) {
        wait_time(50);
        get_keys();
        if ((IS_KEYS(KEY_1)) || (IS_KEYS(KEY_KP_1))) {langnr=1; break;}
        if ((IS_KEYS(KEY_2)) || (IS_KEYS(KEY_KP_2))) {langnr=2; break;}
        if ((IS_KEYS(KEY_3)) || (IS_KEYS(KEY_KP_3))) {langnr=3; break;}
        if ((IS_KEYS(KEY_4)) || (IS_KEYS(KEY_KP_4))) {langnr=4; break;}
        if ((IS_KEYS(KEY_5)) || (IS_KEYS(KEY_KP_5))) {langnr=5; break;}
        if ((IS_KEYS(KEY_6)) || (IS_KEYS(KEY_KP_6))) {langnr=6; break;}
        if ((IS_KEYS(KEY_7)) || (IS_KEYS(KEY_KP_7))) {langnr=7; break;}
        if ((IS_KEYS(KEY_8)) || (IS_KEYS(KEY_KP_8))) {langnr=8; break;}
        if ((IS_KEYS(KEY_9)) || (IS_KEYS(KEY_KP_9))) {langnr=9; break;}
      }
      flush_window();
      RESTORE_KEYS(svk);
    }
    CLEAR_BOX(NULL,RGB_BLACK);
    flush_window();
    snprintf(sfil,sizeof(sfil),"%s/%s",set_path,LANG_CFG);
    if ((lstat(sfil,&sbuf)<0) || ((sbuf.st_mode&S_IFMT)==S_IFREG)) {
      if ((flg=fopen(sfil,"w"))!=NULL) {
        fprintf(flg,"%d\n",langnr);
        fchmod(fileno(flg),0666);
        fclose(flg);
      }
    }
  } else {
    if (fgets(buf,sizeof(buf),flg)==NULL) {
      snprintf(errmsg,sizeof(errmsg),"cannot read from %s",LANG_CFG);
      fclose(flg);
      return(-1);
    }
    langnr=atoi(buf);
    fclose(flg);
  }
  return(langnr);
} /* Ende init_language */


int init_volume(const char * set_path,int * volfld,int * vmain,int * vpcm) {
/* load saved sound volume or have it set and save it
** (open_window() and init_sound() must have been called)
** 1.arg: pathname to "sound setting directory"
** 2.arg: "volume field" for returning volume values
** 3.arg: address for previous main volume (for restoring before exit)
** 4.arg: address for previous pcm volume (for restoring before exit)
** return value: 0=OK or -1=error (errmsg is set)
*/
  const char pvor[]="-------------------------------",pnach[]="+++++++++++++++++++++++++++++++";
  char sfil[512],buf[1024],* p1,* p2,* p3;
  FILE * fchn,* fsnd;
  struct stat sbuf;
  int czl,i1;

  if ((set_path==NULL) || (volfld==NULL)) {
    strcpy(errmsg,"argument NULL");
    return(-1);
  }
  if (vmain!=NULL) {*vmain=set_vol(-1,0);}
  if (vpcm!=NULL) {*vpcm=set_vol(-1,1);}
  memset(channel_nr,0,sizeof(channel_nr));
  for (czl=0;czl<=8;czl++) {s_text[czl][0]='\0';}
  c_anz=0;

  /* load test sounds */
  {DIR * dirp;
   struct dirent * dptr;
   int idx;
   memset(test_sound_nr,0,sizeof(test_sound_nr));
   if ((dirp=opendir(set_path))==NULL) {
     snprintf(errmsg,sizeof(errmsg),"cannot opendir %s",set_path);
     return(-1);
   }
   while ((dptr=readdir(dirp))!=NULL) {
     if (*dptr->d_name=='.') {continue;}
     if (strchr("012345678",*dptr->d_name)==NULL) {continue;}
     if (dptr->d_name[1]!='.') {continue;}
     idx=*dptr->d_name-'0';
     if (test_sound_nr[idx]!=0) {continue;}
     snprintf(sfil,sizeof(sfil),"%s/%s",set_path,dptr->d_name);
     if ((test_sound_nr[idx]=load_wave(sfil,TYP_IS_EXTENSION))==0) {
       closedir(dirp);
       return(0);  /* no soundcard? */
     }
   }
   closedir(dirp);
  }

  /* read values from chn.table and sndvol.cfg */
  snprintf(sfil,sizeof(sfil),"%s/%s.%d",set_path,CHN_TABLE,langnr);
  if ((fchn=fopen(sfil,"r"))==NULL) {
    snprintf(errmsg,sizeof(errmsg),"cannot open %s",sfil);
    return(-1);
  }
  snprintf(sfil,sizeof(sfil),"%s/%s",set_path,SNDVOL_CFG);
  if ((fsnd=fopen(sfil,"r"))==NULL) {  /* have main volume set */
    const int plen=30;
    int volg,v0,v1,* svk,setmain;
    v0=set_vol(-1,0);
    v1=set_vol(-1,1);
    volg=(v0+v1)/2;
    if (volg<0) {volg=0;}
    SAVE_KEYS(svk);
    CLEAR_KEYS;
    ADD_KEYS(KEY_RCURS,LONG_KEY);
    ADD_KEYS(KEY_LCURS,LONG_KEY);
    ADD_KEYS(KEY_KP_4,LONG_KEY);
    ADD_KEYS(KEY_KP_6,LONG_KEY);
    ADD_KEYS(KEY_ENTER,SHORT_KEY);
    play_wave(test_sound_nr[1],CN_ALL,1,0);
    set_font(NULL,0,0);
    setmain=0;
    while (1) {
      CLEAR_BOX(NULL,RGB_BLACK);
      draw_text(NULL,RGB_WHITE,(SC_WIDTH-20*8)/2,30,"Please adjust volume",20,RGB_FULL);
      snprintf(buf,sizeof(buf),"|%.*sX%.*s|",plen*volg/100,pvor,plen-plen*volg/100,pnach);
      v0=strlen(buf);
      draw_text(NULL,RGB_WHITE,(SC_WIDTH-v0*8)/2,60,buf,v0,RGB_FULL);
      draw_text(NULL,RGB_WHITE,(SC_WIDTH-v0*8)/2,110,"[<-] and [->]: set volume",25,RGB_FULL);
      draw_text(NULL,RGB_WHITE,(SC_WIDTH-v0*8)/2,122,"[RETURN]:      OK",17,RGB_FULL);
      flush_window();
      /* key input */
      while (1) {
        if (setmain==1) {set_vol(volg,0); set_vol(volg,1);}
        if (setmain>0) {setmain--;}
        wait_time(50);
        get_keys();
        if (IS_KEYS(KEY_ENTER)) {break;}
        if ((IS_KEYS(KEY_LCURS)) || (IS_KEYS(KEY_KP_4))) {
          if (--volg>=0) {
            setmain=2;
          } else {volg=0;}
          break;
        }
        if ((IS_KEYS(KEY_RCURS)) || (IS_KEYS(KEY_KP_6))) {
          if (++volg<=100) {
            setmain=2;
          } else {volg=100;}
          break;
        }
      }
      if (IS_KEYS(KEY_ENTER)) {break;}
    }
    stop_wave(CN_ALL,0);
    CLEAR_BOX(NULL,RGB_BLACK);
    flush_window();
    RESTORE_KEYS(svk);
    volfld[0]=volg;
  } else {
    if (fgets(buf,sizeof(buf),fsnd)==NULL) {
      snprintf(errmsg,sizeof(errmsg),"cannot read from %s",SNDVOL_CFG);
      fclose(fsnd);
      return(-1);
    }
    volfld[0]=atoi(buf);
    if (volfld[0]<0) {volfld[0]=0;}
    if (volfld[0]>100) {volfld[0]=100;}
  }
  for (czl=0;czl<=8;) {  /* read channel values */
    if (fgets(buf,sizeof(buf),fchn)==NULL) {break;}
    if ((p1=strchr(buf,'#'))!=NULL) {*p1='\0';}
    if ((p3=strchr(buf,':'))==NULL) {continue;} else {*p3='\0';}
    if (czl==0) {
      for (p1=p3+1;((*p1==' ')||(*p1=='\t'));p1++) {;}
      if ((i1=strlen(p1)-1)>9) {i1=9;}
      p1[i1]='\0';  /* chop newline */
      memset(s_text[czl],' ',9);
      strncpy(s_text[czl],p1,i1); s_text[czl][9]=':'; s_text[czl][10]='\0';
    } else {
      for (p1=buf,p2=strchr(p1,',');;p1=p2+1,p2=strchr(p1,',')) {
        if (p2!=NULL) {*p2='\0';}
        if (((i1=atoi(p1))>0) && (i1<=8)) {channel_nr[czl]|=CN_(i1);}
        if (p2==NULL) {break;}
      }
      for (p1=p3+1;((*p1==' ')||(*p1=='\t'));p1++) {;}
      if ((i1=strlen(p1)-1)>9) {i1=9;}
      p1[i1]='\0';  /* chop newline */
      memset(s_text[czl],' ',9);
      strncpy(s_text[czl],p1,i1); s_text[czl][9]=':'; s_text[czl][10]='\0';
      if (fsnd!=NULL) {
        if (fgets(buf,sizeof(buf),fsnd)==NULL) {
          volfld[czl]=10;
        } else {
          volfld[czl]=atoi(buf);
          if (volfld[czl]<0) {volfld[czl]=0;}
          if (volfld[czl]>30) {volfld[czl]=30;}
        }
      } else {volfld[czl]=10;}
    }
    czl++;
  }
  c_anz=czl-1;
  fclose(fchn);
  if (fsnd!=NULL) {fclose(fsnd);}
  snprintf(sfil,sizeof(sfil),"%s/%s",set_path,SNDVOL_CFG);
  if ((lstat(sfil,&sbuf)<0) || ((sbuf.st_mode&S_IFMT)==S_IFREG)) {
    if ((fsnd=fopen(sfil,"w"))!=NULL) {  /* write values back */
      for (czl=0;czl<=c_anz;czl++) {fprintf(fsnd,"%d\n",volfld[czl]);}
      fchmod(fileno(fsnd),0666);
      fclose(fsnd);
    }
  }
  /* set volume */
  set_vol(volfld[0],0);
  set_vol(volfld[0],1);
  for (czl=1;czl<=c_anz;czl++) {volume_wave(channel_nr[czl],volfld[czl]);}
  return(0);
} /* Ende init_volume */


void menu_volume(const char * set_path,int * volfld) {
/* adjust and save volume (main and all channels)
** (init_volume() must have been called)
** 1.arg: pathname to "sound setting directory"
** 2.arg: "volume field" for returning volume values
*/
  const char pvor[]="--------------------",pnach[]="++++++++++++++++++++";
  const int plen=15;
  const int x1=20,y1=10,x2=SC_WIDTH-40,y2=SC_HEIGHT-10;
  int x0,y0,mnr,czl,col[2],zhl,setmain;
  char buf[512],* svk;
  col[0]=color_index(CL_YELLOW,50);
  col[1]=color_index(CL_YELLOW,100);
  if (groben==NULL) {
    int i1,i2,pos;
    if ((groben=create_grafik(26,10))==NULL) {return;}
    draw_fillbox(groben,0,3,3,4,RGB_WHITE);
    draw_line(groben,2,3,7,0,RGB_WHITE);
    draw_line(groben,2,6,7,9,RGB_WHITE);
    draw_line(groben,8,0,8,9,RGB_WHITE);
    pos=15;
    for (i1=0;i1<3;i1++) {
      i2=pos+i1*4;
      draw_pixel(groben,2+i2,4,RGB_WHITE); draw_pixel(groben,2+i2,5,RGB_WHITE);
      draw_pixel(groben,1+i2,2,RGB_WHITE); draw_pixel(groben,1+i2,3,RGB_WHITE);
      draw_pixel(groben,1+i2,6,RGB_WHITE); draw_pixel(groben,1+i2,7,RGB_WHITE);
      draw_pixel(groben,0+i2,0,RGB_WHITE); draw_pixel(groben,0+i2,1,RGB_WHITE);
      draw_pixel(groben,0+i2,8,RGB_WHITE); draw_pixel(groben,0+i2,9,RGB_WHITE);
    }
  }
  SAVE_KEYS(svk);
  CLEAR_KEYS;
  ADD_KEYS(KEY_RCURS,LONG_KEY);
  ADD_KEYS(KEY_LCURS,LONG_KEY);
  ADD_KEYS(KEY_UCURS,SHORT_KEY);
  ADD_KEYS(KEY_DCURS,SHORT_KEY);
  ADD_KEYS(KEY_KP_4,LONG_KEY);
  ADD_KEYS(KEY_KP_6,LONG_KEY);
  ADD_KEYS(KEY_KP_8,SHORT_KEY);
  ADD_KEYS(KEY_KP_2,SHORT_KEY);
  ADD_KEYS(KEY_ENTER,SHORT_KEY);

  mnr=1;
  stop_wave(CN_ALL,0);
  play_wave(test_sound_nr[mnr],channel_nr[mnr],1,0);
  zhl=0;
  setmain=0;
  while (1) {
    MENU_BILD(x1,y1,x2,y2,y0);
    x0=x1+20; y0+=5;
    snprintf(buf,sizeof(buf),"%-10s|%.*sX%.*s|",s_text[0],plen*volfld[0]/100,pvor,plen-plen*volfld[0]/100,pnach);
    draw_text(NULL,col[mnr==1?1:0],x0,y0,buf,strlen(buf),RGB_TRANS);
    y0+=8+10;
    for (czl=1;czl<=c_anz;czl++) {
      snprintf(buf,sizeof(buf),"%-10s|%.*sX%.*s|",s_text[czl],plen*volfld[czl]/30,pvor,plen-plen*volfld[czl]/30,pnach);
      draw_text(NULL,col[mnr==czl+1?1:0],x0,y0,buf,strlen(buf),RGB_TRANS);
      y0+=8+5;
    }
    y0+=5;
    strcpy(buf,"<<< <<< <<<");
    draw_text(NULL,col[mnr==c_anz+2?1:0],x0,y0,buf,strlen(buf),RGB_TRANS);
    y0+=8+5;
    flush_window();
    /* key input */
    while (1) {
      if (setmain==1) {set_vol(volfld[0],0); set_vol(volfld[0],1);}
      if (setmain>0) {setmain--;}
      if (zhl>0) {
        if (++zhl==15) {
          play_wave(test_sound_nr[mnr-1],channel_nr[mnr-1],1,0);
          zhl=0;
        }
      }
      wait_time(50);
      get_keys();
      if ((mnr==c_anz+2) && (IS_KEYS(KEY_ENTER))) {
        char sfil[512];
        struct stat sbuf;
        FILE * fsnd;
        stop_wave(CN_ALL,0);
        snprintf(sfil,sizeof(sfil),"%s/%s",set_path,SNDVOL_CFG);
        if ((lstat(sfil,&sbuf)<0) || ((sbuf.st_mode&S_IFMT)==S_IFREG)) {
          if ((fsnd=fopen(sfil,"w"))!=NULL) {  /* write values back */
            for (czl=0;czl<=c_anz;czl++) {fprintf(fsnd,"%d\n",volfld[czl]);}
            fchmod(fileno(fsnd),0666);
            fclose(fsnd);
          }
        }
        RESTORE_KEYS(svk);
        return;
      }
      if ((IS_KEYS(KEY_UCURS)) || (IS_KEYS(KEY_KP_8))) {
        if (--mnr<=1) {
          mnr=1;
          if (zhl>0) {play_wave(test_sound_nr[mnr],channel_nr[mnr],1,0);}
          zhl=0;
        } else {
          stop_wave(CN_ALL,0);
          zhl=1;
        }
        break;
      }
      if ((IS_KEYS(KEY_DCURS)) || (IS_KEYS(KEY_KP_2))) {
        if (++mnr>=c_anz+2) {
          mnr=c_anz+2;
          zhl=0;
        } else {
          stop_wave(CN_ALL,0);
          zhl=1;
        }
        break;
      }
      if ((IS_KEYS(KEY_LCURS)) || (IS_KEYS(KEY_KP_4))) {
        if (mnr<=c_anz+1) {
          if (--volfld[mnr-1]>=0) {
            if (mnr==1) {setmain=2;}
            else {volume_wave(channel_nr[mnr-1],volfld[mnr-1]);}
          } else {volfld[mnr-1]=0;}
        }
        break;
      }
      if ((IS_KEYS(KEY_RCURS)) || (IS_KEYS(KEY_KP_6))) {
        if (mnr<=c_anz+1) {
          if (mnr==1) {
            if (++volfld[0]<=100) {
              setmain=2;
            } else {volfld[0]=100;}
          } else {
            if (++volfld[mnr-1]<=30) {
              volume_wave(channel_nr[mnr-1],volfld[mnr-1]);
            } else {volfld[mnr-1]=30;}
          }
        }
        break;
      }
    }
  }
  RESTORE_KEYS(svk);
} /* Ende menu_volume */
