#ifndef SOUND_SET_H_
#define SOUND_SET_H_

/* Global sound and language setting functions
**
** There are 2 common values you have to pass to each sound-set function:
**  - pathname to "sound setting directory":
**     the directory where are all sound setting files incl. test sound
**  - "volume field":
**     integer field containing main volume and volume values of all (joined)
**     channels. E.g. if channel 1 and 2 are used for sound effects, you need
**     only one integer value for them. Index 0 is main volume.
**
** Files in "sound setting directory":
**  - lang.table: (must be created manually)
**       for selecting language-number
**       Format per line:  <language name>
**       (up to 9 languages are valid)
**       Example:
**         deutsch
**         english
**         latin
**        --->
**          if selected "deutsch", language-number becomes 1 (1st line)
**          if selected "english", language-number becomes 2 (2nd line)
**          if selected "latin", language-number becomes 3 (3rd line)
**  - lang.cfg: contains saved language-number
**  - chn.table.<language-number>: (must be created manually)
**       contains channel information
**       Format:
**        - first line defines main volume:
**          0: <text up to 9 characters>
**        - following lines define channel volumes:
**          <chn-number>[,<chn-number>[...]]: <text up to 9 characters>
**       Example:
**         0: main
**         1,2,3: sound
**         4: music
**         5,6: speech
**        --->
**           at channel 1,2 and 3 there will be played sound effects,
**           setting their channel volume will set all three channels;
**           at channel 4 there will be played music;
**           at channel 5 and 6 there will be played blabla,
**           setting their channel volume will set all two channels;
**           channel 7 and 8 are unused.
**           In this example you have 3 lines, therefore "volume field"
**           must be declared at least as integer[4]:
**             0=main volume
**             1=sound volume (channel 1,2,3)
**             2=music volume (channel 4)
**             3=speech volume (channel 5,6)
**           but it is recommended to declare it as integer[9], which
**           is the maximum, and use only index 0 to 3.
**  - sndvol.cfg: contains saved volume values
**  - {1-8}.{wav|mid|mp3}: test sounds for each volume in "volume field"
**
** Example:
**   chn.table.0 contains:
**     0: main
**     1,2,3: sound
**     4: music
**     5,6: speech
**   there are test sounds:
**     1.wav  (for sound effect channel volume)
**     2.mid  (for music channel volume)
**     3.wav  (for speech channel volume)
**   "volume field" is declared vf[4] and contains:
**     vf[0]=main volume
**     vf[1]=sound effect channel volume
**     vf[2]=music channel volume
**     vf[3]=speech channel volume
**
** Functions:
**  - init_language(): if no lang.cfg exists: have language-number set,
**                     return language-number
**  - init_volume(): if no sndvol.cfg exists: have main sound volume set,
**                   set volume and return saved volume values
**  - menu_volume(): set volumes from menu
*/


/* - init_language:
** initialilly set or load saved language-number
** 1.arg: pathname to "sound setting directory"
** return value: >0: language-number
**               -1: error (errmsg is set)
*/
extern int init_language(const char *);


/* - init_volume:
**   load saved sound volume or have it set and save it
**   (open_window() and init_sound() must have been called)
**   1.arg: pathname to "sound setting directory"
**   2.arg: "volume field" for returning volume values
**   3.arg: address for previous main volume (for restoring before exit)
**   4.arg: address for previous pcm volume (for restoring before exit)
**   return value: 0=OK or -1=error (errmsg is set)
*/
extern int init_volume(const char *,int *,int *,int *);


/* - menu_volume:
**   adjust and save volume (main and all channels)
**   (init_volume() must have been called)
**   1.arg: pathname to "sound setting directory"
**   2.arg: "volume field" for returning volume values
*/
extern void menu_volume(const char *,int *);


#endif /* SOUND_SET_H_ */
