/* gcc -Wall `vgag-config.sh -cons zufposter.c ` -o zufposter
** chown root:root zufposter && chmod 4755 zufposter
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <vgagames.h>

#define ZUFALL(Z)  ((int)((float)(Z)*rand()/(RAND_MAX+1.0)))
#define ZWISCHEN_X 3
#define ZWISCHEN_Y 3


int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  grafik * bgr,** grf,* grz;
  int igz,i0,i1,i2,i3,v1,v2,* v3,* grw,* grh,ganz;
  int z1,z2,z3,z4;
  int ** fx,** fy;
  char buf[64],** gnam;
  FILE * ffp;
  float f1;

  if ((argc<5) || (argc/2==0)) {
    fprintf(stderr,"usage: %s <no. of screens hor.> <no. of screens vert.> <number> <graphic> [<number> <graphic> ...]\n",argv[0]);
    exit(1);
  }

  srand(time(NULL)%1000);
  if (open_window("Zufposter",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  if (((v1=atoi(argv[1]))<1) || ((v2=atoi(argv[2]))<1)) {
    *errmsg='\0';
    end_err(argv[0],"argument invalid");
  }
  v1*=SC_WIDTH;
  v2*=SC_HEIGHT;
  if ((bgr=create_grafik(v1,v2))==NULL) {
    end_err(argv[0],"creating background graphic");
  }
  CLEAR_BOX(bgr,RGB_WHITE);
  if ((grz=create_grafik(SC_WIDTH+5,SC_HEIGHT+5))==NULL) {
    end_err(argv[0],"creating zoomed graphic");
  }
  CLEAR_BOX(grz,RGB_WHITE);
  ganz=0;
  if (((v3=malloc(sizeof(int)))==NULL) || ((grf=malloc(sizeof(*grf)))==NULL) \
  || ((grw=malloc(sizeof(int)))==NULL) || ((grh=malloc(sizeof(int)))==NULL) \
  || ((gnam=malloc(sizeof(char *)))==NULL) \
  || ((fx=malloc(sizeof(int)))==NULL) || ((fy=malloc(sizeof(int)))==NULL)) {
    end_err(argv[0],"malloc v3/grf/grw/grh/gnam/fx/fy");
  }
  for (i1=3;i1<argc;i1+=2) {
    ganz++;
    if (((v3=realloc(v3,sizeof(int)*ganz))==NULL) || ((grf=realloc(grf,sizeof(*grf)*ganz))==NULL) \
    || ((grw=realloc(grw,sizeof(int)*ganz))==NULL) || ((grh=realloc(grh,sizeof(int)*ganz))==NULL) \
    || ((gnam=realloc(gnam,sizeof(char *)*ganz))==NULL) \
    || ((fx=realloc(fx,sizeof(int)*ganz))==NULL) || ((fy=realloc(fy,sizeof(int)*ganz))==NULL)) {
      end_err(argv[0],"realloc v3/grf/grw/grh/gnam/fx/fy");
    }
    v3[ganz-1]=atoi(argv[i1]);
    if ((grf[ganz-1]=load_grafik(argv[i1+1]))==NULL) {
      end_err(argv[0],"loading foreground graphic");
    }
    if ((gnam[ganz-1]=strrchr(argv[i1+1],'/'))==NULL) {gnam[ganz-1]=argv[i1+1];} else {gnam[ganz-1]++;}
    grw[ganz-1]=GRAFIK_WIDTH(grf[ganz-1]);
    grh[ganz-1]=GRAFIK_HEIGHT(grf[ganz-1]);
    if (((fx[ganz-1]=malloc(sizeof(int)*v3[ganz-1]))==NULL) \
    || ((fy[ganz-1]=malloc(sizeof(int)*v3[ganz-1]))==NULL)) {
      strcpy(errmsg,"allocation error");
      end_err(argv[0],"creating fx/fy");
    }
  }

  alarm(30);
  for (igz=0;igz<ganz;igz++) {
    for (i0=0;i0<v3[igz];i0++) {
      i3=0;
_again:
      if (get_space(1)) {
        *errmsg='\0';
        end_err(argv[0],"key stroke");
      }
      CLEAR_BOX(NULL,RGB_BLACK);
      i2=sprintf(buf,"%d:%d(%d)",igz+1,i0+1,++i3);
      draw_text(NULL,RGB_WHITE,SC_WIDTH/2-4*i2,SC_HEIGHT/2-4,buf,i2,RGB_FULL);
      flush_window();
      fx[igz][i0]=ZUFALL(v1-grw[igz]);
      fy[igz][i0]=ZUFALL(v2-grh[igz]);
      for (i1=0;i1<=igz;i1++) {
        for (i2=0;i2<(i1==igz?i0:v3[i1]);i2++) {
          if ((fx[igz][i0]>=fx[i1][i2]-grw[igz]-ZWISCHEN_X) && (fx[igz][i0]<=fx[i1][i2]+grw[i1]+ZWISCHEN_X) && (fy[igz][i0]>=fy[i1][i2]-grh[igz]-ZWISCHEN_Y) && (fy[igz][i0]<=fy[i1][i2]+grh[i1]+ZWISCHEN_Y)) {break;}
        }
        if (i2<(i1==igz?i0:v3[i1])) {break;}
      }
      if (i1<=igz) {goto _again;}
      copy_grafik(bgr,fx[igz][i0],fy[igz][i0],grf[igz],0,0,0,0,RGB_TRANS);
    }
  }
  alarm(0);
  z1=z2=z3=z4=0;
  f1=(1./(float)(v1/SC_WIDTH)<1./(float)(v2/SC_HEIGHT)?1./(float)(v1/SC_WIDTH):1./(float)(v2/SC_HEIGHT));
  zoom_grafik(grz,bgr,f1,f1,&z1,&z2,&z3,&z4);
  CLEAR_BOX(NULL,RGB_BLACK);
  copy_grafik(NULL,0,0,grz,0,0,0,0,RGB_FULL);
  flush_window();
  for (igz=0;igz<ganz;igz++) {
    printf("%d.graphic width,height: %d,%d\n",igz+1,GRAFIK_WIDTH(grf[igz]),GRAFIK_HEIGHT(grf[igz]));
  }
  get_space(0);

  unlink("/tmp/_3plane.xy");
  if ((ffp=fopen("/tmp/_3plane.xy","w"))!=NULL) {
    fprintf(ffp,"# %dx%d\n",v1/SC_WIDTH,v2/SC_HEIGHT);
    for (igz=0;igz<ganz;igz++) {
      fprintf(ffp,"$W20=%s\n",gnam[igz]);
      for (i0=0;i0<v3[igz];i0++) {
        fprintf(ffp,"$W21=%d-$1,%d-$2,t\n",fx[igz][i0],fy[igz][i0]);
      }
      fprintf(ffp,"\n");
    }
    fclose(ffp);
    printf("Saved in file: /tmp/_3plane.xy\n");
  }

  free_grafik(bgr);
  free_grafik(grz);

  close_window();
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
