/* *****************************************************************
   baller: demo game for vgagames
   Copyright (C) 2002 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   ***************************************************************** */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <vgagames.h>
#include "baller.h"

int intro(void);
int extro(void);
void runde(void);
void neu_feind(int,int,int);
int treffer(int,int,int,int,int,int,int,int,int,int);
void bonus(void);
void end_err(char *);

schiff ich;
feind du[FEIND_MAX];
stern es[STERN_MAX];
grafik * ballergr,* feindgr[3][3],* schussgr,* rakete,* ichklein;
int trefanz,volm,musik;
int wave_nr[3+MIDIMUSIK_ANZ];

int main(int argc,char ** argv) {
  int i1,i2;

  /* +++ Initialisierung +++ */
  srand(time(NULL)%1000);
  i1=0;
#ifdef WINDOW_RESIZABLE
  printf("Usage: %s [-1 to -4] [-f]\n",argv[0]);
  if (argc>=2) {
    int n1,n2;
    n1=n2=0;
    if (strcmp(argv[1],"-f")==0) {n2=VGAWINDOW_FULL;}
    else {n1=atoi(argv[1]+1);}
    if (argc>=3) {
      if (strcmp(argv[2],"-f")==0) {n2=VGAWINDOW_FULL;}
      else {n1=atoi(argv[2]+1);}
    }
    if (n1==1) {i1=VGAWINDOW_1;}
    else if (n1==2) {i1=VGAWINDOW_2;}
    else if (n1==3) {i1=VGAWINDOW_3;}
    else if (n1==4) {i1=VGAWINDOW_4;}
    i1+=n2;
  }
#endif
  if (open_window("Baller",i1)!=0) {fprintf(stderr,"%s\n",errmsg); exit(1);}
  if (init_sound(11025,0)!=0) {end_err(errmsg);}
  wave_nr[0]=load_wave(FEIND_TREFF,TYP_IS_WAVE);
  wave_nr[1]=load_wave(SCHIFF_TREFF,TYP_IS_WAVE);
  wave_nr[2]=load_wave(RAKETE_LOS,TYP_IS_WAVE);
  for (i1=1;i1<=MIDIMUSIK_ANZ;i1++) {
    wave_nr[2+i1]=load_wave(midimusik[i1-1],TYP_IS_MIDI);
  }
  volume_wave(CN_(1),4);  /* Musik 40% */
  volume_wave(CN_(2)|CN_(3)|CN_(4),15);  /* Sound 150% */
  accel_wave(0,0);  /* falls noetig */

  /* +++ Intro-Grafik laden +++ */
  if ((ballergr=load_grafik(BALLERGRA))==NULL) {end_err("Grafik laden");}

  /* +++ Schiff laden +++ */
  if ((ich.gr=load_grafik(SCHIFFGRA))==NULL) {end_err("Grafik laden");}
  ich.xr=SC_WIDTH-GRAFIK_WIDTH(ich.gr);
  ich.xl=5;
  ich.yo=0;
  ich.yu=SC_HEIGHT-10-GRAFIK_HEIGHT(ich.gr);
  ich.sxr=SC_WIDTH;
  if ((ichklein=load_grafik(SCHIFKGRA))==NULL) {end_err("Grafik laden");}
  /* Schussgrafik erstellen */
  if ((ich.sgr=create_grafik(25,2))==NULL) {end_err("Grafik erstellen");}
  draw_line(ich.sgr,0,0,GRAFIK_WIDTH(ich.sgr)-1,0,color_index(CL_ORANGE,100));
  draw_line(ich.sgr,0,1,GRAFIK_WIDTH(ich.sgr)-1,1,color_index(CL_ORANGE,100));

  /* +++ Feinde laden +++ */
  if ((feindgr[2][0]=load_grafik(FEIND1GRA))==NULL) {end_err("Grafik laden");}
  /* Grafikfarbe modifizieren und Grafik kopieren */
  {int w,h,c;
   w=GRAFIK_WIDTH(feindgr[2][0]);
   h=GRAFIK_HEIGHT(feindgr[2][0]);
   if ((feindgr[1][0]=create_grafik(w,h))==NULL) {end_err("Grafik erstellen");}
   copy_grafik(feindgr[1][0],0,0,feindgr[2][0],0,0,0,0,RGB_FULL);
   if ((feindgr[0][0]=create_grafik(w,h))==NULL) {end_err("Grafik erstellen");}
   copy_grafik(feindgr[0][0],0,0,feindgr[2][0],0,0,0,0,RGB_FULL);
   for (i1=0;i1<w;i1++) {
     for (i2=0;i2<w;i2++) {
       c=get_pixel(feindgr[2][0],i1,i2);
       if (c==color_index(CL_YELLOW,100)) {
         draw_pixel(feindgr[1][0],i1,i2,color_index(CL_RED,100));
         draw_pixel(feindgr[0][0],i1,i2,color_index(CL_BLUE,100));
       }
     }
   }
  }
  if ((feindgr[2][1]=load_grafik(FEIND2GRA))==NULL) {end_err("Grafik laden");}
  /* Grafikfarbe modifizieren und Grafik kopieren */
  {int w,h,c;
   w=GRAFIK_WIDTH(feindgr[2][1]);
   h=GRAFIK_HEIGHT(feindgr[2][1]);
   if ((feindgr[1][1]=create_grafik(w,h))==NULL) {end_err("Grafik erstellen");}
   copy_grafik(feindgr[1][1],0,0,feindgr[2][1],0,0,0,0,RGB_FULL);
   if ((feindgr[0][1]=create_grafik(w,h))==NULL) {end_err("Grafik erstellen");}
   copy_grafik(feindgr[0][1],0,0,feindgr[2][1],0,0,0,0,RGB_FULL);
   for (i1=0;i1<w;i1++) {
     for (i2=0;i2<w;i2++) {
       c=get_pixel(feindgr[2][1],i1,i2);
       if (c==color_index(CL_YELLOW,100)) {
         draw_pixel(feindgr[1][1],i1,i2,color_index(CL_RED,100));
         draw_pixel(feindgr[0][1],i1,i2,color_index(CL_BLUE,100));
       }
     }
   }
  }
  if ((feindgr[2][2]=load_grafik(FEIND3GRA))==NULL) {end_err("Grafik laden");}
  /* Grafikfarbe modifizieren und Grafik kopieren */
  {int w,h,c;
   w=GRAFIK_WIDTH(feindgr[2][2]);
   h=GRAFIK_HEIGHT(feindgr[2][2]);
   if ((feindgr[1][2]=create_grafik(w,h))==NULL) {end_err("Grafik erstellen");}
   copy_grafik(feindgr[1][2],0,0,feindgr[2][2],0,0,0,0,RGB_FULL);
   if ((feindgr[0][2]=create_grafik(w,h))==NULL) {end_err("Grafik erstellen");}
   copy_grafik(feindgr[0][2],0,0,feindgr[2][2],0,0,0,0,RGB_FULL);
   for (i1=0;i1<w;i1++) {
     for (i2=0;i2<w;i2++) {
       c=get_pixel(feindgr[2][2],i1,i2);
       if (c==color_index(CL_YELLOW,100)) {
         draw_pixel(feindgr[1][2],i1,i2,color_index(CL_RED,100));
         draw_pixel(feindgr[0][2],i1,i2,color_index(CL_BLUE,100));
       }
     }
   }
  }
  /* Schussgrafik erstellen */
  if ((schussgr=create_grafik(10,2))==NULL) {end_err("Grafik erstellen");}
  draw_line(schussgr,0,0,GRAFIK_WIDTH(schussgr)-1,0,color_index(CL_BLUEVIOLET,100));
  draw_line(schussgr,0,1,GRAFIK_WIDTH(schussgr)-1,1,color_index(CL_BLUEVIOLET,100));
  /* Raketengrafik erstellen */
  if ((rakete=create_grafik(25,5))==NULL) {end_err("Grafik erstellen");}
  draw_line(rakete,GRAFIK_WIDTH(rakete)-9,0,GRAFIK_WIDTH(rakete)-1,0,color_index(CL_WHITE,60));
  draw_line(rakete,2,1,GRAFIK_WIDTH(rakete)-3,1,color_index(CL_PINK,100));
  draw_line(rakete,0,2,2,2,color_index(CL_WHITE,60));
  draw_line(rakete,3,2,GRAFIK_WIDTH(rakete)-10,2,color_index(CL_PINK,100));
  draw_line(rakete,GRAFIK_WIDTH(rakete)-9,2,GRAFIK_WIDTH(rakete)-1,2,color_index(CL_WHITE,60));
  draw_line(rakete,2,3,GRAFIK_WIDTH(rakete)-3,3,color_index(CL_PINK,100));
  draw_line(rakete,GRAFIK_WIDTH(rakete)-9,4,GRAFIK_WIDTH(rakete)-1,4,color_index(CL_WHITE,60));
  /* allg. Feindwerte */
  for (i1=0;i1<FEIND_MAX;i1++) {
    du[i1].xr=SC_WIDTH;
    du[i1].xl=0-GRAFIK_WIDTH(feindgr[0][0]);
    du[i1].yo=0-GRAFIK_HEIGHT(feindgr[0][0]);
    du[i1].yu=SC_HEIGHT-10;
  }

  /* +++ Runden ausfuehren +++ */
  clearstate();
  volm=set_vol(-1,0);
  while (1) {
    if (intro()==1) {break;}
    runde();
    if (extro()==1) {break;}
    stop_wave(CN_(1),0);
  }

  /* +++ Ende +++ */
  free_grafik(rakete);
  free_grafik(schussgr);
  free_grafik(feindgr[2][2]);
  free_grafik(feindgr[2][1]);
  free_grafik(feindgr[2][0]);
  free_grafik(feindgr[1][2]);
  free_grafik(feindgr[1][1]);
  free_grafik(feindgr[1][0]);
  free_grafik(feindgr[0][2]);
  free_grafik(feindgr[0][1]);
  free_grafik(feindgr[0][0]);
  free_grafik(ichklein);
  free_grafik(ich.gr);
  free_grafik(ballergr);
  end_sound();
  close_window();
  exit(0);
} /* Ende main */


int intro() {
  int poza,tcol,i1,i2;
  CLEAR_KEYS;
  ADD_KEYS(KEY_Q,SHORT_KEY);
  ADD_KEYS(KEY_SPACE,SHORT_KEY);
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  tcol=color_index(CL_TURQUOISE,100);
  poza=SC_HEIGHT;
  while (1) {
    draw_fillbox(NULL,0,0,SC_WIDTH,SC_HEIGHT,RGB_BLACK);
    if ((poza>-40) && (poza<SC_HEIGHT)) {
      copy_grafik(NULL,70,poza,ballergr,0,0,0,0,RGB_FULL);
    }
    if ((poza+60>-20) && (poza+60<SC_HEIGHT)) {
      i1=poza; if (i1<0) {i1=-i1;}
      copy_grafik(NULL,10,poza+60,feindgr[0][i1%3],0,0,0,0,RGB_TRANS);
      copy_grafik(NULL,60,poza+60,feindgr[1][(i1+1)%3],0,0,0,0,RGB_TRANS);
      copy_grafik(NULL,110,poza+60,feindgr[2][(i1+2)%3],0,0,0,0,RGB_TRANS);
      draw_text(NULL,tcol,150,poza+60,"= 1 Punkt",9,RGB_FULL);
    }
    if ((poza+90>-30) && (poza+90<SC_HEIGHT)) {
      draw_fillbox(NULL,10,poza+90,15,15,color_index(CL_PINK,100));
      draw_line(NULL,12,poza+97,23,poza+97,RGB_BLACK);
      draw_line(NULL,18,poza+92,23,poza+97,RGB_BLACK);
      draw_line(NULL,18,poza+102,23,poza+97,RGB_BLACK);
      draw_fillbox(NULL,40,poza+90,15,15,color_index(CL_PINK,100));
      draw_line(NULL,42,poza+97,53,poza+97,RGB_BLACK);
      draw_line(NULL,42,poza+97,47,poza+92,RGB_BLACK);
      draw_line(NULL,42,poza+97,47,poza+102,RGB_BLACK);
      draw_fillbox(NULL,70,poza+90,15,15,color_index(CL_PINK,100));
      draw_line(NULL,77,poza+92,77,poza+102,RGB_BLACK);
      draw_line(NULL,72,poza+97,77,poza+92,RGB_BLACK);
      draw_line(NULL,82,poza+97,77,poza+92,RGB_BLACK);
      draw_fillbox(NULL,100,poza+90,15,15,color_index(CL_PINK,100));
      draw_line(NULL,107,poza+92,107,poza+102,RGB_BLACK);
      draw_line(NULL,102,poza+97,107,poza+102,RGB_BLACK);
      draw_line(NULL,112,poza+97,107,poza+102,RGB_BLACK);
      draw_text(NULL,tcol,150,poza+94,"= Steuerung",11,RGB_FULL);
    }
    if ((poza+120>-20) && (poza+120<SC_HEIGHT)) {
      draw_fillbox(NULL,10,poza+120,40,15,color_index(CL_PINK,100));
      draw_text(NULL,color_index(CL_RED,100),14,poza+124,"STRG",4,RGB_FULL);
      draw_text(NULL,color_index(CL_RED,100),60,poza+124,"links",5,RGB_FULL);
      draw_text(NULL,tcol,150,poza+124,"= Schieen",10,RGB_FULL);
    }
    if ((poza+150>-20) && (poza+150<SC_HEIGHT)) {
      draw_fillbox(NULL,10,poza+150,15,15,color_index(CL_PINK,100));
      draw_text(NULL,color_index(CL_RED,100),14,poza+154,"P",1,RGB_FULL);
      draw_text(NULL,tcol,150,poza+154,"= Pause/Weiter",14,RGB_FULL);
    }
    if ((poza+180>-20) && (poza+180<SC_HEIGHT)) {
      draw_fillbox(NULL,10,poza+180,15,15,color_index(CL_PINK,100));
      draw_text(NULL,color_index(CL_RED,100),14,poza+184,"Q",1,RGB_FULL);
      draw_text(NULL,tcol,150,poza+184,"= Ende",6,RGB_FULL);
    }
    if ((poza+210>-20) && (poza+210<SC_HEIGHT)) {
      draw_fillbox(NULL,10,poza+210,15,15,color_index(CL_PINK,100));
      draw_text(NULL,color_index(CL_RED,100),14,poza+214,"1",1,RGB_FULL);
      draw_fillbox(NULL,40,poza+210,15,15,color_index(CL_PINK,100));
      draw_text(NULL,color_index(CL_RED,100),44,poza+214,"2",1,RGB_FULL);
      draw_text(NULL,tcol,150,poza+214,"= Musik leiser/lauter",21,RGB_FULL);
    }
    if ((poza+240>-20) && (poza+240<SC_HEIGHT)) {
      draw_fillbox(NULL,10,poza+240,15,15,color_index(CL_PINK,100));
      draw_text(NULL,color_index(CL_RED,100),14,poza+244,"3",1,RGB_FULL);
      draw_text(NULL,tcol,150,poza+244,"= Musikauswahl",14,RGB_FULL);
    }
    {static int ciza=0,cizb=100,nz=0;
     if (nz<4) {copy_grafik(NULL,ciza,cizb,ich.gr,0,0,0,0,RGB_TRANS);} else {ciza=-100;}
     ciza+=3;
     if (ciza>SC_WIDTH) {ciza=0-GRAFIK_WIDTH(ich.gr); cizb=ZUFALL(100)+50; nz++;}
    }
    flush_window();
    for (i1=0,i2=0;i1<2;i1++) {
      get_keys();
      if (IS_KEYS(KEY_Q)==1) {return(1);}
      if (IS_KEYS(KEY_SPACE)==1) {i2=1; break;}
      if (IS_KEYS(KEY_ENTER)==1) {i2=1; break;}
      wait_time(50);
    }
    if (i2==1) {break;}
    poza--;
    if (poza<=-270) {poza=SC_HEIGHT;}
  }
  return(0);
} /* Ende intro */


int extro() {
  char buf[128];
  CLEAR_KEYS;
  ADD_KEYS(KEY_Q,SHORT_KEY);
  ADD_KEYS(KEY_SPACE,SHORT_KEY);
  ADD_KEYS(KEY_ENTER,SHORT_KEY);
  draw_fillbox(NULL,0,0,SC_WIDTH,SC_HEIGHT,RGB_BLACK);
  sprintf(buf,"%d Punkte",trefanz);
  draw_text(NULL,color_index(CL_TURQUOISE,100),100,100,buf,strlen(buf),RGB_FULL);
  flush_window();
  while (1) {
    get_keys();
    if (IS_KEYS(KEY_Q)==1) {return(1);}
    if (IS_KEYS(KEY_SPACE)==1) {break;}
    if (IS_KEYS(KEY_ENTER)==1) {break;}
    wait_time(50);
  }
  return(0);
} /* Ende extro */


void runde() {
  int i1,i2,i3,i4,i5;
  int i_w,i_h,si_w,si_h,ti_x,ti_y,k_w,k_h;
  int d_w,d_h,sd_w,sd_h,rd_w,rd_h,td_x,td_y;
  int femax,ruza,faktor,wmerk[2];
  char buf[512];

  i_w=GRAFIK_WIDTH(ich.gr);
  i_h=GRAFIK_HEIGHT(ich.gr);
  si_w=GRAFIK_WIDTH(ich.sgr);
  si_h=GRAFIK_HEIGHT(ich.sgr);
  ti_x=i_w/8; ti_y=i_h/8;  /* Toleranz x,y */
  k_w=GRAFIK_WIDTH(ichklein);
  k_h=GRAFIK_HEIGHT(ichklein);
  d_w=GRAFIK_WIDTH(feindgr[0][0]);
  d_h=GRAFIK_HEIGHT(feindgr[0][0]);
  sd_w=GRAFIK_WIDTH(schussgr);
  sd_h=GRAFIK_HEIGHT(schussgr);
  rd_w=GRAFIK_WIDTH(rakete);
  rd_h=GRAFIK_HEIGHT(rakete);
  td_x=d_w/8; td_y=d_h/8;  /* Toleranz x,y */

  femax=3;
  trefanz=0;
  ruza=0;
  faktor=3;
  wmerk[0]=wmerk[1]=0;
  /* +++ Schiff neu setzen +++ */
  ich.lz=3;
  ich.sd=0;  /* kein Schuss da */
  ich.x=ich.xl;
  ich.y=(SC_HEIGHT-10)/2;
  ich.da=0;
  /* +++ Feinde neu setzen +++ */
  for (i1=0;i1<FEIND_MAX;i1++) {
    for (i2=0;i2<FEINDSS_MAX;i2++) {
      du[i1].ss[i2].gr=schussgr;
      du[i1].ss[i2].sa=1;
      du[i1].ss[i2].sd=0;  /* kein Schuss da */
      du[i1].ss[i2].xl=0-GRAFIK_WIDTH(schussgr);
      du[i1].ss[i2].xr=SC_WIDTH;
      du[i1].ss[i2].yo=0;
      du[i1].ss[i2].yu=SC_HEIGHT-10;
    }
    neu_feind(i1,femax,ruza);
  }

  /* +++ Sterne setzen +++ */
  for (i1=0;i1<STERN_MAX;i1++) {
    es[i1].lz=0;
  }

  CLEAR_KEYS;
  ADD_KEYS(KEY_LCTRL,LONG_KEY);
  ADD_KEYS(KEY_RCURS,LONG_KEY);
  ADD_KEYS(KEY_LCURS,LONG_KEY);
  ADD_KEYS(KEY_UCURS,LONG_KEY);
  ADD_KEYS(KEY_DCURS,LONG_KEY);
  ADD_KEYS(KEY_KP_2,LONG_KEY);
  ADD_KEYS(KEY_KP_4,LONG_KEY);
  ADD_KEYS(KEY_KP_6,LONG_KEY);
  ADD_KEYS(KEY_KP_8,LONG_KEY);
  ADD_KEYS(KEY_P,SHORT_KEY);
  ADD_KEYS(KEY_Q,SHORT_KEY);
  ADD_KEYS(KEY_1,LONG_KEY);
  ADD_KEYS(KEY_2,LONG_KEY);
  ADD_KEYS(KEY_3,SHORT_KEY);
  ADD_KEYS(KEY_F2,SHORT_KEY);
  musik=ZUFALL(10);
  play_wave(wave_nr[2+LOOP_MIDI(musik)+1],CN_(1),5,0);
            
  while (ich.lz>0) {
    ruza+=faktor;
    if (ruza>50000) {ruza=1;}
    if (ruza%2300<faktor) {
      femax++;
      if (femax>FEIND_MAX) {femax=FEIND_MAX;}
    }
    /* +++ Backpuffer loeschen +++ */
    draw_fillbox(NULL,0,0,SC_WIDTH,SC_HEIGHT,RGB_BLACK);
    /* +++ Sterne bewegen +++ */
    for (i1=0;i1<STERN_MAX;i1++) {
      if (es[i1].lz==0) {  /* Stern neu erscheinen lassen */
        es[i1].x=(float)ZUFALL(SC_WIDTH);
        es[i1].y=ZUFALL(SC_HEIGHT-10);
        es[i1].gx=(float)((ZUFALL(3)+2)/10.);
        es[i1].fb=ZUFALL(256);
        es[i1].lz=ZUFALL(100)+200;
      } else {
        es[i1].lz--;
        es[i1].x-=es[i1].gx*faktor;
      }
      draw_pixel(NULL,(int)es[i1].x,es[i1].y,es[i1].fb);
    }
    /* +++ Feinde bewegen +++ */
    for (i1=0;i1<femax;i1++) {
      if (du[i1].sl<=0) {  /* Feind ist aktiv */
        if (du[i1].da==0) {  /* Feind ist ok */
          /* Kontakt? */
          if (ich.da==0) {  /* Treffer mit Schiff? */
            if (treffer(ich.x,ich.y,i_w,i_h,du[i1].x,du[i1].y,d_w,d_h,ti_x+td_x,ti_y+td_y)==1) {
              ich.da=600/faktor;
              du[i1].da=80/faktor;
              play_wave(wave_nr[1],CN_(2),0,0);
              trefanz++;
              bonus();
              continue;
            }
          }
          if (ich.sd==1) {  /* Treffer mit Schuss? */
            if (treffer(ich.sx,ich.sy,si_w,si_h,du[i1].x,du[i1].y,d_w,d_h,td_x,td_y)==1) {
              ich.sd=0;
              du[i1].da=80/faktor;
              if (ich.da<=0) {play_wave(wave_nr[0],CN_(4),0,0);}
              trefanz++;
              bonus();
              continue;
            }
          }
          if (du[i1].sp>=0) {  /* Feind fliegt */
            /* Bewegen */
            du[i1].x-=du[i1].gx*faktor;
            du[i1].y-=du[i1].gy*faktor;
            if ((du[i1].x<du[i1].xl) || (du[i1].y<du[i1].yo) || (du[i1].y>du[i1].yu)) {  /* Grenzen? */
              neu_feind(i1,femax,ruza);
              continue;
            }
            if ((du[i1].wp>0) && (du[i1].x<=du[i1].wp)) {  /* y wechseln */
              du[i1].gy=(float)((ZUFALL(3)-1)/3.);
              du[i1].wp=0;
            }
            if ((du[i1].sp>0) && (du[i1].x<=du[i1].sp)) {  /* zielen */
              du[i1].sp=-(FEINDSS_MAX*(30/faktor))+1;
            }
            /* Kontakt? */
            if (ich.da==0) {  /* Treffer mit Schiff? */
              if (treffer(ich.x,ich.y,i_w,i_h,du[i1].x,du[i1].y,d_w,d_h,ti_x+td_x,ti_y+td_y)==1) {
                ich.da=600/faktor;
                du[i1].da=80/faktor;
                play_wave(wave_nr[1],CN_(2),0,0);
                trefanz++;
                bonus();
                continue;
              }
            }
            if (ich.sd==1) {  /* Treffer mit Schuss? */
              if (treffer(ich.sx,ich.sy,si_w,si_h,du[i1].x,du[i1].y,d_w,d_h,td_x,td_y)==1) {
                ich.sd=0;
                du[i1].da=80/faktor;
                if (ich.da<=0) {play_wave(wave_nr[0],CN_(4),0,0);}
                trefanz++;
                bonus();
                continue;
              }
            }
          } else {  /* Feind zielt */
            du[i1].sp++;
            if (du[i1].sp%(30/faktor)==0) {
              int sm;
              if (du[i1].fb==1) {sm=FEINDSS_MAX/2;} else {sm=FEINDSS_MAX;}
              for (i2=0;i2<sm;i2++) {
                if (du[i1].ss[i2].sd==0) {  /* Schuss ausloesen */
                  du[i1].ss[i2].x=du[i1].x-1;
                  du[i1].ss[i2].y=(float)(du[i1].y+d_h/2);
                  if (du[i1].fb==3) {
                    du[i1].ss[i2].sa=2;
                    du[i1].ss[i2].gr=rakete;
                    du[i1].ss[i2].xl=0-GRAFIK_WIDTH(rakete)-50;
                    du[i1].ss[i2].gy=0.;
                    du[i1].ss[i2].gx=20;
                    du[i1].sp=(int)du[i1].x-ZUFALL(50)-50;
                    if (du[i1].sp<0) {du[i1].sp=0;}
                    if (ich.da<=0) {play_wave(wave_nr[2],CN_(3),0,0);}
                  } else {
                    du[i1].ss[i2].sa=1;
                    du[i1].ss[i2].gr=schussgr;
                    du[i1].ss[i2].xl=0-GRAFIK_WIDTH(schussgr);
                    du[i1].ss[i2].gy=(float)ich.y-du[i1].ss[i2].y;
                    i3=du[i1].ss[i2].x-ich.x-i_w/2;
                    if (i3<0) {i3=-i3;} else if (i3==0) {i3=1;}
                    i3/=2;
                    du[i1].ss[i2].gy/=(float)(i3);
                    if (du[i1].ss[i2].gy>2.) {du[i1].ss[i2].gy=2.;}
                    else if (du[i1].ss[i2].gy<-2.) {du[i1].ss[i2].gy=-2.;}
                    du[i1].ss[i2].gx=ich.x-du[i1].ss[i2].x;
                    if (du[i1].ss[i2].gx>0) {du[i1].ss[i2].gx=2;}
                    else {du[i1].ss[i2].gx=-2;}
                  }
                  du[i1].ss[i2].sd=2;
                  break;
                }
              }
              if (i2==FEINDSS_MAX) {du[i1].sp=0;}
              if ((du[i1].fb!=3) && (du[i1].sp==0)) {
                du[i1].sp=(int)du[i1].x-ZUFALL(30)-80;
                if (du[i1].sp<0) {du[i1].sp=0;}
              }
            }
          }
          i2=((-du[i1].sl)/10)%3;
          copy_grafik(NULL,du[i1].x,du[i1].y,du[i1].gr[i2],0,0,0,0,RGB_TRANS);
          du[i1].sl--;
        } else {   /* Feind immaterialisiert */
          du[i1].da--;
          if (du[i1].da>0) {
            i2=du[i1].da/3+1;
            if (i2>d_w) {i2=d_w;}
            i3=du[i1].da/3+1;
            if (i3>d_h) {i3=d_h;}
            for (i4=0;i4<i2;i4++) {
              for (i5=0;i5<i3;i5++) {
                draw_pixel(NULL,du[i1].x+(d_w-i2)/2+i4,du[i1].y+(d_h-i3)/2+i5,ZUFALL(256));
              }
            }
          } else {
            neu_feind(i1,femax,ruza);
          }
        }
      } else {  /* Feind ist nicht da */
        du[i1].sl--;
      }
      /* Schuesse */
      for (i2=0;i2<FEINDSS_MAX;i2++) {
        if (du[i1].ss[i2].sd==0) {continue;}
        /* Kontakt? */
        if (ich.da==0) {  /* Treffer mit Schiff? */
          if (du[i1].ss[i2].sa==2) {i3=rd_w; i4=rd_h;} else {i3=sd_w; i4=sd_h;}
          if (treffer(ich.x,ich.y,i_w,i_h,du[i1].ss[i2].x,(int)du[i1].ss[i2].y,i3,i4,ti_x,ti_y)==1) {
            ich.da=600/faktor;
            du[i1].ss[i2].sd=0;
            play_wave(wave_nr[1],CN_(2),0,0);
            continue;
          }
        }
        if (du[i1].ss[i2].sd==2) {
          du[i1].ss[i2].sd=1;
        } else {
          if (du[i1].ss[i2].sa==2) {
            if (du[i1].ss[i2].gx>-5) {du[i1].ss[i2].gx-=faktor;} else {du[i1].ss[i2].gx=-5;}
            if (du[i1].ss[i2].gx<0) {
              du[i1].ss[i2].x+=du[i1].ss[i2].gx*faktor;
            } else {
              if (du[i1].ss[i2].gx%(faktor*2)==0) {
                du[i1].ss[i2].x+=5;
              } else {
                du[i1].ss[i2].x-=5;
              }
            }
          } else {
            du[i1].ss[i2].x+=du[i1].ss[i2].gx*faktor;
            du[i1].ss[i2].y+=du[i1].ss[i2].gy*faktor;
          }
          if ((du[i1].ss[i2].x<du[i1].ss[i2].xl) || (du[i1].ss[i2].x>du[i1].ss[i2].xr) || ((int)du[i1].ss[i2].y<du[i1].ss[i2].yo) || ((int)du[i1].ss[i2].y>du[i1].ss[i2].yu)) {  /* Grenzen? */
            du[i1].ss[i2].sd=0;
            continue;
          }
          /* Kontakt? */
          if (ich.da==0) {  /* Treffer mit Schiff? */
            if (du[i1].ss[i2].sa==2) {i3=rd_w; i4=rd_h;} else {i3=sd_w; i4=sd_h;}
            if (treffer(ich.x,ich.y,i_w,i_h,du[i1].ss[i2].x,(int)du[i1].ss[i2].y,i3,i4,ti_x,ti_y)==1) {
              ich.da=600/faktor;
              du[i1].ss[i2].sd=0;
              play_wave(wave_nr[1],CN_(2),0,0);
              continue;
            }
          }
        }
        copy_grafik(NULL,du[i1].ss[i2].x,(int)du[i1].ss[i2].y,du[i1].ss[i2].gr,0,0,0,0,RGB_FULL);
        if (du[i1].ss[i2].sa==2) {
          int rx,ry,ci[2];
          rx=du[i1].ss[i2].x+rd_w+2;
          ry=du[i1].ss[i2].y+rd_h/2;
          ci[0]=color_index(CL_YELLOW,100);
          ci[1]=color_index(CL_RED,100);
          draw_line(NULL,rx,ry,rx+49,ry,RGB_WHITE);
          for (i5=5;i5<50;i5++) {
            draw_pixel(NULL,rx+i5,ry-1,ci[ZUFALL(2)]);
            draw_pixel(NULL,rx+i5,ry+1,ci[ZUFALL(2)]);
          }
        }
      }
    }
    /* +++ Schiff bewegen +++ */
    get_keys();
    if (IS_KEYS(KEY_Q)==1) {break;}  /* quit */
    if (IS_KEYS(KEY_P)==1) {  /* Pause */
      stop_wave(CN_ALL,0);
      draw_text(NULL,color_index(CL_GREEN,100),SC_WIDTH/2-20,(SC_HEIGHT-10)/2-4,"PAUSE",5,RGB_TRANS);
      flush_window();
      do {
        wait_time(150);
        get_keys();
        if (IS_KEYS(KEY_Q)==1) {break;}  /* quit */
      } while (IS_KEYS(KEY_P)==0);
      if (IS_KEYS(KEY_Q)==1) {break;}  /* quit */
      play_wave(wave_nr[2+LOOP_MIDI(musik)+1],CN_(1),5,0);
    }
    if (IS_KEYS(KEY_1)==1) {  /* leiser */
      volm--;
      if (volm<0) {
        volm=0;
      } else {
        set_vol(volm,0);
      }
    }
    if (IS_KEYS(KEY_2)==1) {  /* lauter */
      volm++;
      if (volm>100) {
        volm=100;
      } else {
        set_vol(volm,0);
      }
    }
    if (IS_KEYS(KEY_3)==1) {  /* andere Musik */
      musik++;
      play_wave(wave_nr[2+LOOP_MIDI(musik)+1],CN_(1),5,3);
    }
    if (ich.da<=0) {  /* Schiff aktiv */
      if (ich.da<0) {ich.da++;}
      if ((IS_KEYS(KEY_DCURS)==1) || (IS_KEYS(KEY_KP_2)==1)) {  /* runter */
        ich.y+=faktor;
        if (ich.y>ich.yu) {ich.y=ich.yu;}
      }
      if ((IS_KEYS(KEY_UCURS)==1) || (IS_KEYS(KEY_KP_8)==1)) {  /* rauf */
        ich.y-=faktor;
        if (ich.y<ich.yo) {ich.y=ich.yo;}
      }
      if ((IS_KEYS(KEY_RCURS)==1) || (IS_KEYS(KEY_KP_6)==1)) {  /* rechts */
        ich.x+=faktor;
        if (ich.x>ich.xr) {ich.x=ich.xr; ich.xv=0;} else {ich.xv++;}
      } else {ich.xv=0;}
      if ((IS_KEYS(KEY_LCURS)==1) || (IS_KEYS(KEY_KP_4)==1)) {  /* links */
        ich.x-=faktor;
        if (ich.x<ich.xl) {ich.x=ich.xl;}
        ich.xv=0;
      }
      if (IS_KEYS(KEY_LCTRL)==1) {  /* Schuss */
        if (ich.sd==0) {
          ich.sx=ich.x+i_w;
          ich.sy=ich.y+i_h/2;
          ich.sd=2;
        }
      }
      i1=(-ich.da)%(20/faktor);
      if (i1<=10/faktor) {
        copy_grafik(NULL,ich.x,ich.y,ich.gr,0,0,0,0,RGB_TRANS);
        if (ich.xv>0) {
          int r,g;
          r=color_index(CL_RED,100);
          g=color_index(CL_YELLOW,100);
          if (ich.xv%2==0) {
            draw_pixel(NULL,ich.x-1,ich.y+(i_h)/2-1,g);
            draw_pixel(NULL,ich.x-2,ich.y+(i_h)/2-1,g);
            draw_pixel(NULL,ich.x-2,ich.y+(i_h)/2,g);
            draw_pixel(NULL,ich.x-3,ich.y+(i_h)/2,g);
            draw_pixel(NULL,ich.x-4,ich.y+(i_h)/2,g);
            draw_pixel(NULL,ich.x-2,ich.y+(i_h)/2+1,g);
            draw_pixel(NULL,ich.x-1,ich.y+(i_h)/2+1,g);
          } else {
            draw_pixel(NULL,ich.x-1,ich.y+(i_h)/2-2,r);
            draw_pixel(NULL,ich.x-2,ich.y+(i_h)/2-2,r);
            draw_pixel(NULL,ich.x-3,ich.y+(i_h)/2-1,r);
            draw_pixel(NULL,ich.x-4,ich.y+(i_h)/2-1,r);
            draw_pixel(NULL,ich.x-3,ich.y+(i_h)/2,r);
            draw_pixel(NULL,ich.x-4,ich.y+(i_h)/2,r);
            draw_pixel(NULL,ich.x-5,ich.y+(i_h)/2,r);
            draw_pixel(NULL,ich.x-6,ich.y+(i_h)/2,r);
            draw_pixel(NULL,ich.x-4,ich.y+(i_h)/2+1,r);
            draw_pixel(NULL,ich.x-3,ich.y+(i_h)/2+1,r);
            draw_pixel(NULL,ich.x-2,ich.y+(i_h)/2+2,r);
            draw_pixel(NULL,ich.x-1,ich.y+(i_h)/2+2,r);
          }
        }
      }
    } else {  /* Schiff immaterialisiert */
      ich.da--;
      if (ich.da>300/faktor) {
        i1=(ich.da-300/faktor)/(10/faktor);
        if (i1>i_w) {i1=i_w;}
        i2=(ich.da-300/faktor)/(10/faktor);
        if (i2>i_h) {i2=i_h;}
        for (i3=0;i3<i1;i3++) {
          for (i4=0;i4<i2;i4++) {
            draw_pixel(NULL,ich.x+(i_w-i1)/2+i3,ich.y+(i_h-i2)/2+i4,ZUFALL(256));
          }
        }
      } else if (ich.da==0) {
        ich.lz--;
        ich.x=ich.xl;
        ich.y=(SC_HEIGHT-10)/2;
        ich.da=-500/faktor;
      }
    }
    /* Schuss */
    if (ich.sd>0) {
      if (ich.sd==2) {
        ich.sd=1;
      } else {
        ich.sx+=7*faktor;
      }
      if (ich.sx>ich.sxr) {
        ich.sd=0;
      } else {
        copy_grafik(NULL,ich.sx,ich.sy,ich.sgr,0,0,0,0,RGB_FULL);
      }
    }
    /* +++ Sonst noch +++ */
    for (i1=0;i1<ich.lz-1;i1++) {
      copy_grafik(NULL,i1*k_w+5,k_h<10?SC_HEIGHT-10+(10-k_h)/2:SC_HEIGHT-k_h,ichklein,0,0,0,0,RGB_TRANS);
    }
    sprintf(buf,"%d",trefanz);
    draw_text(NULL,RGB_WHITE,SC_WIDTH-10-strlen(buf)*8,SC_HEIGHT-9,buf,strlen(buf),RGB_TRANS);
#if 0
    if ((faktor>1) && (wmerk[0]<80)) {
      sprintf(buf,"Zu langsam. Spiele mit Faktor %d",faktor);
      draw_text(NULL,RGB_WHITE,0,0,buf,strlen(buf),RGB_TRANS);
    }
#endif
    flush_window();
    if (IS_KEYS(KEY_F2)==1) {  /* screenshot as ppm */
      save_grafik_as_ppm(NULL,"/tmp/_vgag_bs.ppm");
    }
    i1=wait_time(17*faktor);  /* Rueckgabe ist benoetigte Zeit */
    if (wmerk[0]<500) {wmerk[0]++; wmerk[1]+=i1;}
    else if (wmerk[0]==500) {  /* nach 500 Runden Zeit testen */
      /* wenn mehr als 20+10 Millisekunden, Spielfaktor inkrementieren */
      if (wmerk[1]/wmerk[0]>20*faktor+10) {faktor++; wmerk[0]=wmerk[1]=0;}
    }
  }
} /* Ende runde */


void neu_feind(int ii,int femax,int ruza) {
  du[ii].da=0;
  du[ii].sl=ZUFALL(femax*(FEIND_MAX*4-femax*3));
  ruza/=2500;
  ruza++;
  ruza=ZUFALL(ruza);
  ruza%=3;
  ruza++;
  du[ii].fb=ruza;
  du[ii].gr[0]=feindgr[du[ii].fb-1][0];
  du[ii].gr[1]=feindgr[du[ii].fb-1][1];
  du[ii].gr[2]=feindgr[du[ii].fb-1][2];
  du[ii].x=SC_WIDTH;
  du[ii].y=ZUFALL(SC_HEIGHT-50)+20;
  du[ii].gx=(float)((ZUFALL(5)+5)/10.);
  du[ii].gy=(float)((ZUFALL(3)-1)/3.);
  du[ii].wp=ZUFALL(SC_WIDTH-80)+40;
  du[ii].sp=ZUFALL(SC_WIDTH-200)+160;
} /* Ende neu_feind */


int treffer(int x1,int y1,int w1,int h1,int x2,int y2,int w2,int h2,int tx,int ty) {
  if ((x1+w1>x2+tx) && (x1+tx<x2+w2)) {
    if ((y1+h1>y2+ty) && (y1+ty<y2+h2)) {
      return(1);
    }
  }
  return(0);
} /* Ende treffer */


void bonus() {
  if (trefanz==100) {ich.lz++;}
  else if (trefanz==200) {ich.lz++;}
  else if (trefanz==500) {ich.lz++;}
  else if (trefanz==1000) {ich.lz++;}
} /* Ende bonus */


void end_err(char * msg) {
  end_sound();
  close_window();
  fprintf(stderr,"%s: %s\n",msg,errmsg);
  exit(1);
} /* Ende end_err */
