/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Film functions"
**   create a short film and play it twice
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <vgagames.h>

int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  grafik * grf1,* grf2;
  film * flm;
  film_bild bld;
  unsigned long s_nr;
  int i1,wv;

  /* open window */
  if (open_window("Film",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }
  init_sound(11025,0);

  /* +++ create film +++ */
  /* create film with 3 graphical sequences */
  if ((flm=create_film(3))==NULL) {end_err(argv[0],"create film");}

  /* set id, absolute x/y coordinates of film and no film function */
  SET_FILM(flm,1,0,0,NULL);

  /* set 1. graphical sequence: walking dog */
  if ((grf1=load_grafik("./hund1.bmp"))==NULL) {end_err(argv[0],"load \"hund1.bmp\"");}
  if ((grf2=load_grafik("./hund2.bmp"))==NULL) {end_err(argv[0],"load \"hund2.bmp\"");}
  for (i1=0;i1<320;i1++) {  /* 320 pictures in 1. sequence */
    SET_FILM_BILD(&bld,i1%10<5?grf1:grf2,i1,150,RGB_FULL,i1==180?20:1,0,0,0);
    add_bild_to_film(flm,&bld,1);
  }
  free_grafik(grf1);
  free_grafik(grf2);

  /* set 2. graphical sequence: flying bird */
  if ((grf1=load_grafik("./vogel1.bmp"))==NULL) {end_err(argv[0],"load \"vogel1.bmp\"");}
  if ((grf2=load_grafik("./vogel2.bmp"))==NULL) {end_err(argv[0],"load \"vogel2.bmp\"");}
  for (i1=319;i1>=0;i1--) {  /* 320 pictures in 2. sequence */
    SET_FILM_BILD(&bld,i1%10<5?grf1:grf2,i1,30,RGB_FULL,1,0,0,0);
    add_bild_to_film(flm,&bld,2);
  }
  free_grafik(grf1);
  free_grafik(grf2);

  /* set 3. graphical sequence: falling egg */
  SET_FILM_BILD(&bld,NULL,0,0,RGB_FULL,140,0,0,0);  /* nothing */
  add_bild_to_film(flm,&bld,3);
  if ((grf1=load_grafik("./ei1.bmp"))==NULL) {end_err(argv[0],"load \"ei1.bmp\"");}
  for (i1=30;i1<150;i1+=3) {  /* falling egg */
    SET_FILM_BILD(&bld,grf1,190,i1,RGB_TRANS,1,0,0,0);
    add_bild_to_film(flm,&bld,3);
  }
  if ((grf2=load_grafik("./ei2.bmp"))==NULL) {end_err(argv[0],"load \"ei2.bmp\"");}
  wv=load_wave("./ptsch.wav",TYP_IS_WAVE);  /* with sound */
  for (i1=190;i1<320;i1++) {  /* broken egg */
    SET_FILM_BILD(&bld,grf2,i1,150,RGB_TRANS,wv?20:1,wv,CN_(1),0);
    add_bild_to_film(flm,&bld,3);
    wv=0;
  }
  free_grafik(grf1);
  free_grafik(grf2);

  /* +++ play film +++ */
  do {
    CLEAR_BOX(NULL,RGB_BLACK);
    s_nr=copy_film(NULL,flm,NULL);
    flush_window();
    if (get_space(40)) {break;}
  } while (s_nr<320UL);

  /* +++ play film again +++ */
  /* reset film (value 1 could be another - we don't use a function) */
  reset_film(flm,NULL,1);
  /* play film */
  do {
    CLEAR_BOX(NULL,RGB_BLACK);
    s_nr=copy_film(NULL,flm,NULL);
    flush_window();
    if (get_space(40)) {break;}
  } while (s_nr<320UL);

  /* free film (and all graphics) */
  free_film(flm);

  /* do ending */
  end_sound();
  close_window();
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  end_sound();
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
