/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Graphic box functions"
**   Move a sunnyboy over the screen with a silly text and a moving background
**   until getting a space key.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <vgagames.h>

int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  grafik * sunnyboy,* backgr,* grf;
  int i1,i2,i3,i4,i5;

  /* open window */
  if (open_window("Example",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* at first give a message */
  grf=text_to_grafik(RGB_WHITE,RGB_BLACK,2,1,"See a nice sunnyboy.\nYou won't do him anything!");
  if (grf==NULL) {end_err(argv[0],"set text to grafik");}
  CLEAR_BOX(NULL,RGB_BLACK);
  copy_grafik(NULL,40,90,grf,0,0,0,0,RGB_FULL);
  flush_window();
  sleep(4);
  free_grafik(grf);

  /* create sunnyboy graphic box */
  if ((sunnyboy=create_grafik(20,20))==NULL) {
    end_err(argv[0],"create graphic");
  }

  /* draw a sunnyboy into empty graphic box */
  /* get yellow color (see "Color functions") */
  i3=color_index(CL_YELLOW,100);
  /* i1,i2 is middle of graphic box */
  i1=GRAFIK_WIDTH(sunnyboy)/2;  /* we know it is 10 */
  i2=GRAFIK_HEIGHT(sunnyboy)/2;  /* we know it is also 10 */
  /* draw face yellow with radius 9 and not filled */
  draw_circle(sunnyboy,i1,i2,9,i3,0);
  /* draw eyes */
  draw_fillbox(sunnyboy,5,5,3,3,i3);
  draw_fillbox(sunnyboy,13,5,3,3,i3);
  /* draw nose */
  draw_line(sunnyboy,10,8,10,12,i3);
  /* draw mouth */
  draw_line(sunnyboy,7,15,13,15,i3);
  draw_line(sunnyboy,5,11,7,15,i3);
  draw_line(sunnyboy,13,15,15,11,i3);

  /* create background graphic box,
  ** larger than SC_WIDTH=320 but equal to SC_HEIGHT=200,
  ** because we want to move it right and left
  */
  if ((backgr=create_grafik(500,200))==NULL) {
    end_err(argv[0],"create graphic");
  }

  /* draw rectangles into empty background graphic box */
  i2=color_index(CL_RED,90);
  i3=color_index(CL_GREEN,60);
  for (i1=0;i1<5;i1++) {
    draw_fillbox(backgr,i1*100,0,100,100,i2);
    draw_fillbox(backgr,i1*100,100,100,100,i3);
    i4=i2; i2=i3; i3=i4;
  }

  /* now let the show begin */
  srand(time(NULL)%1000);  /* initialize random number generator */
  i1=i2=i3=i4=0;
  i5=1;

  while (get_space(50)==0) {  /* while space key is not pressed */

    if (++i3>=20) {  /* get new random numbers for sunnyboy position */
      i1=(int)((float)SC_WIDTH*rand()/(RAND_MAX+1.));   /* x position */
      i2=(int)((float)SC_HEIGHT*rand()/(RAND_MAX+1.));  /* y position */
      if ((int)(2.*rand()/RAND_MAX+1.)==1) {  /* set font10x17 */
        set_font(font10x17,10,17);
      } else {  /* set default font */
        set_font(NULL,0,0);
      }
      i3=0;
    }

    /* clear window */
    CLEAR_BOX(NULL,RGB_BLACK);

    /* put background graphic into window (backbuffer),
    ** i4 is "copy from" x position of background graphic box
    ** i5 is positive or negative: the direction of moving background context
    */
    copy_grafik(NULL,0,0,backgr,i4,0,SC_WIDTH,SC_HEIGHT,RGB_FULL);
    i4+=i5;  /* move x position of background */
    if ((i4>=GRAFIK_WIDTH(backgr)-SC_WIDTH) || (i4<=0)) {i5=-i5;}  /* other direction */

    /* put sunnyboy at random position i1,i2 into window */
    copy_grafik(NULL,i1,i2,sunnyboy,0,0,0,0,RGB_TRANS);

    /* draw a silly text near to sunnyboy */
    draw_text(NULL,color_index(CL_PINK,100),i1+16,i2+16,"Catch me, hehe",14,RGB_FULL);

    /* flush data to window */
    flush_window();
  }  /* end while */

  /* free graphic boxes */
  free_grafik(backgr);
  free_grafik(sunnyboy);

  /* do ending */
  close_window();
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    draw_text(NULL,RGB_WHITE,0,180,"Press Space",11,RGB_TRANS);
    flush_window();
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
