/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Color functions"
**   draw a chess board, make it darker, load grey colormap and make it lighter
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <vgagames.h>

int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  grafik * chess;
  int i1,i2,i3,i4,i5;

  /* open window */
  if (open_window("Example",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* create chess graphic box */
  if ((chess=create_grafik(80,80))==NULL) {
    end_err(argv[0],"create graphic");
  }

  /* draw chess board into empty graphic box */
  /* get blue and red color at different brightness percent values */
  i1=color_index(CL_BLUE,70);  /* 70% brightness of normal blue */
  i2=color_index(CL_RED,100);  /* 100% brightness of normal red */
  i5=1;
  for (i3=0;i3<8;i3++) {
    for (i4=0;i4<8;i4++) {
      draw_fillbox(chess,i3*10,i4*10,10,10,i5==1?i1:i2);
      i5=-i5;
    }
    i5=-i5;
  }

  /* now let the show begin */
  /* make darker from normal (=0) to darkest (=-63) */
  for (i1=0;i1>=-63;i1--) {
    brightness(i1);
    copy_grafik(NULL,120,60,chess,0,0,0,0,RGB_FULL);  /* put chess to window */
    flush_window();
    wait_time(60);  /* wait up to 60 milliseconds */
    get_keys();  /* only for correcting screen in X window */
  }

  /* load grey colormap
  ** each pixel of the chess graphic has still the same color index as before,
  ** but after loading the grey colormap, each color index points to another
  ** color value.
  */
  if (load_colormap(GREY256)==-1) {end_err(argv[0],"load colormap");}

  /* make lighter from darkest (=-63) to lighter than normal (e.g. 24) */
  for (i1=-63;i1<=24;i1++) {
    brightness(i1);
    copy_grafik(NULL,120,60,chess,0,0,0,0,RGB_FULL);  /* put chess to window */
    flush_window();
    wait_time(60);  /* wait up to 60 milliseconds */
    get_keys();  /* only for correcting screen in X window */
  }

  /* wait for space key */
  get_space(0);

  /* free graphic box */
  free_grafik(chess);

  /* do ending */
  close_window();
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    draw_text(NULL,RGB_WHITE,0,180,"Press Space",11,RGB_TRANS);
    flush_window();
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
