/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Window functions"
**   open window and reopen it in full screen mode resp. not full screen mode
**   - takes no effect with console graphic libraries
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <vgagames.h>

int main(int argc,char * argv[]) {
  /* variables */
  int winflag;
  int i1;

  /* examinate how to open window
  ** (only if WINDOW_RESIZABLE is defined, else it will take no effect)
  ** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
  */
  winflag=0;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }

  /* open window */
  if (open_window("Example",winflag)==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* print text to window */
  draw_text(NULL,RGB_WHITE,0,0,"First window",12,RGB_FULL);
  /* flush data to window and sleep a bit */
  flush_window();
  sleep(3);

  /* now reopen window with same scaling factor but full/not full mode
  ** (only if WINDOW_RESIZABLE is defined, else it will take no effect)
  */
  if (winflag>=VGAWINDOW_FULL) {winflag-=VGAWINDOW_FULL;}
  else {winflag+=VGAWINDOW_FULL;}
  if (reopen_window(winflag)==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* print text to window */
  draw_text(NULL,RGB_WHITE,0,0,"Second window",13,RGB_FULL);
  /* flush data to window and sleep a bit */
  flush_window();
  sleep(3);

  /* now do the ending */
  close_window();
  exit(0);
}
