/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Initializing and ending functions"
**   Visible is only a text "All ready", but understanding the source code
**   might be more interesting than simply executing the program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <vgagames.h>

int main(int argc,char * argv[]) {
  /* variables */
  int no_of_players=0;  /* number of network players */
  const unsigned short port=1235;  /* network port */
  void * netw_data;     /* network memory pointer */
  char * play_data;     /* pointer into network memory for player */
  const int play_data_len=4;  /* length of each players network data:
                              ** you must have defined which bytes contain
                              ** which information, here we assume 4 bytes.
                              **   byte 0 = always reserved
                              **   bytes 1 to 3 = whatever
                              */
  int play_pos;         /* players position (1 to 8) */
  int master;           /* whether you are master player */

  /* for network use there must be some information given:
  ** there must be one master player, which is recognized here
  ** by an argument, which indicates the number of players
  */
  master=0;
  if (argc!=2) {
    fprintf(stderr,"usage: %s -s<1 to 8>|-c\n",argv[0]);
    fprintf(stderr,"<1 to 8>: number of players.\n");
    exit(1);
  }
  if (strncmp(argv[1],"-s",2)==0) {  /* master player */
    master=1;
    no_of_players=atoi(argv[1]+2);
    if ((no_of_players<1) || (no_of_players>8)) {  /* error */
      fprintf(stderr,"usage: %s -s<1 to 8>|-c\n",argv[0]);
      fprintf(stderr,"<1 to 8>: number of players.\n");
      exit(1);
    }
  }

  /* now let us begin: open the window */
  if (open_window("Example",VGAWINDOW_1)==-1) {  /* error */
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* start sound server */
  if (init_sound(11025,0)==-1) {  /* error */
    close_window();  /* window must be closed */
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* if you are master player then start network server */
  if (master==1) {  /* master player */
    if (start_nettcp(no_of_players,0,port)==-1) {  /* error */
      end_sound();     /* sound server must be stopped */
      close_window();  /* window must be closed */
      fprintf(stderr,"%s: %s\n",argv[0],errmsg);
      exit(1);
    }
  }

  /* all players now connect to network server:
  ** Connect with broadcast/multicast (NULL)
  **   at specified port (port),
  **   sending length of each players data (play_data_len),
  **   receiving players position (play_pos)
  **   receiving the number of players (no_of_players)
  */
  netw_data=connect_nettcp(NULL,port,play_data_len,&play_pos,&no_of_players);
  if (netw_data==NULL) {  /* error */
    end_sound();     /* sound server must be stopped */
    close_window();  /* window must be closed */
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }
  play_data=netw_data;  /* at begin of network memory */
  play_data+=play_pos*play_data_len;  /* now at players position */
  play_data[0]=1;  /* initialize reserved byte */

  /* now we are ready with initializing and the game loop may begin */
  /* set play_data to the players position */
  play_data=netw_data;  /* at begin of network memory */
  play_data+=play_pos*play_data_len;  /* now at players position */
  draw_text(NULL,RGB_WHITE,0,0,"All ready",9,RGB_FULL);
  flush_window();
  sleep(2);

  /* now we do the ending */
  close_nettcp();  /* disconnect from network server,
                   ** the network server will exit automatically
                   */
  end_sound();     /* stop sound server */
  close_window();  /* close window */
  exit(0);
}
