/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Example program for "Key and mouse functions"
**   move sunnyboy with silly text and let him be not sunny
**   when hit and clicked with the mouse
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <vgagames.h>

int get_opt(int,char *[]);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  grafik * sunnyboy,* sunnyhit,* mouse_pointer;
  int i1,i2,i3,m_speed,sunny_hit,mpx,mpy;
  char m_velo[64];

  /* open window */
  if (open_window("Example",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* test existence of mouse */
  if (MOUSE_FOUND==0) {
    end_err(argv[0],"no mouse found");
  }

  /* create sunnyboy graphic box */
  if ((sunnyboy=create_grafik(20,20))==NULL) {
    end_err(argv[0],"create graphic");
  }

  /* draw a sunnyboy into empty graphic box */
  i3=color_index(CL_YELLOW,100);
  /* i1,i2 is middle of graphic box */
  i1=GRAFIK_WIDTH(sunnyboy)/2;  /* we know it is 10 */
  i2=GRAFIK_HEIGHT(sunnyboy)/2;  /* we know it is also 10 */
  /* draw face yellow with radius 9 and not filled */
  draw_circle(sunnyboy,i1,i2,9,i3,0);
  /* draw eyes */
  draw_fillbox(sunnyboy,5,5,3,3,i3);
  draw_fillbox(sunnyboy,13,5,3,3,i3);
  /* draw nose */
  draw_line(sunnyboy,10,8,10,12,i3);
  /* draw mouth */
  draw_line(sunnyboy,7,15,13,15,i3);
  draw_line(sunnyboy,5,11,7,15,i3);
  draw_line(sunnyboy,13,15,15,11,i3);

  /* when hit: create sunnyboy graphic box */
  if ((sunnyhit=create_grafik(20,20))==NULL) {
    end_err(argv[0],"create graphic");
  }

  /* draw an insulted sunnyboy into empty graphic box */
  i3=color_index(CL_YELLOW,100);
  /* i1,i2 is middle of graphic box */
  i1=GRAFIK_WIDTH(sunnyhit)/2;  /* we know it is 10 */
  i2=GRAFIK_HEIGHT(sunnyhit)/2;  /* we know it is also 10 */
  /* draw face yellow with radius 9 and not filled */
  draw_circle(sunnyhit,i1,i2,9,i3,0);
  /* draw eyes */
  draw_fillbox(sunnyhit,5,5,3,3,i3);
  draw_pixel(sunnyhit,6,4,i3);
  draw_pixel(sunnyhit,8,6,i3);
  draw_fillbox(sunnyhit,13,5,3,3,i3);
  draw_pixel(sunnyhit,14,4,i3);
  draw_pixel(sunnyhit,12,6,i3);
  /* draw nose */
  draw_line(sunnyhit,10,8,10,12,i3);
  /* draw mouth */
  draw_line(sunnyhit,7,15,13,15,i3);
  draw_line(sunnyhit,5,17,7,15,i3);
  draw_line(sunnyhit,13,15,15,17,i3);

  /* create and draw mouse pointer */
  if ((mouse_pointer=create_grafik(7,7))==NULL) {
    end_err(argv[0],"create graphic");
  }
  draw_circle(mouse_pointer,3,3,3,RGB_WHITE,0);
  draw_line(mouse_pointer,0,0,6,6,RGB_WHITE);
  draw_line(mouse_pointer,6,0,0,6,RGB_WHITE);

  /* set the key field */
  CLEAR_KEYS;  /* clear key field */
  /* add [1] as short key */
  ADD_KEYS(KEY_1,SHORT_KEY);
  /* add [2] as short key */
  ADD_KEYS(KEY_2,SHORT_KEY);
  /* add space as short key */
  ADD_KEYS(KEY_SPACE,SHORT_KEY);
  /* set mouse speed slow */
  m_speed=mouse_speed(2);
  if (m_speed>0) {m_speed=2;}  /* check whether mouse speed can be changed */

  /* now let the show begin */
  srand(time(NULL)%1000);  /* initialize random number generator */
  i1=i2=i3=sunny_hit=0;
  mpx=mpy=-1;  /* for mouse position */
  clearstate();

  do {
    /* get new random numbers for sunnyboy position */
    if ((sunny_hit==0) && (++i3>=15)) {
      i1=(int)((float)SC_WIDTH*rand()/(RAND_MAX+1.));   /* x position */
      i2=(int)((float)SC_HEIGHT*rand()/(RAND_MAX+1.));  /* y position */
      i3=0;
    }

    /* clear window */
    CLEAR_BOX(NULL,RGB_BLACK);

    /* put sunnyboy at random position i1,i2 into window */
    if (sunny_hit>0) {  /* draw insulted sunnyboy */
      sunny_hit--;
      copy_grafik(NULL,i1,i2,sunnyhit,0,0,0,0,RGB_TRANS);
      /* draw a silly text near to sunnyboy */
      draw_text(NULL,color_index(CL_PINK,100),i1+16,i2+16,"oohhhhh",7,RGB_TRANS);
    } else {  /* draw normal sunnyboy */
      copy_grafik(NULL,i1,i2,sunnyboy,0,0,0,0,RGB_TRANS);
      /* draw a silly text near to sunnyboy */
      draw_text(NULL,color_index(CL_PINK,100),i1+16,i2+16,"Catch me, hehe",14,RGB_TRANS);
    }
    if (m_speed>0) {  /* mouse speed can be changed */
      draw_text(NULL,RGB_WHITE,0,190,"speed mouse [1]=down [2]=up",27,RGB_TRANS);
    } else {
      draw_text(NULL,RGB_WHITE,0,190,"speed mouse cannot be changed",29,RGB_TRANS);
    }

    /* test key and mouse events */
    get_keys();  /* update input events */
    /* test key events */
    if (m_speed>0) {  /* mouse speed can be changed */
      if (IS_KEYS(KEY_1)==1) {  /* key "1" pressed */
        if (--m_speed<1) {m_speed=1;}
        mouse_speed(m_speed);
      } else if (IS_KEYS(KEY_2)==1) {  /* key "2" pressed */
        if (++m_speed>3) {m_speed=3;}
        mouse_speed(m_speed);
      }
      snprintf(m_velo,sizeof(m_velo),"(%s)",m_speed==1?"slow":(m_speed==2?"normal":"fast"));
      draw_text(NULL,RGB_WHITE,240,190,m_velo,strlen(m_velo),RGB_TRANS);
    }
    /* test mouse events */
    mpx=MOUSE_X;
    mpy=MOUSE_Y;
    if ((mpx>=0) && (mpy>=0)) {  /* draw mouse pointer */
      copy_grafik(NULL,mpx,mpy,mouse_pointer,0,0,0,0,RGB_TRANS);
    }
    if (IS_MOUSELEFT==1) {  /* left mouse button pressed */
      if (sunny_hit==0) {  /* hit sunnyboy? (if not yet hit) */
        /* i1,i2 is left upper corner of sunnyboy graphic
           mpx,mpy is left upper corner of mouse pointer
        */
        if ((mpx+GRAFIK_WIDTH(mouse_pointer)>=i1) && (mpx<=i1+GRAFIK_WIDTH(sunnyboy))) {
          if ((mpy+GRAFIK_HEIGHT(mouse_pointer)>=i2) && (mpy<=i2+GRAFIK_HEIGHT(sunnyboy))) {
            sunny_hit=40;  /* sunny boy has been hit */
          }
        }
      }
    }
 
    /* flush data to window */
    flush_window();
    wait_time(50);  /* wait up to 50 milliseconds */

  } while (IS_KEYS(KEY_SPACE)==0);  /* while space key is not pressed */

  /* free graphic boxes */
  free_grafik(sunnyhit);
  free_grafik(sunnyboy);
  free_grafik(mouse_pointer);

  /* do ending */
  close_window();
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
