/* *****************************************************************
   Copyright (C) 2000-2004 Kurt Nienhaus

   This program is modifiable/redistributable under the terms
   of the GNU General Public Licence as mentioned in vgagames.c.
   ***************************************************************** */

/* Simple program for showing a graphic file until pressing space key */

/* define SAVE_AS_PPM, if graphic to be saved as ppm file */
/* #define SAVE_AS_PPM */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <vgagames.h>

int get_opt(int,char *[]);
int get_space(int);
void end_err(const char *,const char *);


int main(int argc,char * argv[]) {
  /* variables */
  grafik * grf;
  int i1;

  /* open window */
  if (open_window("Look",get_opt(argc,argv))==-1) {
    fprintf(stderr,"%s: %s\n",argv[0],errmsg);
    exit(1);
  }

  /* load graphic */
  grf=NULL;
  for (i1=1;i1<argc;i1++) {
    if (argv[i1][0]!='-') {
      if ((grf=load_grafik(argv[i1]))==NULL) {
        end_err(argv[0],"load graphic");
      } else {break;}
    }
  }
  if (grf==NULL) {
    snprintf(errmsg,sizeof(errmsg),"\nCall: %s <graphic file>",argv[0]);
    end_err(argv[0],"no graphic found to load");
  }

  copy_grafik(NULL,(SC_WIDTH-GRAFIK_WIDTH(grf))/2,(SC_HEIGHT-GRAFIK_HEIGHT(grf))/2,grf,0,0,0,0,RGB_FULL);
  flush_window();
  printf("graphic width,height: %d,%d\n",GRAFIK_WIDTH(grf),GRAFIK_HEIGHT(grf));
  get_space(0);

#ifdef SAVE_AS_PPM
  /* save graphic as ppm file */
  save_grafik_as_ppm(grf,"/tmp/_vgag_p6.ppm");  /* P6 */
  save_grafik_as_ppm3(grf,"/tmp/_vgag_p3.ppm");  /* P3 */
#endif

  /* free graphic box */
  free_grafik(grf);

  /* do ending */
  close_window();
#ifdef SAVE_AS_PPM
  printf("Saved as ppm file: /tmp/_vgag_p6.ppm and /tmp/_vgag_p3.ppm\n");
#endif
  exit(0);
}


int get_opt(int argc,char * argv[]) {
/* examinate how to open window
** parameters: "-f"=full window, "-1" to "-3"=scaling factor 1 to 3
*/
  int winflag=0;
#ifdef WINDOW_RESIZABLE  /* we can change window size */
  int i1;
  for (i1=1;i1<argc;i1++) {  /* find scaling factor */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'1')!=NULL) {winflag=VGAWINDOW_1; break;}
      else if (strchr(argv[i1]+1,'2')!=NULL) {winflag=VGAWINDOW_2; break;}
      else if (strchr(argv[i1]+1,'3')!=NULL) {winflag=VGAWINDOW_3; break;}
    }
  }
  for (i1=1;i1<argc;i1++) {  /* full window? */
    if (argv[i1][0]=='-') {
      if (strchr(argv[i1]+1,'f')!=NULL) {winflag+=VGAWINDOW_FULL; break;}
    }
  }
#endif  /* WINDOW_RESIZABLE */
  return(winflag);
}


int get_space(int flag) {
/* check for pressing space key */
  static int first=1;
  if (first==1) {
    CLEAR_KEYS;
    ADD_KEYS(KEY_SPACE,SHORT_KEY);
    first=0;
  }
  if (flag==0) {
    clearstate();
  }
  do {
    get_keys();
    wait_time(flag==0?100:flag);
    if (flag>0) {break;}
  } while (IS_KEYS(KEY_SPACE)==0);
  return(IS_KEYS(KEY_SPACE));
}


void end_err(const char * prg,const char * msg) {
/* exit with an error messages */
  close_window();
  fprintf(stderr,"%s: %s: %s\n",prg,msg,errmsg);
  exit(1);
}
